/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor.ui;

import com.formdev.flatlaf.intellijthemes.FlatAllIJThemes;
import is.codion.common.model.CancelException;
import is.codion.common.model.UserPreferences;
import is.codion.common.rmi.client.Clients;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.swing.common.ui.UiManagerDefaults;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.tabbedpane.TabbedPaneBuilder;
import is.codion.swing.common.ui.component.text.MemoryUsageField;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.ExceptionDialogBuilder;
import is.codion.swing.common.ui.dialog.FileSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.icon.Logos;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.framework.server.monitor.EntityServerMonitor;
import is.codion.swing.framework.server.monitor.HostMonitor;
import is.codion.swing.framework.server.monitor.ui.HostMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityServerMonitorPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityServerMonitorPanel.class);
    private static final String JDK_PREFERENCE_KEY = EntityServerMonitorPanel.class.getSimpleName() + ".jdkPathPreferenceKey";
    private static final double SCREEN_SIZE_RATIO = 0.75;
    private static final int MEMORY_USAGE_UPDATE_INTERVAL_MS = 2000;
    private static String jdkDir = UserPreferences.getUserPreference((String)JDK_PREFERENCE_KEY, null);
    private final State alwaysOnTopState = State.state();
    private final EntityServerMonitor model;
    private JFrame monitorFrame;

    public EntityServerMonitorPanel() throws RemoteException {
        this(new EntityServerMonitor((String)Clients.SERVER_HOSTNAME.get(), (Integer)ServerConfiguration.REGISTRY_PORT.get(), EntityServerMonitorPanel.adminUser()));
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> Dialogs.displayExceptionDialog((Throwable)e, (Window)Utilities.parentWindow((Component)this)));
    }

    public EntityServerMonitorPanel(EntityServerMonitor model) throws RemoteException {
        this.model = model;
        this.initializeUI();
        this.bindEvents();
    }

    public EntityServerMonitor model() {
        return this.model;
    }

    public State alwaysOnTop() {
        return this.alwaysOnTopState;
    }

    public void runJConsole() throws IOException {
        if (jdkDir == null) {
            this.setJDKDir();
            if (jdkDir == null) {
                throw new IllegalStateException("No JDK home directory has been specified");
            }
        }
        new ProcessBuilder(jdkDir + File.separator + "bin" + File.separator + "jconsole").start();
    }

    public void setJDKDir() {
        EntityServerMonitorPanel.setJDKDir(this);
    }

    public void refresh() throws RemoteException {
        this.model.refresh();
    }

    public void showFrame() {
        this.monitorFrame = Windows.frame((JComponent)this).icon(Logos.logoRed()).menuBar(Components.menu((Controls)this.createMainMenuControls()).createMenuBar()).title("Codion Server Monitor").defaultCloseOperation(3).size(Windows.screenSizeRatio((double)0.75)).centerFrame(true).show();
    }

    public static synchronized void setJDKDir(JComponent dialogParent) {
        try {
            jdkDir = ((FileSelectionDialogBuilder)((FileSelectionDialogBuilder)Dialogs.fileSelectionDialog().owner((Component)dialogParent)).startDirectory(jdkDir).title("Set JDK home")).selectDirectory().getAbsolutePath();
            UserPreferences.setUserPreference((String)JDK_PREFERENCE_KEY, (String)jdkDir);
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void initializeUI() throws RemoteException {
        TabbedPaneBuilder tabbedPaneBuilder = Components.tabbedPane();
        for (HostMonitor hostMonitor : this.model.hostMonitors()) {
            tabbedPaneBuilder.tab(hostMonitor.hostName() + ":" + hostMonitor.registryPort(), (JComponent)new HostMonitorPanel(hostMonitor));
        }
        this.setLayout(new BorderLayout());
        int gap = (Integer)Layouts.GAP.get();
        this.setBorder(BorderFactory.createEmptyBorder(gap, gap, 0, gap));
        this.add((Component)tabbedPaneBuilder.build(), "Center");
        this.add((Component)EntityServerMonitorPanel.createSouthPanel(), "South");
    }

    private Controls createMainMenuControls() {
        return Controls.builder().control((Control.Builder)Controls.builder().name("File").mnemonic('F').control(EntityServerMonitorPanel.createExitControl())).control((Control.Builder)Controls.builder().name("View").mnemonic('V').control(this.createRefreshControl()).control(this.createUpateIntervalControl()).control(this.createClearChartsControl()).separator().control(Dialogs.lookAndFeelSelectionDialog().owner((JComponent)this).userPreferencePropertyName(EntityServerMonitorPanel.class.getName()).createControl()).control(this.createAlwaysOnTopControl())).control((Control.Builder)Controls.builder().name("Tools").mnemonic('T').control(this.createSetJDKDirControl()).control(this.createJConsoleControl())).build();
    }

    private Control createRefreshControl() {
        return Control.builder(this.model::refresh).name("Refresh").mnemonic('R').build();
    }

    private Control createAlwaysOnTopControl() {
        return ToggleControl.builder((State)this.alwaysOnTopState).name("Always on Top").mnemonic('A').build();
    }

    private Control createUpateIntervalControl() {
        return Control.builder(this::setUpdateInterval).name("Chart update interval...").build();
    }

    private Control createClearChartsControl() {
        return Control.builder(this.model::clearCharts).name("Clear charts").build();
    }

    private Control createSetJDKDirControl() {
        return Control.builder(this::setJDKDir).name("Set JDK home...").mnemonic('S').build();
    }

    private Control createJConsoleControl() {
        return Control.builder(this::runJConsole).name("Run JConsole").mnemonic('J').build();
    }

    private void setUpdateInterval() {
        NumberField field = (NumberField)((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)Components.integerField().initialValue((Object)5)).columns(6)).minimumValue((Number)1.0).horizontalAlignment(0)).selectAllOnFocusGained(true)).build();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)Dialogs.okCancelDialog((JComponent)Components.flowLayoutPanel((int)1).add((JComponent)field).build()).owner((Component)this)).title("Update interval (s)")).onOk(() -> this.model().setUpdateInterval((Integer)field.getNumber())).show();
    }

    private void bindEvents() {
        this.alwaysOnTopState.addDataListener(alwaysOnTop -> {
            if (this.monitorFrame != null) {
                this.monitorFrame.setAlwaysOnTop((boolean)alwaysOnTop);
            }
        });
    }

    private static Control createExitControl() {
        return Control.builder(() -> System.exit(0)).name("Exit").mnemonic('X').build();
    }

    private static JPanel createSouthPanel() {
        return (JPanel)((PanelBuilder)Components.flowLayoutPanel((int)4).border(BorderFactory.createEtchedBorder())).add((JComponent)new JLabel("Memory usage:")).add((JComponent)new MemoryUsageField(2000)).build();
    }

    private static User adminUser() {
        return User.parse((String)((String)ServerConfiguration.ADMIN_USER.getOrThrow()));
    }

    public static void main(String[] arguments) {
        UiManagerDefaults.initialize();
        Clients.resolveTrustStore();
        Arrays.stream(FlatAllIJThemes.INFOS).forEach(LookAndFeelProvider::addLookAndFeelProvider);
        SwingUtilities.invokeLater(() -> {
            try {
                LookAndFeelProvider.findLookAndFeelProvider((String)LookAndFeelProvider.defaultLookAndFeelName((String)EntityServerMonitorPanel.class.getName())).ifPresent(LookAndFeelProvider::enable);
                new EntityServerMonitorPanel().showFrame();
            }
            catch (Exception exception) {
                LOG.error(exception.getMessage(), (Throwable)exception);
                ((ExceptionDialogBuilder)Dialogs.exceptionDialog().title("Error during startup")).show((Throwable)exception);
                System.exit(1);
            }
        });
    }
}

