/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor.ui;

import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.framework.server.monitor.DatabaseMonitor;
import is.codion.swing.framework.server.monitor.ui.ChartUtil;
import is.codion.swing.framework.server.monitor.ui.PoolMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

public final class DatabaseMonitorPanel
extends JPanel {
    private static final int SPINNER_COLUMNS = 3;
    private final DatabaseMonitor model;
    private final JFreeChart queriesPerSecondChart = ChartFactory.createXYStepChart(null, null, null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    private final ChartPanel queriesPerSecondChartPanel = new ChartPanel(this.queriesPerSecondChart);

    public DatabaseMonitorPanel(DatabaseMonitor model) {
        this.model = Objects.requireNonNull(model);
        this.queriesPerSecondChart.getXYPlot().setDataset(model.queriesPerSecondCollection());
        ChartUtil.linkColors(this, this.queriesPerSecondChart);
        this.initializeUI();
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)Components.tabbedPane().tab("Connection Pools", (JComponent)new PoolMonitorPanel(this.model.connectionPoolMonitor())).tab("Performance", (JComponent)this.chartPanel()).build(), "Center");
    }

    private JPanel chartPanel() {
        JPanel chartConfig = (JPanel)((PanelBuilder)Components.flexibleGridLayoutPanel((int)1, (int)3).border((Border)BorderFactory.createTitledBorder("Charts"))).add((JComponent)new JLabel("Update interval (s)")).add(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(this.model.updateInterval()).minimum((Number)1).columns(3)).editable(false)).build()).add(Components.button((Control)Control.control(this.model::clearStatistics)).text("Clear").build()).build();
        this.queriesPerSecondChartPanel.setBorder(BorderFactory.createEtchedBorder());
        return (JPanel)Components.borderLayoutPanel().centerComponent((JComponent)this.queriesPerSecondChartPanel).southComponent(Components.borderLayoutPanel().westComponent((JComponent)chartConfig).build()).build();
    }
}

