/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.server.monitor;

import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.user.User;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.swing.framework.server.monitor.ConnectionPoolMonitor;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.sql.DataSource;

public final class PoolMonitor {
    private final EntityServerAdmin server;
    private final Collection<ConnectionPoolMonitor> connectionPoolMonitors = new ArrayList<ConnectionPoolMonitor>();

    public PoolMonitor(EntityServerAdmin server, int updateRate) throws RemoteException {
        this.server = Objects.requireNonNull(server);
        for (String username : this.server.connectionPoolUsernames()) {
            this.connectionPoolMonitors.add(new ConnectionPoolMonitor(new MonitorPoolWrapper(username, this.server), updateRate));
        }
    }

    public Collection<ConnectionPoolMonitor> connectionPoolInstanceMonitors() {
        return this.connectionPoolMonitors;
    }

    public void shutdown() {
        for (ConnectionPoolMonitor monitor : this.connectionPoolMonitors) {
            monitor.shutdown();
        }
    }

    private static final class MonitorPoolWrapper
    implements ConnectionPoolWrapper {
        private final EntityServerAdmin server;
        private final User user;

        private MonitorPoolWrapper(String username, EntityServerAdmin server) {
            this.user = User.user((String)username);
            this.server = server;
        }

        public int getMaximumPoolSize() {
            try {
                return this.server.getMaximumConnectionPoolSize(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public int getMinimumPoolSize() {
            try {
                return this.server.getMinimumConnectionPoolSize(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public int getCleanupInterval() {
            try {
                return this.server.getConnectionPoolCleanupInterval(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public int getIdleConnectionTimeout() {
            try {
                return this.server.getPooledConnectionIdleTimeout(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            if (maximumPoolSize < 0) {
                throw new IllegalArgumentException("Maximum pool size must be a positive integer");
            }
            if (maximumPoolSize < this.getMinimumPoolSize()) {
                throw new IllegalArgumentException("Maximum pool size must be equal to or exceed minimum pool size");
            }
            try {
                this.server.setMaximumConnectionPoolSize(this.user.username(), maximumPoolSize);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setMinimumPoolSize(int minimumPoolSize) {
            if (minimumPoolSize < 0) {
                throw new IllegalArgumentException("Minimum pool size must be a positive integer");
            }
            if (minimumPoolSize > this.getMaximumPoolSize()) {
                throw new IllegalArgumentException("Minimum pool size equal to or below maximum pool size time");
            }
            try {
                this.server.setMinimumConnectionPoolSize(this.user.username(), minimumPoolSize);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setIdleConnectionTimeout(int idleConnectionTimeout) {
            if (idleConnectionTimeout < 0) {
                throw new IllegalArgumentException("Idle connection timeout must be a positive integer");
            }
            try {
                this.server.setPooledConnectionIdleTimeout(this.user.username(), idleConnectionTimeout);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public int getMaximumCheckOutTime() {
            try {
                return this.server.getMaximumPoolCheckOutTime(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setMaximumCheckOutTime(int maximumCheckOutTime) {
            if (maximumCheckOutTime < 0) {
                throw new IllegalArgumentException("Maximum check out time must be a positive integer");
            }
            try {
                this.server.setMaximumPoolCheckOutTime(this.user.username(), maximumCheckOutTime);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setCleanupInterval(int poolCleanupInterval) {
            if (poolCleanupInterval < 0) {
                throw new IllegalArgumentException("Cleanup interval must be a positive integer");
            }
            try {
                this.server.setConnectionPoolCleanupInterval(this.user.username(), poolCleanupInterval);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public ConnectionPoolStatistics statistics(long since) {
            try {
                return this.server.connectionPoolStatistics(this.user.username(), since);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public User user() {
            return this.user;
        }

        public boolean isCollectSnapshotStatistics() {
            try {
                return this.server.isCollectPoolSnapshotStatistics(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setCollectSnapshotStatistics(boolean collectSnapshotStatistics) {
            try {
                this.server.setCollectPoolSnapshotStatistics(this.user.username(), collectSnapshotStatistics);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isCollectCheckOutTimes() {
            try {
                return this.server.isCollectPoolCheckOutTimes(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void setCollectCheckOutTimes(boolean collectCheckOutTimes) {
            try {
                this.server.setCollectPoolCheckOutTimes(this.user.username(), collectCheckOutTimes);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void resetStatistics() {
            try {
                this.server.resetConnectionPoolStatistics(this.user.username());
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public Connection connection(User user) {
            return null;
        }

        public DataSource poolDataSource() {
            return null;
        }

        public void close() {
        }
    }
}

