/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.Operator;
import is.codion.common.event.EventObserver;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class SwingForeignKeyConditionModel
implements ColumnConditionModel<Attribute<?>, Entity> {
    private final ColumnConditionModel<ForeignKey, Entity> conditionModel;
    private final EntityComboBoxModel equalComboBoxModel;
    private final EntitySearchModel inSearchModel;
    private boolean updatingModel = false;

    private SwingForeignKeyConditionModel(DefaultBuilder builder) {
        this.conditionModel = ColumnConditionModel.builder((Object)builder.foreignKey, Entity.class).operators(builder.operators()).build();
        this.inSearchModel = builder.inSearchModel;
        this.equalComboBoxModel = builder.equalComboBoxModel;
        this.bindEvents();
    }

    public EntityComboBoxModel equalComboBoxModel() {
        if (this.equalComboBoxModel == null) {
            throw new IllegalStateException("equalComboBoxModel is not available");
        }
        return this.equalComboBoxModel;
    }

    public EntitySearchModel inSearchModel() {
        if (this.inSearchModel == null) {
            throw new IllegalStateException("inSearchModel is not available");
        }
        return this.inSearchModel;
    }

    public Attribute<?> columnIdentifier() {
        return (Attribute)this.conditionModel.columnIdentifier();
    }

    public State caseSensitive() {
        return this.conditionModel.caseSensitive();
    }

    public Format format() {
        return this.conditionModel.format();
    }

    public String dateTimePattern() {
        return this.conditionModel.dateTimePattern();
    }

    public Value<ColumnConditionModel.AutomaticWildcard> automaticWildcard() {
        return this.conditionModel.automaticWildcard();
    }

    public State autoEnable() {
        return this.conditionModel.autoEnable();
    }

    public State locked() {
        return this.conditionModel.locked();
    }

    public Class<Entity> columnClass() {
        return this.conditionModel.columnClass();
    }

    public void setEqualValue(Entity value) {
        this.conditionModel.setEqualValue((Object)value);
    }

    public Entity getEqualValue() {
        return (Entity)this.conditionModel.getEqualValue();
    }

    public void setInValues(Collection<Entity> values) {
        this.conditionModel.setInValues(values);
    }

    public Collection<Entity> getInValues() {
        return this.conditionModel.getInValues();
    }

    public void setUpperBound(Entity upper) {
        this.conditionModel.setUpperBound((Object)upper);
    }

    public Entity getUpperBound() {
        return (Entity)this.conditionModel.getUpperBound();
    }

    public void setLowerBound(Entity value) {
        this.conditionModel.setLowerBound((Object)value);
    }

    public Entity getLowerBound() {
        return (Entity)this.conditionModel.getLowerBound();
    }

    public List<Operator> operators() {
        return this.conditionModel.operators();
    }

    public char wildcard() {
        return this.conditionModel.wildcard();
    }

    public State enabled() {
        return this.conditionModel.enabled();
    }

    public void clear() {
        this.conditionModel.clear();
    }

    public Value<Entity> equalValue() {
        return this.conditionModel.equalValue();
    }

    public ValueSet<Entity> inValues() {
        return this.conditionModel.inValues();
    }

    public Value<Entity> upperBoundValue() {
        return this.conditionModel.upperBoundValue();
    }

    public Value<Entity> lowerBoundValue() {
        return this.conditionModel.lowerBoundValue();
    }

    public Value<Operator> operator() {
        return this.conditionModel.operator();
    }

    public boolean accepts(Comparable<Entity> columnValue) {
        return this.conditionModel.accepts(columnValue);
    }

    public EventObserver<?> conditionChangedEvent() {
        return this.conditionModel.conditionChangedEvent();
    }

    public static Builder builder(ForeignKey foreignKey) {
        return new DefaultBuilder(foreignKey);
    }

    private void bindEvents() {
        if (this.equalComboBoxModel != null) {
            this.equalComboBoxModel.selectionEvent().addConsumer((Consumer)new SetEqualValue());
            this.equalValue().addConsumer((Consumer)new SelectEqualValue());
            this.equalComboBoxModel.refresher().refreshEvent().addListener(() -> this.equalComboBoxModel.setSelectedItem(this.getEqualValue()));
        }
        if (this.inSearchModel != null) {
            this.inSearchModel.entities().addConsumer((Consumer)new SetInValues());
            this.inValues().addConsumer((Consumer)new SelectInValues());
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final ForeignKey foreignKey;
        private EntityComboBoxModel equalComboBoxModel;
        private EntitySearchModel inSearchModel;

        private DefaultBuilder(ForeignKey foreignKey) {
            this.foreignKey = Objects.requireNonNull(foreignKey);
        }

        @Override
        public Builder includeEqualOperators(EntityComboBoxModel equalComboBoxModel) {
            this.equalComboBoxModel = Objects.requireNonNull(equalComboBoxModel);
            return this;
        }

        @Override
        public Builder includeInOperators(EntitySearchModel inSearchModel) {
            this.inSearchModel = Objects.requireNonNull(inSearchModel);
            return this;
        }

        @Override
        public SwingForeignKeyConditionModel build() {
            return new SwingForeignKeyConditionModel(this);
        }

        private List<Operator> operators() {
            if (this.equalComboBoxModel == null && this.inSearchModel == null) {
                throw new IllegalStateException("You must specify either an equalComboBoxModel or an inSearchModel");
            }
            if (this.equalComboBoxModel != null && this.inSearchModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.IN, Operator.NOT_IN);
            }
            if (this.equalComboBoxModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL);
            }
            return Arrays.asList(Operator.IN, Operator.NOT_IN);
        }
    }

    private final class SetEqualValue
    implements Consumer<Entity> {
        private SetEqualValue() {
        }

        @Override
        public void accept(Entity selectedEntity) {
            if (!SwingForeignKeyConditionModel.this.updatingModel) {
                SwingForeignKeyConditionModel.this.setEqualValue(selectedEntity);
            }
        }
    }

    private final class SelectEqualValue
    implements Consumer<Entity> {
        private SelectEqualValue() {
        }

        @Override
        public void accept(Entity equalValue) {
            SwingForeignKeyConditionModel.this.updatingModel = true;
            try {
                SwingForeignKeyConditionModel.this.equalComboBoxModel.setSelectedItem(equalValue);
            }
            finally {
                SwingForeignKeyConditionModel.this.updatingModel = false;
            }
        }
    }

    private final class SetInValues
    implements Consumer<Set<Entity>> {
        private SetInValues() {
        }

        @Override
        public void accept(Set<Entity> selectedEntities) {
            if (!SwingForeignKeyConditionModel.this.updatingModel) {
                SwingForeignKeyConditionModel.this.setInValues(selectedEntities);
            }
        }
    }

    private final class SelectInValues
    implements Consumer<Set<Entity>> {
        private SelectInValues() {
        }

        @Override
        public void accept(Set<Entity> inValues) {
            SwingForeignKeyConditionModel.this.updatingModel = true;
            try {
                SwingForeignKeyConditionModel.this.inSearchModel.entities().set(inValues);
            }
            finally {
                SwingForeignKeyConditionModel.this.updatingModel = false;
            }
        }
    }

    public static interface Builder {
        public Builder includeEqualOperators(EntityComboBoxModel var1);

        public Builder includeInOperators(EntitySearchModel var1);

        public SwingForeignKeyConditionModel build();
    }
}

