/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.Conjunction;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.event.EventObserver;
import is.codion.common.model.FilterModel;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityEditEvents;
import is.codion.framework.model.EntityTableConditionModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSelectionModel;
import is.codion.swing.framework.model.SwingEntityConditionModelFactory;
import is.codion.swing.framework.model.SwingEntityEditModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SwingEntityTableModel
implements EntityTableModel<SwingEntityEditModel>,
FilterTableModel<Entity, Attribute<?>> {
    private final FilterTableModel<Entity, Attribute<?>> tableModel;
    private final SwingEntityEditModel editModel;
    private final EntityTableConditionModel conditionModel;
    private final ValueSet<Attribute<?>> attributes = ((ValueSet.Builder)ValueSet.builder().validator((Value.Validator)new AttributeValidator())).build();
    private final State conditionRequired = State.state();
    private final State handleEditEvents = State.builder().consumer((Consumer)new HandleEditEventsChanged()).build();
    private final State editable = State.state();
    private final Value<Integer> limit = Value.value();
    private final Value<OrderBy> orderBy;
    private final State removeDeleted = State.state((boolean)true);
    private final Value<EntityTableModel.OnInsert> onInsert = Value.nonNull((Object)((EntityTableModel.OnInsert)EntityTableModel.ON_INSERT.get())).build();
    private final Map<String, Color> colorCache = new ConcurrentHashMap<String, Color>();
    private final State conditionChanged = State.state();
    private final Consumer<Map<Entity.Key, Entity>> updateListener = new UpdateListener();
    private EntityConnection.Select refreshCondition;

    public SwingEntityTableModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this(new SwingEntityEditModel(entityType, connectionProvider));
    }

    public SwingEntityTableModel(EntityTableConditionModel conditionModel) {
        this(new SwingEntityEditModel(Objects.requireNonNull(conditionModel).entityType(), conditionModel.connectionProvider()), conditionModel);
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel) {
        this(editModel, EntityTableConditionModel.entityTableConditionModel((EntityType)editModel.entityType(), (EntityConnectionProvider)editModel.connectionProvider(), (ColumnConditionModel.Factory)new SwingEntityConditionModelFactory(editModel.connectionProvider())));
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel, EntityTableConditionModel conditionModel) {
        this.editModel = Objects.requireNonNull(editModel);
        this.conditionModel = Objects.requireNonNull(conditionModel);
        if (!editModel.entityType().equals(conditionModel.entityType())) {
            throw new IllegalArgumentException("Entity type mismatch, edit model: " + editModel.entities() + ", condition model: " + conditionModel.entityType());
        }
        this.tableModel = this.createTableModel(editModel.entityDefinition());
        this.orderBy = this.createOrderBy();
        this.refreshCondition = this.createSelect(conditionModel);
        this.bindEvents();
        this.handleEditEvents.set((Object)((Boolean)HANDLE_EDIT_EVENTS.get()));
    }

    public final Entities entities() {
        return this.editModel.connectionProvider().entities();
    }

    public final EntityDefinition entityDefinition() {
        return this.editModel.entityDefinition();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.editModel.entityType();
    }

    public final ValueSet<Attribute<?>> attributes() {
        return this.attributes;
    }

    public final Value<Integer> limit() {
        return this.limit;
    }

    public final Value<OrderBy> orderBy() {
        return this.orderBy;
    }

    public final State conditionRequired() {
        return this.conditionRequired;
    }

    public final Value<EntityTableModel.OnInsert> onInsert() {
        return this.onInsert;
    }

    public final State removeDeleted() {
        return this.removeDeleted;
    }

    public final State handleEditEvents() {
        return this.handleEditEvents;
    }

    public final EntityType entityType() {
        return this.editModel.entityType();
    }

    public final EntityTableConditionModel conditionModel() {
        return this.conditionModel;
    }

    public final <C extends SwingEntityEditModel> C editModel() {
        return (C)((Object)this.editModel);
    }

    public final EntityConnectionProvider connectionProvider() {
        return this.editModel.connectionProvider();
    }

    public final EntityConnection connection() {
        return this.editModel.connection();
    }

    public final State editable() {
        return this.editable;
    }

    public boolean isCellEditable(int rowIndex, int modelColumnIndex) {
        if (!((Boolean)this.editable.get()).booleanValue() || ((Boolean)this.editModel.readOnly().get()).booleanValue() || !((Boolean)this.editModel.updateEnabled().get()).booleanValue()) {
            return false;
        }
        Attribute attribute = (Attribute)this.columns().identifier(modelColumnIndex);
        if (attribute instanceof ForeignKey) {
            return this.entityDefinition().foreignKeys().updatable((ForeignKey)attribute);
        }
        AttributeDefinition attributeDefinition = this.entityDefinition().attributes().definition(attribute);
        return attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).updatable();
    }

    public final void setValueAt(Object value, int rowIndex, int modelColumnIndex) {
        if (!((Boolean)this.editable.get()).booleanValue() || ((Boolean)this.editModel.readOnly().get()).booleanValue() || !((Boolean)this.editModel.updateEnabled().get()).booleanValue()) {
            throw new IllegalStateException("This table model is readOnly or has disabled update");
        }
        Entity entity = this.itemAt(rowIndex).copy();
        entity.put((Attribute)this.columns().identifier(modelColumnIndex), value);
        try {
            if (entity.modified()) {
                this.editModel.update(Collections.singletonList(entity));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Color backgroundColor(int row, Attribute<?> attribute) {
        Objects.requireNonNull(attribute);
        Object color = this.entityDefinition().backgroundColorProvider().color(this.itemAt(row), attribute);
        return color == null ? null : this.toColor(color);
    }

    public Color foregroundColor(int row, Attribute<?> attribute) {
        Objects.requireNonNull(attribute);
        Object color = this.entityDefinition().foregroundColorProvider().color(this.itemAt(row), attribute);
        return color == null ? null : this.toColor(color);
    }

    public final Optional<Entity> find(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        return this.visibleItems().stream().filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    public final int indexOf(Entity.Key primaryKey) {
        return this.find(primaryKey).map(this::indexOf).orElse(-1);
    }

    public final void replace(Collection<Entity> entities) {
        this.replaceEntitiesByKey(Entity.mapToPrimaryKey(entities));
    }

    public final void refresh(Collection<Entity.Key> keys) {
        try {
            this.replace(this.connection().select(keys));
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public final void replace(ForeignKey foreignKey, Collection<Entity> foreignKeyValues) {
        Objects.requireNonNull(foreignKey, "foreignKey");
        Objects.requireNonNull(foreignKeyValues, "foreignKeyValues");
        this.entityDefinition().foreignKeys().definition(foreignKey);
        for (Entity entity : this.filteredItems()) {
            for (Entity foreignKeyValue : foreignKeyValues) {
                SwingEntityTableModel.replace(foreignKey, entity, foreignKeyValue);
            }
        }
        for (int i = 0; i < this.visibleItems().size(); ++i) {
            Entity entity;
            entity = this.visibleItems().get(i);
            for (Entity foreignKeyValue : foreignKeyValues) {
                if (!SwingEntityTableModel.replace(foreignKey, entity, foreignKeyValue)) continue;
                this.fireTableRowsUpdated(i, i);
            }
        }
    }

    private static boolean replace(ForeignKey foreignKey, Entity entity, Entity foreignKeyValue) {
        Entity currentForeignKeyValue = entity.entity(foreignKey);
        if (currentForeignKeyValue != null && currentForeignKeyValue.equals(foreignKeyValue)) {
            entity.put((Attribute)foreignKey, (Object)foreignKeyValue.immutable());
            return true;
        }
        return false;
    }

    public final void select(Collection<Entity.Key> keys) {
        this.selectionModel().setSelectedItems((Predicate)new SelectByKeyPredicate(Objects.requireNonNull(keys, "keys")));
    }

    public final Collection<Entity> find(Collection<Entity.Key> keys) {
        Objects.requireNonNull(keys, "keys");
        return this.items().stream().filter(entity -> keys.contains(entity.primaryKey())).collect(Collectors.toList());
    }

    public final Collection<Entity> deleteSelected() throws DatabaseException {
        return this.editModel.delete(this.selectionModel().getSelectedItems());
    }

    public final StateObserver conditionChanged() {
        return this.conditionChanged.observer();
    }

    public final EventObserver<?> selectionEvent() {
        return this.selectionModel().selectionEvent();
    }

    public final void filterItems() {
        this.tableModel.filterItems();
    }

    public final Value<Predicate<Entity>> includeCondition() {
        return this.tableModel.includeCondition();
    }

    public final Collection<Entity> items() {
        return this.tableModel.items();
    }

    public final List<Entity> visibleItems() {
        return this.tableModel.visibleItems();
    }

    public final Collection<Entity> filteredItems() {
        return this.tableModel.filteredItems();
    }

    public final int visibleCount() {
        return this.tableModel.visibleCount();
    }

    public final int filteredCount() {
        return this.tableModel.filteredCount();
    }

    public final boolean containsItem(Entity item) {
        return this.tableModel.containsItem((Object)item);
    }

    public final boolean visible(Entity item) {
        return this.tableModel.visible((Object)item);
    }

    public final boolean filtered(Entity item) {
        return this.tableModel.filtered((Object)item);
    }

    public final FilterModel.Refresher<Entity> refresher() {
        return this.tableModel.refresher();
    }

    public final void refresh() {
        this.tableModel.refresh();
    }

    public final void refreshThen(Consumer<Collection<Entity>> afterRefresh) {
        this.tableModel.refreshThen(afterRefresh);
    }

    public final void clear() {
        this.tableModel.clear();
    }

    public final int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public final int indexOf(Entity item) {
        return this.tableModel.indexOf((Object)item);
    }

    public final Entity itemAt(int rowIndex) {
        return (Entity)this.tableModel.itemAt(rowIndex);
    }

    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    public final String getStringAt(int rowIndex, Attribute<?> columnIdentifier) {
        return this.tableModel.getStringAt(rowIndex, columnIdentifier);
    }

    public final void addItems(Collection<Entity> items) {
        this.tableModel.addItems(items);
    }

    public final void addItemsSorted(Collection<Entity> items) {
        this.tableModel.addItemsSorted(items);
    }

    public final void addItemsAt(int index, Collection<Entity> items) {
        this.tableModel.addItemsAt(index, items);
    }

    public final void addItemsAtSorted(int index, Collection<Entity> items) {
        this.tableModel.addItemsAtSorted(index, items);
    }

    public final void addItem(Entity item) {
        this.tableModel.addItem((Object)item);
    }

    public final void addItemAt(int index, Entity item) {
        this.tableModel.addItemAt(index, (Object)item);
    }

    public final void addItemSorted(Entity item) {
        this.tableModel.addItemSorted((Object)item);
    }

    public final void setItemAt(int index, Entity item) {
        this.tableModel.setItemAt(index, (Object)item);
    }

    public final void removeItems(Collection<Entity> items) {
        this.tableModel.removeItems(items);
    }

    public final void removeItem(Entity item) {
        this.tableModel.removeItem((Object)item);
    }

    public final Entity removeItemAt(int index) {
        return (Entity)this.tableModel.removeItemAt(index);
    }

    public final List<Entity> removeItems(int fromIndex, int toIndex) {
        return this.tableModel.removeItems(fromIndex, toIndex);
    }

    public final void fireTableDataChanged() {
        this.tableModel.fireTableDataChanged();
    }

    public void fireTableRowsUpdated(int fromIndex, int toIndex) {
        this.tableModel.fireTableRowsUpdated(fromIndex, toIndex);
    }

    public final <T> Collection<T> values(Attribute<?> columnIdentifier) {
        return this.tableModel.values(columnIdentifier);
    }

    public final Class<?> getColumnClass(Attribute<?> columnIdentifier) {
        return this.tableModel.getColumnClass(columnIdentifier);
    }

    public final <T> Collection<T> selectedValues(Attribute<?> columnIdentifier) {
        return this.tableModel.selectedValues(columnIdentifier);
    }

    public final Value<FilterTableModel.RefreshStrategy> refreshStrategy() {
        return this.tableModel.refreshStrategy();
    }

    public final void sortItems() {
        this.tableModel.sortItems();
    }

    public final FilterTableSelectionModel<Entity> selectionModel() {
        return this.tableModel.selectionModel();
    }

    public final TableConditionModel<Attribute<?>> filterModel() {
        return this.tableModel.filterModel();
    }

    public final int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public final String getColumnName(int columnIndex) {
        return this.tableModel.getColumnName(columnIndex);
    }

    public final Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    public final EventObserver<?> dataChangedEvent() {
        return this.tableModel.dataChangedEvent();
    }

    public final EventObserver<?> clearedEvent() {
        return this.tableModel.clearedEvent();
    }

    public final void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    public final void removeTableModelListener(TableModelListener listener) {
        this.tableModel.removeTableModelListener(listener);
    }

    public FilterTableModel.Columns<Entity, Attribute<?>> columns() {
        return this.tableModel.columns();
    }

    public Value<Comparator<Entity>> comparator() {
        return this.tableModel.comparator();
    }

    public static SwingEntityTableModel tableModel(final Collection<Entity> entities, EntityConnectionProvider connectionProvider) {
        if (Objects.requireNonNull(entities).isEmpty()) {
            throw new IllegalArgumentException("One or more entities is required for a static table model");
        }
        SwingEntityTableModel tableModel = new SwingEntityTableModel(entities.iterator().next().entityType(), connectionProvider){

            @Override
            protected Collection<Entity> refreshItems() {
                return entities;
            }
        };
        tableModel.refresh();
        return tableModel;
    }

    protected Collection<Entity> refreshItems() {
        try {
            return this.queryItems();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean conditionEnabled(EntityTableConditionModel conditionModel) {
        return conditionModel.enabled();
    }

    protected Color toColor(Object color) {
        Objects.requireNonNull(color);
        if (color instanceof Color) {
            return (Color)color;
        }
        if (color instanceof String) {
            return this.colorCache.computeIfAbsent((String)color, Color::decode);
        }
        throw new IllegalArgumentException("Unsupported Color representation: " + color);
    }

    private void bindEvents() {
        this.conditionModel.conditionChangedEvent().addListener(() -> this.onConditionChanged(this.createSelect(this.conditionModel)));
        this.editModel.afterInsertEvent().addConsumer(this::onInsert);
        this.editModel.afterUpdateEvent().addConsumer(this::onUpdate);
        this.editModel.afterDeleteEvent().addConsumer(this::onDelete);
        this.editModel.entityEvent().addConsumer(this::onEntitySet);
        this.selectionModel().selectedItemEvent().addConsumer(arg_0 -> ((SwingEntityEditModel)this.editModel).set(arg_0));
        this.addTableModelListener(this::onTableModelEvent);
    }

    private List<Entity> queryItems() throws DatabaseException {
        EntityConnection.Select select = this.createSelect(this.conditionModel);
        if (((Boolean)this.conditionRequired.get()).booleanValue() && !this.conditionEnabled(this.conditionModel)) {
            this.updateRefreshSelect(select);
            return Collections.emptyList();
        }
        List items = this.connection().select(select);
        this.updateRefreshSelect(select);
        return items;
    }

    private void updateRefreshSelect(EntityConnection.Select select) {
        this.refreshCondition = select;
        this.conditionChanged.set((Object)false);
    }

    private void onInsert(Collection<Entity> insertedEntities) {
        Collection entitiesToAdd = insertedEntities.stream().filter(entity -> entity.entityType().equals(this.entityType())).collect(Collectors.toList());
        if (!this.onInsert.isEqualTo((Object)EntityTableModel.OnInsert.DO_NOTHING) && !entitiesToAdd.isEmpty()) {
            if (!this.selectionModel().isSelectionEmpty()) {
                this.selectionModel().clearSelection();
            }
            switch ((EntityTableModel.OnInsert)this.onInsert.get()) {
                case ADD_TOP: {
                    this.tableModel.addItemsAt(0, entitiesToAdd);
                    break;
                }
                case ADD_TOP_SORTED: {
                    this.tableModel.addItemsAtSorted(0, entitiesToAdd);
                    break;
                }
                case ADD_BOTTOM: {
                    this.tableModel.addItemsAt(this.visibleCount(), entitiesToAdd);
                    break;
                }
                case ADD_BOTTOM_SORTED: {
                    this.tableModel.addItemsAtSorted(this.visibleCount(), entitiesToAdd);
                    break;
                }
            }
        }
    }

    private void onUpdate(Map<Entity.Key, Entity> updatedEntities) {
        this.replaceEntitiesByKey(new HashMap<Entity.Key, Entity>(updatedEntities));
    }

    private void onDelete(Collection<Entity> deletedEntities) {
        if (((Boolean)this.removeDeleted.get()).booleanValue()) {
            this.removeItems(deletedEntities);
        }
    }

    private void onEntitySet(Entity entity) {
        if (entity == null && !this.selectionModel().isSelectionEmpty()) {
            this.selectionModel().clearSelection();
        }
    }

    private void onTableModelEvent(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == this.selectionModel().getSelectedIndex()) {
            this.editModel.set((Entity)this.selectionModel().getSelectedItem());
        }
    }

    private void onConditionChanged(EntityConnection.Select condition) {
        this.conditionChanged.set((Object)(!Objects.equals(this.refreshCondition, condition) ? 1 : 0));
    }

    private void replaceEntitiesByKey(Map<Entity.Key, Entity> entitiesByKey) {
        Map<Entity.Key, Integer> keyIndexes = this.keyIndexes(new HashSet<Entity.Key>(entitiesByKey.keySet()));
        keyIndexes.forEach((key, index) -> this.tableModel.setItemAt(index.intValue(), (Object)((Entity)entitiesByKey.remove(key))));
        if (!entitiesByKey.isEmpty()) {
            this.filteredItems().forEach(item -> {
                Entity replacement = (Entity)entitiesByKey.remove(item.primaryKey());
                if (replacement != null) {
                    item.set(replacement);
                }
            });
        }
    }

    private Map<Entity.Key, Integer> keyIndexes(Set<Entity.Key> keys) {
        List<Entity> visibleItems = this.visibleItems();
        HashMap<Entity.Key, Integer> keyIndexes = new HashMap<Entity.Key, Integer>();
        for (int index = 0; index < visibleItems.size(); ++index) {
            Entity.Key primaryKey = visibleItems.get(index).primaryKey();
            if (!keys.remove(primaryKey)) continue;
            keyIndexes.put(primaryKey, index);
            if (keys.isEmpty()) break;
        }
        return keyIndexes;
    }

    private EntityConnection.Select createSelect(EntityTableConditionModel conditionModel) {
        return EntityConnection.Select.where((Condition)conditionModel.where(Conjunction.AND)).having(conditionModel.having(Conjunction.AND)).attributes((Collection)this.attributes().get()).limit((Integer)this.limit().get()).orderBy((OrderBy)this.orderBy.get()).build();
    }

    private Value<OrderBy> createOrderBy() {
        return this.entityDefinition().orderBy().map(entityOrderBy -> Value.nonNull((Object)entityOrderBy).build()).orElse(Value.value());
    }

    private FilterTableModel<Entity, Attribute<?>> createTableModel(EntityDefinition entityDefinition) {
        return FilterTableModel.builder((FilterTableModel.Columns)new EntityTableColumns(entityDefinition)).filterModelFactory((ColumnConditionModel.Factory)new EntityFilterModelFactory(entityDefinition)).items((Supplier)new EntityItems(this)).validator((Predicate)new EntityItemValidator(entityDefinition.entityType())).build();
    }

    private class AttributeValidator
    implements Value.Validator<Set<Attribute<?>>> {
        private AttributeValidator() {
        }

        public void validate(Set<Attribute<?>> attributes) {
            for (Attribute<?> attribute : attributes) {
                if (attribute.entityType().equals(SwingEntityTableModel.this.entityType())) continue;
                throw new IllegalArgumentException(attribute + " is not part of entity:  " + SwingEntityTableModel.this.entityType());
            }
        }
    }

    private final class HandleEditEventsChanged
    implements Consumer<Boolean> {
        private HandleEditEventsChanged() {
        }

        @Override
        public void accept(Boolean handleEditEvents) {
            if (handleEditEvents.booleanValue()) {
                this.entityTypes().forEach(entityType -> EntityEditEvents.addUpdateListener((EntityType)entityType, SwingEntityTableModel.this.updateListener));
            } else {
                this.entityTypes().forEach(entityType -> EntityEditEvents.removeUpdateListener((EntityType)entityType, SwingEntityTableModel.this.updateListener));
            }
        }

        private Stream<EntityType> entityTypes() {
            return Stream.concat(SwingEntityTableModel.this.entityDefinition().foreignKeys().get().stream().map(ForeignKey::referencedType), Stream.of(SwingEntityTableModel.this.entityType()));
        }
    }

    private final class UpdateListener
    implements Consumer<Map<Entity.Key, Entity>> {
        private UpdateListener() {
        }

        @Override
        public void accept(Map<Entity.Key, Entity> updated) {
            updated.values().stream().collect(Collectors.groupingBy(Entity::entityType, HashMap::new, Collectors.toList())).forEach(this::handleUpdate);
        }

        private void handleUpdate(EntityType entityType, List<Entity> entities) {
            if (entityType.equals(SwingEntityTableModel.this.entityType())) {
                SwingEntityTableModel.this.replace(entities);
            }
            SwingEntityTableModel.this.entityDefinition().foreignKeys().get(entityType).forEach(foreignKey -> SwingEntityTableModel.this.replace((ForeignKey)foreignKey, (Collection<Entity>)entities));
        }
    }

    private static final class SelectByKeyPredicate
    implements Predicate<Entity> {
        private final List<Entity.Key> keyList;

        private SelectByKeyPredicate(Collection<Entity.Key> keys) {
            this.keyList = new ArrayList<Entity.Key>(keys);
        }

        @Override
        public boolean test(Entity entity) {
            if (this.keyList.isEmpty()) {
                return false;
            }
            int index = this.keyList.indexOf(entity.primaryKey());
            if (index >= 0) {
                this.keyList.remove(index);
                return true;
            }
            return false;
        }
    }

    private static final class EntityTableColumns
    implements FilterTableModel.Columns<Entity, Attribute<?>> {
        private final EntityDefinition entityDefinition;
        private final List<Attribute<?>> identifiers;

        private EntityTableColumns(EntityDefinition entityDefinition) {
            this.entityDefinition = entityDefinition;
            this.identifiers = Collections.unmodifiableList(entityDefinition.attributes().definitions().stream().filter(attributeDefinition -> !attributeDefinition.hidden()).map(AttributeDefinition::attribute).collect(Collectors.toList()));
        }

        public List<Attribute<?>> identifiers() {
            return this.identifiers;
        }

        public Class<?> columnClass(Attribute<?> identifier) {
            return identifier.type().valueClass();
        }

        public Object value(Entity entity, Attribute<?> attribute) {
            return entity.get(attribute);
        }

        public String string(Entity entity, Attribute<?> attribute) {
            return entity.string(attribute);
        }

        public Comparator<?> comparator(Attribute<?> attribute) {
            if (attribute instanceof ForeignKey) {
                return this.entityDefinition.foreignKeys().referencedBy((ForeignKey)attribute).comparator();
            }
            return this.entityDefinition.attributes().definition(attribute).comparator();
        }
    }

    private static final class EntityFilterModelFactory
    implements ColumnConditionModel.Factory<Attribute<?>> {
        private final EntityDefinition entityDefinition;

        private EntityFilterModelFactory(EntityDefinition entityDefinition) {
            this.entityDefinition = Objects.requireNonNull(entityDefinition);
        }

        public Optional<ColumnConditionModel<Attribute<?>, ?>> createConditionModel(Attribute<?> attribute) {
            if (!this.include(attribute)) {
                return Optional.empty();
            }
            AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
            if (EntityFilterModelFactory.useStringCondition(attribute, attributeDefinition)) {
                ColumnConditionModel model = ColumnConditionModel.builder(attribute, String.class).build();
                return Optional.of(model);
            }
            ColumnConditionModel model = ColumnConditionModel.builder(attribute, (Class)attribute.type().valueClass()).format(attributeDefinition.format()).dateTimePattern(attributeDefinition.dateTimePattern()).build();
            return Optional.of(model);
        }

        private boolean include(Attribute<?> attribute) {
            AttributeDefinition definition = this.entityDefinition.attributes().definition(attribute);
            if (definition.hidden()) {
                return false;
            }
            return !(attribute instanceof ForeignKey);
        }

        private static boolean useStringCondition(Attribute<?> attribute, AttributeDefinition<?> attributeDefinition) {
            return attribute.type().isEntity() || !attributeDefinition.items().isEmpty() || !Comparable.class.isAssignableFrom(attribute.type().valueClass());
        }
    }

    private static final class EntityItems
    implements Supplier<Collection<Entity>> {
        private final SwingEntityTableModel tableModel;

        private EntityItems(SwingEntityTableModel tableModel) {
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        @Override
        public Collection<Entity> get() {
            return this.tableModel.refreshItems();
        }
    }

    private static final class EntityItemValidator
    implements Predicate<Entity> {
        private final EntityType entityType;

        private EntityItemValidator(EntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType);
        }

        @Override
        public boolean test(Entity entity) {
            return entity.entityType().equals(this.entityType);
        }
    }
}

