/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class SwingEntityEditModel
extends AbstractEntityEditModel {
    private final Map<Attribute<?>, FilterComboBoxModel<?>> comboBoxModels = new HashMap();

    public SwingEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        super(entityType, Objects.requireNonNull(connectionProvider));
    }

    public final void initializeComboBoxModels(Attribute<?> ... attributes) {
        Objects.requireNonNull(attributes);
        for (Attribute<?> attribute : attributes) {
            if (attribute instanceof ForeignKey) {
                this.foreignKeyComboBoxModel((ForeignKey)attribute).refresh();
                continue;
            }
            if (!(attribute instanceof Column)) continue;
            this.comboBoxModel((Column)attribute).refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshForeignKeyComboBoxModels() {
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilterComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                if (!(comboBoxModel instanceof EntityComboBoxModel)) continue;
                comboBoxModel.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshComboBoxModels() {
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilterComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                comboBoxModel.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearComboBoxModels() {
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilterComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                comboBoxModel.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EntityComboBoxModel foreignKeyComboBoxModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            EntityComboBoxModel comboBoxModel = (EntityComboBoxModel)this.comboBoxModels.get(foreignKey);
            if (comboBoxModel == null) {
                comboBoxModel = this.createForeignKeyComboBoxModel(foreignKey);
                this.comboBoxModels.put((Attribute<?>)foreignKey, comboBoxModel);
            }
            return comboBoxModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> FilterComboBoxModel<T> comboBoxModel(Column<T> column) {
        this.entityDefinition().columns().definition(column);
        Map<Attribute<?>, FilterComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            Object comboBoxModel = this.comboBoxModels.get(column);
            if (comboBoxModel == null) {
                comboBoxModel = this.createComboBoxModel(column);
                this.comboBoxModels.put((Attribute<?>)column, (FilterComboBoxModel<?>)comboBoxModel);
            }
            return comboBoxModel;
        }
    }

    public EntityComboBoxModel createForeignKeyComboBoxModel(ForeignKey foreignKey) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition().foreignKeys().definition(foreignKey);
        EntityComboBoxModel comboBoxModel = EntityComboBoxModel.entityComboBoxModel(foreignKey.referencedType(), this.connectionProvider());
        comboBoxModel.attributes().set((Collection)foreignKeyDefinition.attributes());
        if (this.nullable((Attribute)foreignKey)) {
            comboBoxModel.setNullCaption((String)FilterComboBoxModel.COMBO_BOX_NULL_CAPTION.get());
        }
        return comboBoxModel;
    }

    public <T> FilterComboBoxModel<T> createComboBoxModel(Column<T> column) {
        Objects.requireNonNull(column, "column");
        FilterComboBoxModel<T> comboBoxModel = this.createColumnComboBoxModel(column);
        if (this.nullable((Attribute)column)) {
            comboBoxModel.includeNull().set((Object)true);
            if (column.type().valueClass().isInterface()) {
                comboBoxModel.nullItem().set(ProxyBuilder.builder((Class)column.type().valueClass()).method("toString", parameters -> FilterComboBoxModel.COMBO_BOX_NULL_CAPTION.get()).build());
            }
        }
        this.insertUpdateOrDeleteEvent().addListener(() -> comboBoxModel.refresh());
        return comboBoxModel;
    }

    public final void add(ForeignKey foreignKey, Collection<Entity> entities) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(entities);
        if (this.comboBoxModels.containsKey(foreignKey)) {
            entities.forEach(this.foreignKeyComboBoxModel(foreignKey)::add);
        }
    }

    public final void remove(ForeignKey foreignKey, Collection<Entity> entities) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(entities);
        this.clearForeignKeyReferences(foreignKey, entities);
        if (this.comboBoxModels.containsKey(foreignKey)) {
            EntityComboBoxModel comboBoxModel = this.foreignKeyComboBoxModel(foreignKey);
            Entity selectedEntity = comboBoxModel.selectedValue();
            entities.forEach(comboBoxModel::remove);
            if (comboBoxModel.visible(selectedEntity)) {
                comboBoxModel.setSelectedItem(selectedEntity);
            } else if (!comboBoxModel.nullSelected() && comboBoxModel.getSize() > 0) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
            } else {
                comboBoxModel.setSelectedItem(null);
            }
        }
    }

    protected void replaceForeignKey(ForeignKey foreignKey, Collection<Entity> entities) {
        super.replaceForeignKey(foreignKey, entities);
        if (this.comboBoxModels.containsKey(foreignKey)) {
            EntityComboBoxModel comboBoxModel = this.foreignKeyComboBoxModel(foreignKey);
            entities.forEach(foreignKeyValue -> comboBoxModel.replace((Entity)foreignKeyValue, (Entity)foreignKeyValue));
        }
    }

    private void clearForeignKeyReferences(ForeignKey foreignKey, Collection<Entity> entities) {
        entities.forEach(entity -> {
            if (Objects.equals(entity, this.get((Attribute)foreignKey))) {
                this.put((Attribute)foreignKey, null);
            }
        });
    }

    private <T> FilterComboBoxModel<T> createColumnComboBoxModel(Column<T> column) {
        FilterComboBoxModel comboBoxModel = FilterComboBoxModel.filterComboBoxModel();
        comboBoxModel.refresher().items().set(column.type().isEnum() ? new EnumAttributeItems<T>(column) : new ColumnItems<T>(this.connectionProvider(), column));
        return comboBoxModel;
    }

    private static final class EnumAttributeItems<T>
    implements Supplier<Collection<T>> {
        private final Collection<T> items;

        private EnumAttributeItems(Column<T> column) {
            this.items = Arrays.asList(column.type().valueClass().getEnumConstants());
        }

        @Override
        public Collection<T> get() {
            return this.items;
        }
    }

    private static final class ColumnItems<T>
    implements Supplier<Collection<T>> {
        private final EntityConnectionProvider connectionProvider;
        private final Column<T> column;

        private ColumnItems(EntityConnectionProvider connectionProvider, Column<T> column) {
            this.connectionProvider = connectionProvider;
            this.column = column;
        }

        @Override
        public Collection<T> get() {
            try {
                return this.connectionProvider.connection().select(this.column);
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

