/*
 * This file is part of Codion.
 *
 * Codion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Codion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codion.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2022 - 2024, Björn Darri Sigurðsson.
 */
package is.codion.swing.framework.model;

import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.DefaultForeignKeyDetailModelLink;

/**
 * A Swing {@link DefaultForeignKeyDetailModelLink} implementation.
 */
public class SwingForeignKeyDetailModelLink extends DefaultForeignKeyDetailModelLink<SwingEntityModel, SwingEntityEditModel, SwingEntityTableModel> {

	/**
	 * @param detailModel the detail model
	 * @param foreignKey the foreign key to base this link on
	 */
	public SwingForeignKeyDetailModelLink(SwingEntityModel detailModel, ForeignKey foreignKey) {
		super(detailModel, foreignKey);
	}
}
