/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.component;

import is.codion.common.Configuration;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.event.EventObserver;
import is.codion.common.model.FilterModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityEditEvents;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.event.ListDataListener;

public final class EntityComboBoxModel
implements FilterComboBoxModel<Entity> {
    public static final PropertyValue<Boolean> HANDLE_EDIT_EVENTS = Configuration.booleanValue((String)(EntityComboBoxModel.class.getName() + ".handleEditEvents"), (boolean)true);
    private final FilterComboBoxModel<Entity> comboBoxModel;
    private final EntityType entityType;
    private final EntityConnectionProvider connectionProvider;
    private final ValueSet<Attribute<?>> attributes = ((ValueSet.Builder)ValueSet.builder().validator((Value.Validator)new AttributeValidator())).build();
    private final Entities entities;
    private final Map<ForeignKey, Set<Entity.Key>> foreignKeyFilterKeys = new HashMap<ForeignKey, Set<Entity.Key>>();
    private final Predicate<Entity> foreignKeyIncludeCondition = new ForeignKeyIncludeCondition();
    private final Value<Supplier<Condition>> conditionSupplier;
    private final State handleEditEvents = State.builder().consumer((Consumer)new HandleEditEventsChanged()).build();
    private final State strictForeignKeyFiltering = State.state((boolean)true);
    private final Value<OrderBy> orderBy;
    private final Consumer<Collection<Entity>> insertListener = new InsertListener();
    private final Consumer<Map<Entity.Key, Entity>> updateListener = new UpdateListener();
    private final Consumer<Collection<Entity>> deleteListener = new DeleteListener();

    private EntityComboBoxModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this.comboBoxModel = FilterComboBoxModel.filterComboBoxModel();
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.entities = connectionProvider.entities();
        this.orderBy = Value.nullable((Object)this.entities.definition(entityType).orderBy().orElse(null)).build();
        this.conditionSupplier = Value.nonNull((Object)new DefaultConditionSupplier()).build();
        this.comboBoxModel.selectedItemTranslator().set((Object)new SelectedItemTranslator());
        this.comboBoxModel.refresher().items().set(this::performQuery);
        this.comboBoxModel.validator().set((Object)new ItemValidator());
        this.comboBoxModel.includeCondition().set(this.foreignKeyIncludeCondition);
        this.handleEditEvents.set((Object)((Boolean)HANDLE_EDIT_EVENTS.get()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [entityType: " + this.entityType + "]";
    }

    public EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public void setNullCaption(String nullCaption) {
        Objects.requireNonNull(nullCaption, "nullCaption");
        this.includeNull().set((Object)true);
        this.nullItem().set((Object)((Entity)ProxyBuilder.builder(Entity.class).delegate((Object)this.entities.entity(this.entityType)).method("toString", parameters -> nullCaption).build()));
    }

    public ValueSet<Attribute<?>> attributes() {
        return this.attributes;
    }

    public State handleEditEvents() {
        return this.handleEditEvents;
    }

    public Optional<Entity> find(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        return this.items().stream().filter(Objects::nonNull).filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    public void select(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        Optional<Entity> entity = this.find(primaryKey);
        if (entity.isPresent()) {
            this.setSelectedItem(entity.get());
        } else {
            this.filteredEntity(primaryKey).ifPresent(this::setSelectedItem);
        }
    }

    public Value<Supplier<Condition>> condition() {
        return this.conditionSupplier;
    }

    public Value<OrderBy> orderBy() {
        return this.orderBy;
    }

    public Predicate<Entity> foreignKeyIncludeCondition() {
        return this.foreignKeyIncludeCondition;
    }

    public void setForeignKeyFilterKeys(ForeignKey foreignKey, Collection<Entity.Key> keys) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(keys);
        if (keys.isEmpty()) {
            this.foreignKeyFilterKeys.remove(foreignKey);
        } else {
            this.foreignKeyFilterKeys.put(foreignKey, new HashSet<Entity.Key>(keys));
        }
        this.includeCondition().set(this.foreignKeyIncludeCondition);
        this.filterItems();
    }

    public Collection<Entity.Key> getForeignKeyFilterKeys(ForeignKey foreignKey) {
        Objects.requireNonNull(foreignKey);
        if (this.foreignKeyFilterKeys.containsKey(foreignKey)) {
            return Collections.unmodifiableCollection(new ArrayList(this.foreignKeyFilterKeys.get(foreignKey)));
        }
        return Collections.emptyList();
    }

    public State strictForeignKeyFiltering() {
        return this.strictForeignKeyFiltering;
    }

    public EntityComboBoxModel createForeignKeyFilterComboBoxModel(ForeignKey foreignKey) {
        return this.createForeignKeyComboBoxModel(foreignKey, true);
    }

    public EntityComboBoxModel createForeignKeyConditionComboBoxModel(ForeignKey foreignKey) {
        return this.createForeignKeyComboBoxModel(foreignKey, false);
    }

    public void linkForeignKeyFilterComboBoxModel(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        this.linkForeignKeyComboBoxModel(foreignKey, foreignKeyModel, true);
    }

    public void linkForeignKeyConditionComboBoxModel(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        this.linkForeignKeyComboBoxModel(foreignKey, foreignKeyModel, false);
    }

    public <T> Value<T> createSelectorValue(Attribute<T> attribute) {
        if (!this.entities.definition(this.entityType()).attributes().contains(attribute)) {
            throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + this.entityType());
        }
        return this.createSelectorValue(new EntityFinder<T>(attribute));
    }

    public void clear() {
        this.comboBoxModel.clear();
    }

    public boolean cleared() {
        return this.comboBoxModel.cleared();
    }

    public void setItems(Collection<Entity> items) {
        this.comboBoxModel.setItems(items);
    }

    public void add(Entity item) {
        this.comboBoxModel.add((Object)item);
    }

    public void remove(Entity item) {
        this.comboBoxModel.remove((Object)item);
    }

    public void replace(Entity item, Entity replacement) {
        this.comboBoxModel.replace((Object)item, (Object)replacement);
    }

    public void sortItems() {
        this.comboBoxModel.sortItems();
    }

    public Value<Comparator<Entity>> comparator() {
        return this.comboBoxModel.comparator();
    }

    public Value<Predicate<Entity>> validator() {
        return this.comboBoxModel.validator();
    }

    public Value<Function<Object, Entity>> selectedItemTranslator() {
        return this.comboBoxModel.selectedItemTranslator();
    }

    public Value<Predicate<Entity>> validSelectionPredicate() {
        return this.comboBoxModel.validSelectionPredicate();
    }

    public State includeNull() {
        return this.comboBoxModel.includeNull();
    }

    public Value<Entity> nullItem() {
        return this.comboBoxModel.nullItem();
    }

    public boolean nullSelected() {
        return this.comboBoxModel.nullSelected();
    }

    public StateObserver selectionEmpty() {
        return this.comboBoxModel.selectionEmpty();
    }

    public Entity selectedValue() {
        return (Entity)this.comboBoxModel.selectedValue();
    }

    public Entity getSelectedItem() {
        return (Entity)this.comboBoxModel.getSelectedItem();
    }

    public State filterSelectedItem() {
        return this.comboBoxModel.filterSelectedItem();
    }

    public <V> Value<V> createSelectorValue(FilterComboBoxModel.ItemFinder<Entity, V> itemFinder) {
        return this.comboBoxModel.createSelectorValue(itemFinder);
    }

    public EventObserver<Entity> selectionEvent() {
        return this.comboBoxModel.selectionEvent();
    }

    public void filterItems() {
        this.comboBoxModel.filterItems();
    }

    public Value<Predicate<Entity>> includeCondition() {
        return this.comboBoxModel.includeCondition();
    }

    public Collection<Entity> items() {
        return this.comboBoxModel.items();
    }

    public List<Entity> visibleItems() {
        return this.comboBoxModel.visibleItems();
    }

    public Collection<Entity> filteredItems() {
        return this.comboBoxModel.filteredItems();
    }

    public int visibleCount() {
        return this.comboBoxModel.visibleCount();
    }

    public int filteredCount() {
        return this.comboBoxModel.filteredCount();
    }

    public boolean containsItem(Entity item) {
        return this.comboBoxModel.containsItem((Object)item);
    }

    public boolean visible(Entity item) {
        return this.comboBoxModel.visible((Object)item);
    }

    public boolean filtered(Entity item) {
        return this.comboBoxModel.filtered((Object)item);
    }

    public FilterModel.Refresher<Entity> refresher() {
        return this.comboBoxModel.refresher();
    }

    public void refresh() {
        this.comboBoxModel.refresh();
    }

    public void refreshThen(Consumer<Collection<Entity>> afterRefresh) {
        this.comboBoxModel.refreshThen(afterRefresh);
    }

    public void setSelectedItem(Object selectedItem) {
        this.comboBoxModel.setSelectedItem(selectedItem);
    }

    public int getSize() {
        return this.comboBoxModel.getSize();
    }

    public Entity getElementAt(int index) {
        return (Entity)this.comboBoxModel.getElementAt(index);
    }

    public void addListDataListener(ListDataListener listener) {
        this.comboBoxModel.addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.comboBoxModel.removeListDataListener(listener);
    }

    public static EntityComboBoxModel entityComboBoxModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        return new EntityComboBoxModel(entityType, connectionProvider);
    }

    private Collection<Entity> performQuery() {
        try {
            return this.connectionProvider.connection().select(EntityConnection.Select.where((Condition)((Condition)((Supplier)this.conditionSupplier.get()).get())).attributes((Collection)this.attributes.get()).orderBy((OrderBy)this.orderBy.get()).build());
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Entity> filteredEntity(Entity.Key primaryKey) {
        return this.filteredItems().stream().filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    private EntityComboBoxModel createForeignKeyComboBoxModel(ForeignKey foreignKey, boolean filter) {
        this.entities.definition(this.entityType).foreignKeys().definition(foreignKey);
        EntityComboBoxModel foreignKeyModel = new EntityComboBoxModel(foreignKey.referencedType(), this.connectionProvider);
        foreignKeyModel.setNullCaption((String)FilterComboBoxModel.COMBO_BOX_NULL_CAPTION.get());
        foreignKeyModel.refresh();
        this.linkForeignKeyComboBoxModel(foreignKey, foreignKeyModel, filter);
        return foreignKeyModel;
    }

    private void linkForeignKeyComboBoxModel(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel, boolean filter) {
        this.entities.definition(this.entityType).foreignKeys().definition(foreignKey);
        if (!foreignKey.referencedType().equals(foreignKeyModel.entityType())) {
            throw new IllegalArgumentException("EntityComboBoxModel is of type: " + foreignKeyModel.entityType() + ", should be: " + foreignKey.referencedType());
        }
        Collection<Entity.Key> filterKeys = this.getForeignKeyFilterKeys(foreignKey);
        if (!filterKeys.isEmpty()) {
            foreignKeyModel.select(filterKeys.iterator().next());
        }
        if (filter) {
            this.linkFilter(foreignKey, foreignKeyModel);
        } else {
            this.linkCondition(foreignKey, foreignKeyModel);
        }
        this.selectionEvent().addConsumer(selected -> {
            if (selected != null && !selected.isNull((Attribute)foreignKey)) {
                foreignKeyModel.select(selected.key(foreignKey));
            }
        });
        this.refresher().refreshEvent().addListener(foreignKeyModel::refresh);
    }

    private void linkFilter(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        Predicate<Entity> filterAllCondition = item -> false;
        if (((Boolean)this.strictForeignKeyFiltering.get()).booleanValue()) {
            this.includeCondition().set(filterAllCondition);
        }
        foreignKeyModel.selectionEvent().addConsumer(selected -> {
            if (selected == null && ((Boolean)this.strictForeignKeyFiltering.get()).booleanValue()) {
                this.includeCondition().set((Object)filterAllCondition);
            } else {
                this.setForeignKeyFilterKeys(foreignKey, selected == null ? Collections.emptyList() : Collections.singletonList(selected.primaryKey()));
            }
        });
    }

    private void linkCondition(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        Consumer<Entity> consumer = selected -> {
            this.conditionSupplier.set(() -> foreignKey.equalTo(selected));
            this.refresh();
        };
        foreignKeyModel.selectionEvent().addConsumer(consumer);
        consumer.accept(this.selectedValue());
    }

    private final class AttributeValidator
    implements Value.Validator<Set<Attribute<?>>> {
        private AttributeValidator() {
        }

        public void validate(Set<Attribute<?>> attributes) {
            for (Attribute<?> attribute : Objects.requireNonNull(attributes)) {
                if (attribute.entityType().equals(EntityComboBoxModel.this.entityType)) continue;
                throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + EntityComboBoxModel.this.entityType);
            }
        }
    }

    private final class ForeignKeyIncludeCondition
    implements Predicate<Entity> {
        private ForeignKeyIncludeCondition() {
        }

        @Override
        public boolean test(Entity item) {
            for (Map.Entry<ForeignKey, Set<Entity.Key>> entry : EntityComboBoxModel.this.foreignKeyFilterKeys.entrySet()) {
                Entity.Key key = item.key(entry.getKey());
                if (key == null) {
                    return (Boolean)EntityComboBoxModel.this.strictForeignKeyFiltering.get() == false;
                }
                if (entry.getValue().contains(key)) continue;
                return false;
            }
            return true;
        }
    }

    private final class HandleEditEventsChanged
    implements Consumer<Boolean> {
        private HandleEditEventsChanged() {
        }

        @Override
        public void accept(Boolean handleEditEvents) {
            if (handleEditEvents.booleanValue()) {
                this.addEditListeners();
            } else {
                this.removeEditListeners();
            }
        }

        private void addEditListeners() {
            EntityEditEvents.addInsertListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.insertListener);
            EntityEditEvents.addUpdateListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.updateListener);
            EntityEditEvents.addDeleteListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.deleteListener);
        }

        private void removeEditListeners() {
            EntityEditEvents.removeInsertListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.insertListener);
            EntityEditEvents.removeUpdateListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.updateListener);
            EntityEditEvents.removeDeleteListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.deleteListener);
        }
    }

    private final class InsertListener
    implements Consumer<Collection<Entity>> {
        private InsertListener() {
        }

        @Override
        public void accept(Collection<Entity> inserted) {
            inserted.forEach(EntityComboBoxModel.this::add);
        }
    }

    private final class UpdateListener
    implements Consumer<Map<Entity.Key, Entity>> {
        private UpdateListener() {
        }

        @Override
        public void accept(Map<Entity.Key, Entity> updated) {
            updated.forEach((key, entity) -> EntityComboBoxModel.this.replace(Entity.entity((Entity.Key)key), (Entity)entity));
        }
    }

    private final class DeleteListener
    implements Consumer<Collection<Entity>> {
        private DeleteListener() {
        }

        @Override
        public void accept(Collection<Entity> deleted) {
            deleted.forEach(EntityComboBoxModel.this::remove);
        }
    }

    private final class DefaultConditionSupplier
    implements Supplier<Condition> {
        private DefaultConditionSupplier() {
        }

        @Override
        public Condition get() {
            return Condition.all((EntityType)EntityComboBoxModel.this.entityType);
        }
    }

    private final class SelectedItemTranslator
    implements Function<Object, Entity> {
        private SelectedItemTranslator() {
        }

        @Override
        public Entity apply(Object itemToSelect) {
            if (itemToSelect == null) {
                return null;
            }
            if (itemToSelect instanceof Entity) {
                return EntityComboBoxModel.this.find(((Entity)itemToSelect).primaryKey()).orElse((Entity)itemToSelect);
            }
            String itemToString = itemToSelect.toString();
            return EntityComboBoxModel.this.visibleItems().stream().filter(visibleItem -> visibleItem != null && itemToString.equals(visibleItem.toString())).findFirst().orElse(null);
        }
    }

    private final class ItemValidator
    implements Predicate<Entity> {
        private ItemValidator() {
        }

        @Override
        public boolean test(Entity entity) {
            return entity.entityType().equals(EntityComboBoxModel.this.entityType);
        }
    }

    private static final class EntityFinder<T>
    implements FilterComboBoxModel.ItemFinder<Entity, T> {
        private final Attribute<T> attribute;

        private EntityFinder(Attribute<T> attribute) {
            this.attribute = attribute;
        }

        public T value(Entity item) {
            return (T)item.get(this.attribute);
        }

        public Predicate<Entity> predicate(T value) {
            return entity -> Objects.equals(entity.get(this.attribute), value);
        }
    }
}

