/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.AbstractForeignKeyConditionModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class EntityComboBoxConditionModel
extends AbstractForeignKeyConditionModel {
    private final EntityComboBoxModel entityComboBoxModel;
    private boolean updatingModel = false;

    private EntityComboBoxConditionModel(ForeignKey foreignKey, EntityComboBoxModel comboBoxModel) {
        super(foreignKey);
        this.entityComboBoxModel = Objects.requireNonNull(comboBoxModel, "comboBoxModel");
        if (this.entityComboBoxModel.cleared()) {
            this.entityComboBoxModel.setSelectedItem(this.getEqualValue());
        }
        this.bindComboBoxEvents();
    }

    public void refresh() {
        this.entityComboBoxModel.refresh();
    }

    public EntityComboBoxModel comboBoxModel() {
        return this.entityComboBoxModel;
    }

    public static EntityComboBoxConditionModel entityComboBoxConditionModel(ForeignKey foreignKey, EntityComboBoxModel comboBoxModel) {
        return new EntityComboBoxConditionModel(foreignKey, comboBoxModel);
    }

    private void bindComboBoxEvents() {
        this.entityComboBoxModel.selectionEvent().addConsumer((Consumer)new SetEqualValue());
        this.equalValues().addConsumer((Consumer)new SelectEqualValueEntity());
        this.entityComboBoxModel.refresher().refreshEvent().addListener(() -> this.entityComboBoxModel.setSelectedItem(this.getEqualValue()));
    }

    private final class SetEqualValue
    implements Consumer<Entity> {
        private SetEqualValue() {
        }

        @Override
        public void accept(Entity selectedEntity) {
            if (!EntityComboBoxConditionModel.this.updatingModel) {
                EntityComboBoxConditionModel.this.setEqualValue(selectedEntity);
            }
        }
    }

    private final class SelectEqualValueEntity
    implements Consumer<Set<Entity>> {
        private SelectEqualValueEntity() {
        }

        @Override
        public void accept(Set<Entity> equalValues) {
            EntityComboBoxConditionModel.this.updatingModel = true;
            try {
                EntityComboBoxConditionModel.this.entityComboBoxModel.setSelectedItem(equalValues.isEmpty() ? null : equalValues.iterator().next());
            }
            finally {
                EntityComboBoxConditionModel.this.updatingModel = false;
            }
        }
    }
}

