/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.Conjunction;
import is.codion.common.Operator;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.event.EventObserver;
import is.codion.common.model.FilteredModel;
import is.codion.common.model.UserPreferences;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.model.table.TableSummaryModel;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityConditionModelFactory;
import is.codion.framework.model.EntityEditEvents;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableConditionModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSearchModel;
import is.codion.swing.common.model.component.table.FilteredTableSelectionModel;
import is.codion.swing.common.model.component.table.FilteredTableSortModel;
import is.codion.swing.framework.model.SwingEntityColumnFactory;
import is.codion.swing.framework.model.SwingEntityConditionModelFactory;
import is.codion.swing.framework.model.SwingEntityEditModel;
import java.awt.Color;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingEntityTableModel
implements EntityTableModel<SwingEntityEditModel>,
FilteredTableModel<Entity, Attribute<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SwingEntityTableModel.class);
    private static final String COLUMN_PREFERENCES = "-columns";
    private static final String CONDITIONS_PREFERENCES = "-conditions";
    private final FilteredTableModel<Entity, Attribute<?>> tableModel;
    private final SwingEntityEditModel editModel;
    private final EntityTableConditionModel<Attribute<?>> conditionModel;
    private final ValueSet<Attribute<?>> attributes = ValueSet.valueSet();
    private final State conditionRequired = State.state();
    private final State editEvents = State.state();
    private final State editable = State.state();
    private final Value<Integer> limit = Value.value();
    private final State queryHiddenColumns = State.state((boolean)((Boolean)EntityTableModel.QUERY_HIDDEN_COLUMNS.get()));
    private final State orderQueryBySortOrder = State.state((boolean)((Boolean)ORDER_QUERY_BY_SORT_ORDER.get()));
    private final State removeDeleted = State.state((boolean)true);
    private final Value<EntityTableModel.OnInsert> onInsert = Value.value((Object)((EntityTableModel.OnInsert)EntityTableModel.ON_INSERT.get()), (Object)((EntityTableModel.OnInsert)EntityTableModel.ON_INSERT.get()));
    private final Map<String, Color> colorCache = new ConcurrentHashMap<String, Color>();
    private final State conditionChanged = State.state();
    private final Consumer<Map<Entity.Key, Entity>> updateListener = new UpdateListener();
    private EntityConnection.Select refreshCondition;

    public SwingEntityTableModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this(new SwingEntityEditModel(entityType, connectionProvider));
    }

    public SwingEntityTableModel(EntityType entityType, EntityConnectionProvider connectionProvider, FilteredTableModel.ColumnFactory<Attribute<?>> columnFactory) {
        this(new SwingEntityEditModel(entityType, connectionProvider), columnFactory);
    }

    public SwingEntityTableModel(EntityType entityType, EntityConnectionProvider connectionProvider, EntityConditionModelFactory conditionModelFactory) {
        this(new SwingEntityEditModel(entityType, connectionProvider), conditionModelFactory);
    }

    public SwingEntityTableModel(EntityType entityType, EntityConnectionProvider connectionProvider, FilteredTableModel.ColumnFactory<Attribute<?>> columnFactory, EntityConditionModelFactory conditionModelFactory) {
        this(new SwingEntityEditModel(entityType, connectionProvider), columnFactory, conditionModelFactory);
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel) {
        this(editModel, new SwingEntityColumnFactory(Objects.requireNonNull(editModel).entityDefinition()));
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel, FilteredTableModel.ColumnFactory<Attribute<?>> columnFactory) {
        this(editModel, columnFactory, (EntityConditionModelFactory)new SwingEntityConditionModelFactory(Objects.requireNonNull(editModel).connectionProvider()));
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel, EntityConditionModelFactory conditionModelFactory) {
        this(editModel, new SwingEntityColumnFactory(Objects.requireNonNull(editModel).entityDefinition()), conditionModelFactory);
    }

    public SwingEntityTableModel(SwingEntityEditModel editModel, FilteredTableModel.ColumnFactory<Attribute<?>> columnFactory, EntityConditionModelFactory conditionModelFactory) {
        this.editModel = Objects.requireNonNull(editModel);
        this.tableModel = this.createTableModel(editModel.entityDefinition(), Objects.requireNonNull(columnFactory));
        this.conditionModel = EntityTableConditionModel.entityTableConditionModel((EntityType)editModel.entityType(), (EntityConnectionProvider)editModel.connectionProvider(), (ColumnConditionModel.Factory)((ColumnConditionModel.Factory)Objects.requireNonNull(conditionModelFactory)));
        this.refreshCondition = this.createSelect(this.conditionModel);
        this.attributes.addValidator((Value.Validator)new AttributeValidator());
        this.bindEvents();
        this.applyPreferences();
        this.editEvents.set((Object)true);
    }

    public final Entities entities() {
        return this.editModel.connectionProvider().entities();
    }

    public final EntityDefinition entityDefinition() {
        return this.editModel.entityDefinition();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.editModel.entityType();
    }

    public final ValueSet<Attribute<?>> attributes() {
        return this.attributes;
    }

    public final Value<Integer> limit() {
        return this.limit;
    }

    public final State queryHiddenColumns() {
        return this.queryHiddenColumns;
    }

    public final State orderQueryBySortOrder() {
        return this.orderQueryBySortOrder;
    }

    public final State conditionRequired() {
        return this.conditionRequired;
    }

    public final Value<EntityTableModel.OnInsert> onInsert() {
        return this.onInsert;
    }

    public final State removeDeleted() {
        return this.removeDeleted;
    }

    public final State editEvents() {
        return this.editEvents;
    }

    public final EntityType entityType() {
        return this.editModel.entityType();
    }

    public final EntityTableConditionModel<Attribute<?>> conditionModel() {
        return this.conditionModel;
    }

    public final <C extends SwingEntityEditModel> C editModel() {
        return (C)((Object)this.editModel);
    }

    public final EntityConnectionProvider connectionProvider() {
        return this.editModel.connectionProvider();
    }

    public final EntityConnection connection() {
        return this.editModel.connection();
    }

    public final State editable() {
        return this.editable;
    }

    public boolean isCellEditable(int rowIndex, int modelColumnIndex) {
        if (!((Boolean)this.editable.get()).booleanValue() || ((Boolean)this.editModel.readOnly().get()).booleanValue() || !((Boolean)this.editModel.updateEnabled().get()).booleanValue()) {
            return false;
        }
        Attribute attribute = (Attribute)this.columnModel().columnIdentifier(modelColumnIndex);
        if (attribute instanceof ForeignKey) {
            return this.entityDefinition().foreignKeys().updatable((ForeignKey)attribute);
        }
        AttributeDefinition attributeDefinition = this.entityDefinition().attributes().definition(attribute);
        return attributeDefinition instanceof ColumnDefinition && ((ColumnDefinition)attributeDefinition).updatable();
    }

    public final void setValueAt(Object value, int rowIndex, int modelColumnIndex) {
        if (!((Boolean)this.editable.get()).booleanValue() || ((Boolean)this.editModel.readOnly().get()).booleanValue() || !((Boolean)this.editModel.updateEnabled().get()).booleanValue()) {
            throw new IllegalStateException("This table model is readOnly or has disabled update");
        }
        Entity entity = this.itemAt(rowIndex).copy();
        Attribute columnIdentifier = (Attribute)this.columnModel().columnIdentifier(modelColumnIndex);
        entity.put(columnIdentifier, value);
        try {
            if (entity.modified()) {
                this.editModel.update(Collections.singletonList(entity));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Color backgroundColor(int row, Attribute<?> attribute) {
        Objects.requireNonNull(attribute);
        Object color = this.entityDefinition().backgroundColorProvider().color(this.itemAt(row), attribute);
        return color == null ? null : this.toColor(color);
    }

    public Color foregroundColor(int row, Attribute<?> attribute) {
        Objects.requireNonNull(attribute);
        Object color = this.entityDefinition().foregroundColorProvider().color(this.itemAt(row), attribute);
        return color == null ? null : this.toColor(color);
    }

    public final Optional<Entity> find(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        return this.visibleItems().stream().filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    public final int indexOf(Entity.Key primaryKey) {
        return this.find(primaryKey).map(this::indexOf).orElse(-1);
    }

    public final void replace(Collection<Entity> entities) {
        this.replaceEntitiesByKey(Entity.mapToPrimaryKey(entities));
    }

    public final void refresh(Collection<Entity.Key> keys) {
        try {
            this.replace(this.connection().select(keys));
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public final void replace(ForeignKey foreignKey, Collection<Entity> foreignKeyValues) {
        Objects.requireNonNull(foreignKey, "foreignKey");
        Objects.requireNonNull(foreignKeyValues, "foreignKeyValues");
        this.entityDefinition().foreignKeys().definition(foreignKey);
        boolean changed = false;
        for (Entity entity : this.items()) {
            for (Entity foreignKeyValue : foreignKeyValues) {
                Entity currentForeignKeyValue = entity.referencedEntity(foreignKey);
                if (currentForeignKeyValue == null || !currentForeignKeyValue.equals(foreignKeyValue)) continue;
                entity.put((Attribute)foreignKey, (Object)foreignKeyValue.immutable());
                changed = true;
            }
        }
        if (changed) {
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    public final void select(Collection<Entity.Key> keys) {
        this.selectionModel().setSelectedItems((Predicate)new SelectByKeyPredicate(Objects.requireNonNull(keys, "keys")));
    }

    public final Collection<Entity> find(Collection<Entity.Key> keys) {
        Objects.requireNonNull(keys, "keys");
        return this.items().stream().filter(entity -> keys.contains(entity.primaryKey())).collect(Collectors.toList());
    }

    public final Collection<Entity> deleteSelected() throws DatabaseException {
        return this.editModel.delete(this.selectionModel().getSelectedItems());
    }

    public final void setVisibleColumns(Attribute<?> ... attributes) {
        this.columnModel().setVisibleColumns((Object[])attributes);
    }

    public final void setVisibleColumns(List<Attribute<?>> attributes) {
        this.columnModel().setVisibleColumns(attributes);
    }

    public final void savePreferences() {
        if (((Boolean)EntityModel.USE_CLIENT_PREFERENCES.get()).booleanValue()) {
            try {
                UserPreferences.setUserPreference((String)(this.userPreferencesKey() + COLUMN_PREFERENCES), (String)EntityTableModel.ColumnPreferences.toString(this.createColumnPreferences()));
            }
            catch (Exception e) {
                LOG.error("Error while saving column preferences", (Throwable)e);
            }
            try {
                UserPreferences.setUserPreference((String)(this.userPreferencesKey() + CONDITIONS_PREFERENCES), (String)EntityTableModel.ColumnPreferences.ConditionPreferences.toString(this.createConditionPreferences()));
            }
            catch (Exception e) {
                LOG.error("Error while saving condition preferences", (Throwable)e);
            }
        }
    }

    public final StateObserver conditionChanged() {
        return this.conditionChanged.observer();
    }

    public final EventObserver<?> selectionEvent() {
        return this.selectionModel().selectionEvent();
    }

    public final void filterItems() {
        this.tableModel.filterItems();
    }

    public final Value<Predicate<Entity>> includeCondition() {
        return this.tableModel.includeCondition();
    }

    public final Collection<Entity> items() {
        return this.tableModel.items();
    }

    public final List<Entity> visibleItems() {
        return this.tableModel.visibleItems();
    }

    public final Collection<Entity> filteredItems() {
        return this.tableModel.filteredItems();
    }

    public final int visibleCount() {
        return this.tableModel.visibleCount();
    }

    public final int filteredCount() {
        return this.tableModel.filteredCount();
    }

    public final boolean containsItem(Entity item) {
        return this.tableModel.containsItem((Object)item);
    }

    public final boolean visible(Entity item) {
        return this.tableModel.visible((Object)item);
    }

    public final boolean filtered(Entity item) {
        return this.tableModel.filtered((Object)item);
    }

    public final FilteredModel.Refresher<Entity> refresher() {
        return this.tableModel.refresher();
    }

    public final void refresh() {
        this.tableModel.refresh();
    }

    public final void refreshThen(Consumer<Collection<Entity>> afterRefresh) {
        this.tableModel.refreshThen(afterRefresh);
    }

    public final void clear() {
        this.tableModel.clear();
    }

    public final int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public final int indexOf(Entity item) {
        return this.tableModel.indexOf((Object)item);
    }

    public final Entity itemAt(int rowIndex) {
        return (Entity)this.tableModel.itemAt(rowIndex);
    }

    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    public final String getStringAt(int rowIndex, Attribute<?> columnIdentifier) {
        return this.tableModel.getStringAt(rowIndex, columnIdentifier);
    }

    public final void addItems(Collection<Entity> items) {
        this.tableModel.addItems(items);
    }

    public final void addItemsSorted(Collection<Entity> items) {
        this.tableModel.addItemsSorted(items);
    }

    public final void addItemsAt(int index, Collection<Entity> items) {
        this.tableModel.addItemsAt(index, items);
    }

    public final void addItemsAtSorted(int index, Collection<Entity> items) {
        this.tableModel.addItemsAtSorted(index, items);
    }

    public final void addItem(Entity item) {
        this.tableModel.addItem((Object)item);
    }

    public final void addItemAt(int index, Entity item) {
        this.tableModel.addItemAt(index, (Object)item);
    }

    public final void addItemSorted(Entity item) {
        this.tableModel.addItemSorted((Object)item);
    }

    public final void setItemAt(int index, Entity item) {
        this.tableModel.setItemAt(index, (Object)item);
    }

    public final void removeItems(Collection<Entity> items) {
        this.tableModel.removeItems(items);
    }

    public final void removeItem(Entity item) {
        this.tableModel.removeItem((Object)item);
    }

    public final Entity removeItemAt(int index) {
        return (Entity)this.tableModel.removeItemAt(index);
    }

    public final List<Entity> removeItems(int fromIndex, int toIndex) {
        return this.tableModel.removeItems(fromIndex, toIndex);
    }

    public final void fireTableDataChanged() {
        this.tableModel.fireTableDataChanged();
    }

    public void fireTableRowsUpdated(int fromIndex, int toIndex) {
        this.tableModel.fireTableRowsUpdated(fromIndex, toIndex);
    }

    public final FilteredTableColumnModel<Attribute<?>> columnModel() {
        return this.tableModel.columnModel();
    }

    public final <T> Collection<T> values(Attribute<?> columnIdentifier) {
        return this.tableModel.values(columnIdentifier);
    }

    public final Class<?> getColumnClass(Attribute<?> columnIdentifier) {
        return this.tableModel.getColumnClass(columnIdentifier);
    }

    public final <T> Collection<T> selectedValues(Attribute<?> columnIdentifier) {
        return this.tableModel.selectedValues(columnIdentifier);
    }

    public final String rowsAsDelimitedString(char delimiter) {
        return this.tableModel.rowsAsDelimitedString(delimiter);
    }

    public final State mergeOnRefresh() {
        return this.tableModel.mergeOnRefresh();
    }

    public final void sortItems() {
        this.tableModel.sortItems();
    }

    public final FilteredTableSelectionModel<Entity> selectionModel() {
        return this.tableModel.selectionModel();
    }

    public final FilteredTableSortModel<Entity, Attribute<?>> sortModel() {
        return this.tableModel.sortModel();
    }

    public final FilteredTableSearchModel searchModel() {
        return this.tableModel.searchModel();
    }

    public final TableConditionModel<Attribute<?>> filterModel() {
        return this.tableModel.filterModel();
    }

    public final TableSummaryModel<Attribute<?>> summaryModel() {
        return this.tableModel.summaryModel();
    }

    public final int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public final String getColumnName(int columnIndex) {
        return this.tableModel.getColumnName(columnIndex);
    }

    public final Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    public final EventObserver<?> dataChangedEvent() {
        return this.tableModel.dataChangedEvent();
    }

    public final EventObserver<?> clearedEvent() {
        return this.tableModel.clearedEvent();
    }

    public final void addTableModelListener(TableModelListener listener) {
        this.tableModel.addTableModelListener(listener);
    }

    public final void removeTableModelListener(TableModelListener listener) {
        this.tableModel.removeTableModelListener(listener);
    }

    public static SwingEntityTableModel tableModel(final Collection<Entity> entities, EntityConnectionProvider connectionProvider) {
        if (Objects.requireNonNull(entities).isEmpty()) {
            throw new IllegalArgumentException("One or more entities is required for a static table model");
        }
        SwingEntityTableModel tableModel = new SwingEntityTableModel(entities.iterator().next().entityType(), connectionProvider){

            @Override
            protected Collection<Entity> refreshItems() {
                return entities;
            }
        };
        tableModel.refresh();
        return tableModel;
    }

    protected Collection<Entity> refreshItems() {
        try {
            return this.queryItems();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean conditionEnabled(EntityTableConditionModel<Attribute<?>> conditionModel) {
        return conditionModel.enabled();
    }

    protected Color toColor(Object color) {
        Objects.requireNonNull(color);
        if (color instanceof Color) {
            return (Color)color;
        }
        if (color instanceof String) {
            return this.colorCache.computeIfAbsent((String)color, Color::decode);
        }
        throw new IllegalArgumentException("Unsupported Color representation: " + color);
    }

    protected OrderBy orderBy() {
        OrderBy orderBy;
        if (((Boolean)this.orderQueryBySortOrder.get()).booleanValue() && this.sortModel().sorted() && !(orderBy = this.orderByFromSortModel()).orderByColumns().isEmpty()) {
            return orderBy;
        }
        return this.entityDefinition().orderBy().orElse(null);
    }

    protected String userPreferencesKey() {
        return this.getClass().getSimpleName() + "-" + this.entityType();
    }

    final void clearPreferences() {
        String userPreferencesKey = this.userPreferencesKey();
        UserPreferences.removeUserPreference((String)(userPreferencesKey + COLUMN_PREFERENCES));
        UserPreferences.removeUserPreference((String)(userPreferencesKey + CONDITIONS_PREFERENCES));
    }

    private void bindEvents() {
        this.columnModel().columnHiddenEvent().addDataListener(this::onColumnHidden);
        this.editEvents.addDataListener((Consumer)new HandleEditEventsListener());
        this.conditionModel.conditionChangedEvent().addListener(() -> this.onConditionChanged(this.createSelect(this.conditionModel)));
        this.editModel.afterInsertEvent().addDataListener(this::onInsert);
        this.editModel.afterUpdateEvent().addDataListener(this::onUpdate);
        this.editModel.afterDeleteEvent().addDataListener(this::onDelete);
        this.editModel.entityEvent().addDataListener(this::onEntitySet);
        this.selectionModel().selectedItemEvent().addDataListener(arg_0 -> ((SwingEntityEditModel)this.editModel).set(arg_0));
        this.addTableModelListener(this::onTableModelEvent);
    }

    private List<Entity> queryItems() throws DatabaseException {
        EntityConnection.Select select = this.createSelect(this.conditionModel);
        if (((Boolean)this.conditionRequired.get()).booleanValue() && !this.conditionEnabled(this.conditionModel)) {
            this.updateRefreshSelect(select);
            return Collections.emptyList();
        }
        List items = this.connection().select(select);
        this.updateRefreshSelect(select);
        return items;
    }

    private void updateRefreshSelect(EntityConnection.Select select) {
        this.refreshCondition = select;
        this.conditionChanged.set((Object)false);
    }

    private void onInsert(Collection<Entity> insertedEntities) {
        Collection entitiesToAdd = insertedEntities.stream().filter(entity -> entity.entityType().equals(this.entityType())).collect(Collectors.toList());
        if (!this.onInsert.isEqualTo((Object)EntityTableModel.OnInsert.DO_NOTHING) && !entitiesToAdd.isEmpty()) {
            if (!this.selectionModel().isSelectionEmpty()) {
                this.selectionModel().clearSelection();
            }
            switch ((EntityTableModel.OnInsert)this.onInsert.get()) {
                case ADD_TOP: {
                    this.tableModel.addItemsAt(0, entitiesToAdd);
                    break;
                }
                case ADD_TOP_SORTED: {
                    this.tableModel.addItemsAtSorted(0, entitiesToAdd);
                    break;
                }
                case ADD_BOTTOM: {
                    this.tableModel.addItemsAt(this.visibleCount(), entitiesToAdd);
                    break;
                }
                case ADD_BOTTOM_SORTED: {
                    this.tableModel.addItemsAtSorted(this.visibleCount(), entitiesToAdd);
                    break;
                }
            }
        }
    }

    private void onUpdate(Map<Entity.Key, Entity> updatedEntities) {
        this.replaceEntitiesByKey(new HashMap<Entity.Key, Entity>(updatedEntities));
    }

    private void onDelete(Collection<Entity> deletedEntities) {
        if (((Boolean)this.removeDeleted.get()).booleanValue()) {
            this.removeItems(deletedEntities);
        }
    }

    private void onEntitySet(Entity entity) {
        if (entity == null && !this.selectionModel().isSelectionEmpty()) {
            this.selectionModel().clearSelection();
        }
    }

    private void onTableModelEvent(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == this.selectionModel().getSelectedIndex()) {
            this.editModel.set((Entity)this.selectionModel().getSelectedItem());
        }
    }

    private void onConditionChanged(EntityConnection.Select condition) {
        this.conditionChanged.set((Object)(!Objects.equals(this.refreshCondition, condition) ? 1 : 0));
    }

    private void onColumnHidden(Attribute<?> attribute) {
        ColumnConditionModel filterModel;
        ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.conditionModel.conditionModels().get(attribute);
        if (columnConditionModel != null && !((Boolean)columnConditionModel.locked().get()).booleanValue()) {
            columnConditionModel.enabled().set((Object)false);
        }
        if ((filterModel = (ColumnConditionModel)this.filterModel().conditionModels().get(attribute)) != null && !((Boolean)filterModel.locked().get()).booleanValue()) {
            filterModel.enabled().set((Object)false);
        }
    }

    private void replaceEntitiesByKey(Map<Entity.Key, Entity> entitiesByKey) {
        for (Entity entity : this.items()) {
            Iterator<Map.Entry<Entity.Key, Entity>> iterator = entitiesByKey.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Entity.Key, Entity> entry = iterator.next();
                if (!entity.primaryKey().equals(entry.getKey())) continue;
                iterator.remove();
                entity.set(entry.getValue());
                int index = this.indexOf(entity);
                if (index < 0) continue;
                this.fireTableRowsUpdated(index, index);
            }
            if (!entitiesByKey.isEmpty()) continue;
            break;
        }
    }

    private OrderBy orderByFromSortModel() {
        OrderBy.Builder builder = OrderBy.builder();
        this.sortModel().columnSortOrder().stream().filter(columnSortOrder -> this.isColumn((Attribute)columnSortOrder.columnIdentifier())).forEach(columnSortOrder -> {
            switch (columnSortOrder.sortOrder()) {
                case ASCENDING: {
                    builder.ascending(new Column[]{(Column)columnSortOrder.columnIdentifier()});
                    break;
                }
                case DESCENDING: {
                    builder.descending(new Column[]{(Column)columnSortOrder.columnIdentifier()});
                    break;
                }
            }
        });
        return builder.build();
    }

    private boolean isColumn(Attribute<?> attribute) {
        return this.entityDefinition().attributes().definition(attribute) instanceof ColumnDefinition;
    }

    private Map<Attribute<?>, EntityTableModel.ColumnPreferences> createColumnPreferences() {
        HashMap columnPreferencesMap = new HashMap();
        for (FilteredTableColumn column : this.columnModel().columns()) {
            Attribute attribute = (Attribute)column.getIdentifier();
            int index = (Boolean)this.columnModel().visible((Object)attribute).get() != false ? this.columnModel().getColumnIndex((Object)attribute) : -1;
            columnPreferencesMap.put(attribute, EntityTableModel.ColumnPreferences.columnPreferences((Attribute)attribute, (int)index, (int)column.getWidth()));
        }
        return columnPreferencesMap;
    }

    private Map<Attribute<?>, EntityTableModel.ColumnPreferences.ConditionPreferences> createConditionPreferences() {
        HashMap conditionPreferencesMap = new HashMap();
        for (FilteredTableColumn column : this.columnModel().columns()) {
            Attribute attribute = (Attribute)column.getIdentifier();
            ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.conditionModel.conditionModels().get(attribute);
            if (columnConditionModel == null) continue;
            conditionPreferencesMap.put(attribute, EntityTableModel.ColumnPreferences.ConditionPreferences.conditionPreferences((Attribute)attribute, (boolean)((Boolean)columnConditionModel.autoEnable().get()), (boolean)((Boolean)columnConditionModel.caseSensitive().get()), (ColumnConditionModel.AutomaticWildcard)((ColumnConditionModel.AutomaticWildcard)columnConditionModel.automaticWildcard().get())));
        }
        return conditionPreferencesMap;
    }

    private void applyPreferences() {
        if (((Boolean)EntityModel.USE_CLIENT_PREFERENCES.get()).booleanValue()) {
            String conditionPreferencesString;
            String columnPreferencesString = UserPreferences.getUserPreference((String)(this.userPreferencesKey() + COLUMN_PREFERENCES), (String)"");
            if (columnPreferencesString.isEmpty()) {
                columnPreferencesString = UserPreferences.getUserPreference((String)this.userPreferencesKey(), (String)"");
            }
            if (!columnPreferencesString.isEmpty()) {
                this.applyColumnPreferences(columnPreferencesString);
            }
            if (!(conditionPreferencesString = UserPreferences.getUserPreference((String)(this.userPreferencesKey() + CONDITIONS_PREFERENCES), (String)"")).isEmpty()) {
                this.applyConditionPreferences(conditionPreferencesString);
            }
        }
    }

    private void applyColumnPreferences(String preferencesString) {
        List columnAttributes = this.columnModel().columns().stream().map(FilteredTableColumn::getIdentifier).collect(Collectors.toList());
        try {
            EntityTableModel.ColumnPreferences.apply((EntityTableModel)this, columnAttributes, (String)preferencesString, (attribute, columnWidth) -> this.columnModel().column(attribute).setPreferredWidth(columnWidth.intValue()));
        }
        catch (Exception e) {
            LOG.error("Error while applying column preferences: " + preferencesString, (Throwable)e);
        }
    }

    private void applyConditionPreferences(String preferencesString) {
        List columnAttributes = this.columnModel().columns().stream().map(FilteredTableColumn::getIdentifier).collect(Collectors.toList());
        try {
            EntityTableModel.ColumnPreferences.ConditionPreferences.apply((EntityTableModel)this, columnAttributes, (String)preferencesString);
        }
        catch (Exception e) {
            LOG.error("Error while applying condition preferences: " + preferencesString, (Throwable)e);
        }
    }

    private EntityConnection.Select createSelect(EntityTableConditionModel<Attribute<?>> conditionModel) {
        return EntityConnection.Select.where((Condition)conditionModel.where(Conjunction.AND)).having(conditionModel.having(Conjunction.AND)).attributes(this.selectAttributes()).limit((Integer)this.limit().get()).orderBy(this.orderBy()).build();
    }

    private Collection<Attribute<?>> selectAttributes() {
        FilteredTableColumnModel<Attribute<?>> columnModel = this.columnModel();
        if (((Boolean)this.queryHiddenColumns.get()).booleanValue() || columnModel.hidden().isEmpty()) {
            return (Collection)this.attributes.get();
        }
        return this.entityDefinition().attributes().selected().stream().filter(this::columnNotHidden).collect(Collectors.toList());
    }

    private boolean columnNotHidden(Attribute<?> attribute) {
        return !this.columnModel().containsColumn(attribute) || (Boolean)this.columnModel().visible(attribute).get() != false;
    }

    private FilteredTableModel<Entity, Attribute<?>> createTableModel(EntityDefinition entityDefinition, FilteredTableModel.ColumnFactory<Attribute<?>> columnFactory) {
        return FilteredTableModel.builder(columnFactory, (FilteredTableModel.ColumnValueProvider)new EntityColumnValueProvider()).filterModelFactory((ColumnConditionModel.Factory)new EntityFilterModelFactory(entityDefinition)).summaryValueProviderFactory((ColumnSummaryModel.SummaryValueProvider.Factory)new EntitySummaryValueProviderFactory(entityDefinition, this)).itemSupplier((Supplier)new EntityItemSupplier(this)).itemValidator((Predicate)new EntityItemValidator(entityDefinition.entityType())).build();
    }

    private final class UpdateListener
    implements Consumer<Map<Entity.Key, Entity>> {
        private UpdateListener() {
        }

        @Override
        public void accept(Map<Entity.Key, Entity> updated) {
            updated.values().stream().collect(Collectors.groupingBy(Entity::entityType, HashMap::new, Collectors.toList())).forEach((entityType, entities) -> SwingEntityTableModel.this.entityDefinition().foreignKeys().get(entityType).forEach(foreignKey -> SwingEntityTableModel.this.replace((ForeignKey)foreignKey, (Collection<Entity>)entities)));
        }
    }

    private class AttributeValidator
    implements Value.Validator<Set<Attribute<?>>> {
        private AttributeValidator() {
        }

        public void validate(Set<Attribute<?>> attributes) {
            for (Attribute<?> attribute : attributes) {
                if (attribute.entityType().equals(SwingEntityTableModel.this.entityType())) continue;
                throw new IllegalArgumentException(attribute + " is not part of entity:  " + SwingEntityTableModel.this.entityType());
            }
        }
    }

    private static final class SelectByKeyPredicate
    implements Predicate<Entity> {
        private final List<Entity.Key> keyList;

        private SelectByKeyPredicate(Collection<Entity.Key> keys) {
            this.keyList = new ArrayList<Entity.Key>(keys);
        }

        @Override
        public boolean test(Entity entity) {
            if (this.keyList.isEmpty()) {
                return false;
            }
            int index = this.keyList.indexOf(entity.primaryKey());
            if (index >= 0) {
                this.keyList.remove(index);
                return true;
            }
            return false;
        }
    }

    private final class HandleEditEventsListener
    implements Consumer<Boolean> {
        private HandleEditEventsListener() {
        }

        @Override
        public void accept(Boolean listen) {
            if (listen.booleanValue()) {
                this.addEditListeners();
            } else {
                this.removeEditListeners();
            }
        }

        private void addEditListeners() {
            SwingEntityTableModel.this.entityDefinition().foreignKeys().get().forEach(foreignKey -> EntityEditEvents.addUpdateListener((EntityType)foreignKey.referencedType(), SwingEntityTableModel.this.updateListener));
        }

        private void removeEditListeners() {
            SwingEntityTableModel.this.entityDefinition().foreignKeys().get().forEach(foreignKey -> EntityEditEvents.removeUpdateListener((EntityType)foreignKey.referencedType(), SwingEntityTableModel.this.updateListener));
        }
    }

    private static final class EntityColumnValueProvider
    implements FilteredTableModel.ColumnValueProvider<Entity, Attribute<?>> {
        private EntityColumnValueProvider() {
        }

        public Object value(Entity entity, Attribute<?> attribute) {
            return entity.get(attribute);
        }

        public String string(Entity entity, Attribute<?> attribute) {
            return entity.string(attribute);
        }

        public <T> Comparable<T> comparable(Entity entity, Attribute<?> attribute) {
            return (Comparable)entity.get(attribute);
        }
    }

    private static final class EntityFilterModelFactory
    implements ColumnConditionModel.Factory<Attribute<?>> {
        private final EntityDefinition entityDefinition;

        private EntityFilterModelFactory(EntityDefinition entityDefinition) {
            this.entityDefinition = Objects.requireNonNull(entityDefinition);
        }

        public Optional<ColumnConditionModel<? extends Attribute<?>, ?>> createConditionModel(Attribute<?> attribute) {
            AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
            if (attributeDefinition.hidden()) {
                return Optional.empty();
            }
            if (EntityFilterModelFactory.useStringCondition(attribute, attributeDefinition)) {
                return Optional.of(ColumnConditionModel.builder(attribute, String.class).operators(EntityFilterModelFactory.operators(String.class)).build());
            }
            return Optional.of(ColumnConditionModel.builder(attribute, (Class)attribute.type().valueClass()).operators(EntityFilterModelFactory.operators(attribute.type().valueClass())).format(attributeDefinition.format()).dateTimePattern(attributeDefinition.dateTimePattern()).build());
        }

        private static boolean useStringCondition(Attribute<?> attribute, AttributeDefinition<?> attributeDefinition) {
            return attribute.type().isEntity() || !attributeDefinition.items().isEmpty() || !Comparable.class.isAssignableFrom(attribute.type().valueClass());
        }

        private static List<Operator> operators(Class<?> columnClass) {
            if (columnClass.equals(Boolean.class)) {
                return Collections.singletonList(Operator.EQUAL);
            }
            return Arrays.asList(Operator.values());
        }
    }

    private static final class EntitySummaryValueProviderFactory
    implements ColumnSummaryModel.SummaryValueProvider.Factory<Attribute<?>> {
        private final EntityDefinition entityDefinition;
        private final FilteredTableModel<?, Attribute<?>> tableModel;

        private EntitySummaryValueProviderFactory(EntityDefinition entityDefinition, FilteredTableModel<?, Attribute<?>> tableModel) {
            this.entityDefinition = Objects.requireNonNull(entityDefinition);
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        public <T extends Number> Optional<ColumnSummaryModel.SummaryValueProvider<T>> createSummaryValueProvider(Attribute<?> attribute, Format format) {
            AttributeDefinition attributeDefinition = this.entityDefinition.attributes().definition(attribute);
            if (attribute.type().isNumerical() && attributeDefinition.items().isEmpty()) {
                return Optional.of(FilteredTableModel.summaryValueProvider(attribute, this.tableModel, (Format)format));
            }
            return Optional.empty();
        }
    }

    private static final class EntityItemSupplier
    implements Supplier<Collection<Entity>> {
        private final SwingEntityTableModel tableModel;

        private EntityItemSupplier(SwingEntityTableModel tableModel) {
            this.tableModel = Objects.requireNonNull(tableModel);
        }

        @Override
        public Collection<Entity> get() {
            return this.tableModel.refreshItems();
        }
    }

    private static final class EntityItemValidator
    implements Predicate<Entity> {
        private final EntityType entityType;

        private EntityItemValidator(EntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType);
        }

        @Override
        public boolean test(Entity entity) {
            return entity.entityType().equals(this.entityType);
        }
    }
}

