/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SwingEntityColumnFactory
implements FilteredTableModel.ColumnFactory<Attribute<?>> {
    private final EntityDefinition entityDefinition;

    public SwingEntityColumnFactory(EntityDefinition entityDefinition) {
        this.entityDefinition = Objects.requireNonNull(entityDefinition);
    }

    public final List<FilteredTableColumn<Attribute<?>>> createColumns() {
        AtomicInteger index = new AtomicInteger();
        return this.entityDefinition.attributes().definitions().stream().filter(attributeDefinition -> !attributeDefinition.hidden()).map(attributeDefinition -> this.createColumn((AttributeDefinition<?>)attributeDefinition, index.getAndIncrement())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected Optional<FilteredTableColumn<Attribute<?>>> createColumn(AttributeDefinition<?> attributeDefinition, int modelIndex) {
        FilteredTableColumn.Builder columnBuilder = FilteredTableColumn.builder((Object)attributeDefinition.attribute(), (int)modelIndex).headerValue((Object)attributeDefinition.caption()).columnClass(attributeDefinition.attribute().type().valueClass()).comparator(this.attributeComparator(attributeDefinition.attribute()));
        return Optional.of(columnBuilder.build());
    }

    protected final Comparator<?> attributeComparator(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            return this.entityDefinition.foreignKeys().referencedBy((ForeignKey)attribute).comparator();
        }
        return this.entityDefinition.attributes().definition(attribute).comparator();
    }
}

