/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class SwingEntityEditModel
extends AbstractEntityEditModel {
    private final Map<Attribute<?>, FilteredComboBoxModel<?>> comboBoxModels = new HashMap();

    public SwingEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this(entityType, Objects.requireNonNull(connectionProvider), connectionProvider.entities().definition(entityType).validator());
    }

    public SwingEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider, EntityValidator validator) {
        super(entityType, connectionProvider, validator);
    }

    public final void initializeComboBoxModels(Attribute<?> ... attributes) {
        Objects.requireNonNull(attributes);
        for (Attribute<?> attribute : attributes) {
            if (attribute instanceof ForeignKey) {
                this.foreignKeyComboBoxModel((ForeignKey)attribute).refresh();
                continue;
            }
            if (!(attribute instanceof Column)) continue;
            this.comboBoxModel((Column)attribute).refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshForeignKeyComboBoxModels() {
        Map<Attribute<?>, FilteredComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilteredComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                if (!(comboBoxModel instanceof EntityComboBoxModel)) continue;
                comboBoxModel.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshComboBoxModels() {
        Map<Attribute<?>, FilteredComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilteredComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                comboBoxModel.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearComboBoxModels() {
        Map<Attribute<?>, FilteredComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            for (FilteredComboBoxModel<?> comboBoxModel : this.comboBoxModels.values()) {
                comboBoxModel.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EntityComboBoxModel foreignKeyComboBoxModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<Attribute<?>, FilteredComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            EntityComboBoxModel comboBoxModel = (EntityComboBoxModel)this.comboBoxModels.get(foreignKey);
            if (comboBoxModel == null) {
                comboBoxModel = this.createForeignKeyComboBoxModel(foreignKey);
                this.comboBoxModels.put((Attribute<?>)foreignKey, comboBoxModel);
            }
            return comboBoxModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> FilteredComboBoxModel<T> comboBoxModel(Column<T> column) {
        this.entityDefinition().columns().definition(column);
        Map<Attribute<?>, FilteredComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            Object comboBoxModel = this.comboBoxModels.get(column);
            if (comboBoxModel == null) {
                comboBoxModel = this.createComboBoxModel(column);
                this.comboBoxModels.put((Attribute<?>)column, (FilteredComboBoxModel<?>)comboBoxModel);
            }
            return comboBoxModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsComboBoxModel(Attribute<?> attribute) {
        Map<Attribute<?>, FilteredComboBoxModel<?>> map = this.comboBoxModels;
        synchronized (map) {
            return this.comboBoxModels.containsKey(attribute);
        }
    }

    public EntityComboBoxModel createForeignKeyComboBoxModel(ForeignKey foreignKey) {
        ForeignKeyDefinition foreignKeyDefinition = this.entityDefinition().foreignKeys().definition(foreignKey);
        EntityComboBoxModel comboBoxModel = new EntityComboBoxModel(foreignKey.referencedType(), this.connectionProvider());
        comboBoxModel.attributes().set((Collection)foreignKeyDefinition.attributes());
        if (this.nullable((Attribute)foreignKey)) {
            comboBoxModel.setNullCaption((String)FilteredComboBoxModel.COMBO_BOX_NULL_CAPTION.get());
        }
        return comboBoxModel;
    }

    public <T> FilteredComboBoxModel<T> createComboBoxModel(Column<T> column) {
        Objects.requireNonNull(column, "column");
        FilteredComboBoxModel<T> comboBoxModel = this.createColumnComboBoxModel(column);
        if (this.nullable((Attribute)column)) {
            comboBoxModel.includeNull().set((Object)true);
            if (column.type().valueClass().isInterface()) {
                comboBoxModel.nullItem().set(ProxyBuilder.builder((Class)column.type().valueClass()).method("toString", parameters -> FilteredComboBoxModel.COMBO_BOX_NULL_CAPTION.get()).build());
            }
        }
        this.addInsertUpdateOrDeleteListener(() -> comboBoxModel.refresh());
        return comboBoxModel;
    }

    public final void add(ForeignKey foreignKey, Collection<Entity> entities) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(entities);
        if (this.containsComboBoxModel((Attribute<?>)foreignKey)) {
            EntityComboBoxModel comboBoxModel = this.foreignKeyComboBoxModel(foreignKey);
            for (Entity inserted : entities) {
                comboBoxModel.add(inserted);
            }
        }
    }

    public final void remove(ForeignKey foreignKey, Collection<Entity> entities) {
        Objects.requireNonNull(foreignKey);
        Objects.requireNonNull(entities);
        this.clearForeignKeyReferences(foreignKey, entities);
        if (this.containsComboBoxModel((Attribute<?>)foreignKey)) {
            EntityComboBoxModel comboBoxModel = this.foreignKeyComboBoxModel(foreignKey);
            Entity selectedEntity = (Entity)comboBoxModel.selectedValue();
            entities.forEach(arg_0 -> ((EntityComboBoxModel)comboBoxModel).remove(arg_0));
            if (comboBoxModel.visible(selectedEntity)) {
                comboBoxModel.setSelectedItem(selectedEntity);
            } else if (!comboBoxModel.nullSelected() && comboBoxModel.getSize() > 0) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
            } else {
                comboBoxModel.setSelectedItem(null);
            }
        }
    }

    protected void replaceForeignKey(ForeignKey foreignKey, Collection<Entity> entities) {
        super.replaceForeignKey(foreignKey, entities);
        if (this.containsComboBoxModel((Attribute<?>)foreignKey)) {
            EntityComboBoxModel comboBoxModel = this.foreignKeyComboBoxModel(foreignKey);
            entities.forEach(foreignKeyValue -> comboBoxModel.replace(foreignKeyValue, foreignKeyValue));
        }
    }

    private void clearForeignKeyReferences(ForeignKey foreignKey, Collection<Entity> entities) {
        entities.forEach(entity -> {
            if (Objects.equals(entity, this.get((Attribute)foreignKey))) {
                this.put((Attribute)foreignKey, null);
            }
        });
    }

    private <T> FilteredComboBoxModel<T> createColumnComboBoxModel(Column<T> column) {
        FilteredComboBoxModel comboBoxModel = new FilteredComboBoxModel();
        comboBoxModel.refresher().itemSupplier().set(column.type().isEnum() ? new EnumAttributeItemSupplier<T>(column) : new ColumnItemSupplier<T>(this.connectionProvider(), column));
        return comboBoxModel;
    }

    private static final class EnumAttributeItemSupplier<T>
    implements Supplier<Collection<T>> {
        private final Collection<T> items;

        private EnumAttributeItemSupplier(Column<T> column) {
            this.items = Arrays.asList(column.type().valueClass().getEnumConstants());
        }

        @Override
        public Collection<T> get() {
            return this.items;
        }
    }

    private static final class ColumnItemSupplier<T>
    implements Supplier<Collection<T>> {
        private final EntityConnectionProvider connectionProvider;
        private final Column<T> column;

        private ColumnItemSupplier(EntityConnectionProvider connectionProvider, Column<T> column) {
            this.connectionProvider = connectionProvider;
            this.column = column;
        }

        @Override
        public Collection<T> get() {
            try {
                return this.connectionProvider.connection().select(this.column);
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

