/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.component;

import is.codion.common.NullOrEmpty;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.proxy.ProxyBuilder;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityEditEvents;
import is.codion.swing.common.model.component.combobox.FilteredComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class EntityComboBoxModel
extends FilteredComboBoxModel<Entity> {
    private final EntityType entityType;
    private final EntityConnectionProvider connectionProvider;
    private final ValueSet<Attribute<?>> attributes = ValueSet.valueSet();
    private final Entities entities;
    private final Map<ForeignKey, Set<Entity.Key>> foreignKeyFilterKeys = new HashMap<ForeignKey, Set<Entity.Key>>();
    private final Predicate<Entity> foreignKeyIncludeCondition = new ForeignKeyIncludeCondition();
    private final Value<Supplier<Condition>> conditionSupplier;
    private final State respondToEditEvents = State.state();
    private final Value<OrderBy> orderBy;
    private final Consumer<Collection<Entity>> insertListener = new InsertListener();
    private final Consumer<Map<Entity.Key, Entity>> updateListener = new UpdateListener();
    private final Consumer<Collection<Entity>> deleteListener = new DeleteListener();
    private final State staticData = State.state();
    private final State strictForeignKeyFiltering = State.state((boolean)true);
    private boolean forceRefresh = false;

    public EntityComboBoxModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.entities = connectionProvider.entities();
        this.orderBy = Value.value((Object)this.entities.definition(entityType).orderBy());
        DefaultConditionSupplier defaultConditionSupplier = new DefaultConditionSupplier();
        this.conditionSupplier = Value.value((Object)defaultConditionSupplier, (Object)defaultConditionSupplier);
        this.selectedItemTranslator().set((Object)new SelectedItemTranslator());
        this.refresher().itemSupplier().set((Object)new ItemSupplier());
        this.itemValidator().set((Object)new ItemValidator());
        this.staticData.set((Object)this.entities.definition(entityType).staticData());
        this.includeCondition().set(this.foreignKeyIncludeCondition);
        this.refresher().addRefreshListener(() -> {
            this.forceRefresh = false;
        });
        this.refresher().addRefreshFailedListener(throwable -> {
            this.forceRefresh = false;
        });
        this.attributes.addValidator(attributes -> {
            for (Attribute attribute : Objects.requireNonNull(attributes)) {
                if (attribute.entityType().equals(entityType)) continue;
                throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + entityType);
            }
        });
        this.respondToEditEvents.addDataListener((Consumer)new EditEventListener());
        this.respondToEditEvents.set((Object)true);
    }

    public final String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [entityType: " + this.entityType + "]";
    }

    public final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    public final EntityType entityType() {
        return this.entityType;
    }

    public final void forceRefresh() {
        this.forceRefresh = true;
        this.refresh();
    }

    public final State staticData() {
        return this.staticData;
    }

    public final void setNullCaption(String nullCaption) {
        Objects.requireNonNull(nullCaption, "nullCaption");
        this.includeNull().set((Object)true);
        this.nullItem().set((Object)((Entity)ProxyBuilder.builder(Entity.class).delegate((Object)this.entities.entity(this.entityType)).method("toString", parameters -> nullCaption).build()));
    }

    public final ValueSet<Attribute<?>> attributes() {
        return this.attributes;
    }

    public final State respondToEditEvents() {
        return this.respondToEditEvents;
    }

    public final Optional<Entity> find(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        return this.items().stream().filter(Objects::nonNull).filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    public final void select(Entity.Key primaryKey) {
        Objects.requireNonNull(primaryKey);
        Optional<Entity> entity = this.find(primaryKey);
        if (entity.isPresent()) {
            this.setSelectedItem(entity.get());
        } else {
            this.filteredEntity(primaryKey).ifPresent(arg_0 -> ((EntityComboBoxModel)this).setSelectedItem(arg_0));
        }
    }

    public final Value<Supplier<Condition>> condition() {
        return this.conditionSupplier;
    }

    public final Value<OrderBy> orderBy() {
        return this.orderBy;
    }

    public final Predicate<Entity> foreignKeyIncludeCondition() {
        return this.foreignKeyIncludeCondition;
    }

    public final void setForeignKeyFilterKeys(ForeignKey foreignKey, Collection<Entity.Key> keys) {
        Objects.requireNonNull(foreignKey);
        if (NullOrEmpty.nullOrEmpty(keys)) {
            this.foreignKeyFilterKeys.remove(foreignKey);
        } else {
            this.foreignKeyFilterKeys.put(foreignKey, new HashSet<Entity.Key>(keys));
        }
        this.includeCondition().set(this.foreignKeyIncludeCondition);
        this.filterItems();
    }

    public final Collection<Entity.Key> getForeignKeyFilterKeys(ForeignKey foreignKey) {
        Objects.requireNonNull(foreignKey);
        if (this.foreignKeyFilterKeys.containsKey(foreignKey)) {
            return Collections.unmodifiableCollection(new ArrayList(this.foreignKeyFilterKeys.get(foreignKey)));
        }
        return Collections.emptyList();
    }

    public final State strictForeignKeyFiltering() {
        return this.strictForeignKeyFiltering;
    }

    public final EntityComboBoxModel createForeignKeyFilterComboBoxModel(ForeignKey foreignKey) {
        return this.createForeignKeyComboBoxModel(foreignKey, true);
    }

    public final EntityComboBoxModel createForeignKeyConditionComboBoxModel(ForeignKey foreignKey) {
        return this.createForeignKeyComboBoxModel(foreignKey, false);
    }

    public final void linkForeignKeyFilterComboBoxModel(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        this.linkForeignKeyComboBoxModel(foreignKey, foreignKeyModel, true);
    }

    public final void linkForeignKeyConditionComboBoxModel(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        this.linkForeignKeyComboBoxModel(foreignKey, foreignKeyModel, false);
    }

    public final <T> Value<T> createSelectorValue(Attribute<T> attribute) {
        if (!this.entities.definition(this.entityType()).attributes().contains(attribute)) {
            throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + this.entityType());
        }
        return this.createSelectorValue(new EntityFinder<T>(attribute));
    }

    protected Collection<Entity> performQuery() {
        try {
            return this.connectionProvider.connection().select(EntityConnection.Select.where((Condition)((Condition)((Supplier)this.conditionSupplier.get()).get())).attributes((Collection)this.attributes.get()).orderBy((OrderBy)this.orderBy.get()).build());
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Entity> filteredEntity(Entity.Key primaryKey) {
        return this.filteredItems().stream().filter(entity -> entity.primaryKey().equals(primaryKey)).findFirst();
    }

    private EntityComboBoxModel createForeignKeyComboBoxModel(ForeignKey foreignKey, boolean filter) {
        this.entities.definition(this.entityType).foreignKeys().definition(foreignKey);
        EntityComboBoxModel foreignKeyModel = new EntityComboBoxModel(foreignKey.referencedType(), this.connectionProvider);
        foreignKeyModel.setNullCaption((String)FilteredComboBoxModel.COMBO_BOX_NULL_CAPTION.get());
        foreignKeyModel.refresh();
        this.linkForeignKeyComboBoxModel(foreignKey, foreignKeyModel, filter);
        return foreignKeyModel;
    }

    private void linkForeignKeyComboBoxModel(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel, boolean filter) {
        this.entities.definition(this.entityType).foreignKeys().definition(foreignKey);
        if (!foreignKey.referencedType().equals(foreignKeyModel.entityType())) {
            throw new IllegalArgumentException("EntityComboBoxModel is of type: " + foreignKeyModel.entityType() + ", should be: " + foreignKey.referencedType());
        }
        Collection<Entity.Key> filterKeys = this.getForeignKeyFilterKeys(foreignKey);
        if (!NullOrEmpty.nullOrEmpty(filterKeys)) {
            foreignKeyModel.select(filterKeys.iterator().next());
        }
        if (filter) {
            this.linkFilter(foreignKey, foreignKeyModel);
        } else {
            this.linkCondition(foreignKey, foreignKeyModel);
        }
        this.addSelectionListener(selected -> {
            if (selected != null && !selected.isNull((Attribute)foreignKey)) {
                foreignKeyModel.select(selected.referencedKey(foreignKey));
            }
        });
        this.refresher().addRefreshListener(foreignKeyModel::forceRefresh);
    }

    private void linkFilter(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        Predicate<Entity> filterAllCondition = item -> false;
        if (((Boolean)this.strictForeignKeyFiltering.get()).booleanValue()) {
            this.includeCondition().set(filterAllCondition);
        }
        foreignKeyModel.addSelectionListener(selected -> {
            if (selected == null && ((Boolean)this.strictForeignKeyFiltering.get()).booleanValue()) {
                this.includeCondition().set((Object)filterAllCondition);
            } else {
                this.setForeignKeyFilterKeys(foreignKey, selected == null ? Collections.emptyList() : Collections.singletonList(selected.primaryKey()));
            }
        });
    }

    private void linkCondition(ForeignKey foreignKey, EntityComboBoxModel foreignKeyModel) {
        Consumer<Entity> listener = selected -> {
            this.conditionSupplier.set(() -> foreignKey.equalTo(selected));
            this.refresh();
        };
        foreignKeyModel.addSelectionListener(listener);
        listener.accept((Entity)this.selectedValue());
    }

    private final class ForeignKeyIncludeCondition
    implements Predicate<Entity> {
        private ForeignKeyIncludeCondition() {
        }

        @Override
        public boolean test(Entity item) {
            for (Map.Entry<ForeignKey, Set<Entity.Key>> entry : EntityComboBoxModel.this.foreignKeyFilterKeys.entrySet()) {
                Entity.Key referencedKey = item.referencedKey(entry.getKey());
                if (referencedKey == null) {
                    return (Boolean)EntityComboBoxModel.this.strictForeignKeyFiltering.get() == false;
                }
                if (entry.getValue().contains(referencedKey)) continue;
                return false;
            }
            return true;
        }
    }

    private final class InsertListener
    implements Consumer<Collection<Entity>> {
        private InsertListener() {
        }

        @Override
        public void accept(Collection<Entity> inserted) {
            inserted.forEach(arg_0 -> ((EntityComboBoxModel)EntityComboBoxModel.this).add(arg_0));
        }
    }

    private final class UpdateListener
    implements Consumer<Map<Entity.Key, Entity>> {
        private UpdateListener() {
        }

        @Override
        public void accept(Map<Entity.Key, Entity> updated) {
            updated.forEach((key, entity) -> EntityComboBoxModel.this.replace(Entity.entity((Entity.Key)key), entity));
        }
    }

    private final class DeleteListener
    implements Consumer<Collection<Entity>> {
        private DeleteListener() {
        }

        @Override
        public void accept(Collection<Entity> deleted) {
            deleted.forEach(arg_0 -> ((EntityComboBoxModel)EntityComboBoxModel.this).remove(arg_0));
        }
    }

    private final class DefaultConditionSupplier
    implements Supplier<Condition> {
        private DefaultConditionSupplier() {
        }

        @Override
        public Condition get() {
            return Condition.all((EntityType)EntityComboBoxModel.this.entityType);
        }
    }

    private final class SelectedItemTranslator
    implements Function<Object, Entity> {
        private SelectedItemTranslator() {
        }

        @Override
        public Entity apply(Object itemToSelect) {
            if (itemToSelect == null) {
                return null;
            }
            if (itemToSelect instanceof Entity) {
                return EntityComboBoxModel.this.find(((Entity)itemToSelect).primaryKey()).orElse((Entity)itemToSelect);
            }
            String itemToString = itemToSelect.toString();
            return EntityComboBoxModel.this.visibleItems().stream().filter(visibleItem -> visibleItem != null && itemToString.equals(visibleItem.toString())).findFirst().orElse(null);
        }
    }

    private final class ItemSupplier
    implements Supplier<Collection<Entity>> {
        private ItemSupplier() {
        }

        @Override
        public Collection<Entity> get() {
            if (((Boolean)EntityComboBoxModel.this.staticData.get()).booleanValue() && !EntityComboBoxModel.this.cleared() && !EntityComboBoxModel.this.forceRefresh) {
                return EntityComboBoxModel.this.items();
            }
            return EntityComboBoxModel.this.performQuery();
        }
    }

    private final class ItemValidator
    implements Predicate<Entity> {
        private ItemValidator() {
        }

        @Override
        public boolean test(Entity entity) {
            return entity.entityType().equals(EntityComboBoxModel.this.entityType);
        }
    }

    private final class EditEventListener
    implements Consumer<Boolean> {
        private EditEventListener() {
        }

        @Override
        public void accept(Boolean listen) {
            if (listen.booleanValue()) {
                this.addEditListeners();
            } else {
                this.removeEditListeners();
            }
        }

        private void addEditListeners() {
            EntityEditEvents.addInsertListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.insertListener);
            EntityEditEvents.addUpdateListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.updateListener);
            EntityEditEvents.addDeleteListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.deleteListener);
        }

        private void removeEditListeners() {
            EntityEditEvents.removeInsertListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.insertListener);
            EntityEditEvents.removeUpdateListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.updateListener);
            EntityEditEvents.removeDeleteListener((EntityType)EntityComboBoxModel.this.entityType, EntityComboBoxModel.this.deleteListener);
        }
    }

    private static final class EntityFinder<T>
    implements FilteredComboBoxModel.ItemFinder<Entity, T> {
        private final Attribute<T> attribute;

        private EntityFinder(Attribute<T> attribute) {
            this.attribute = attribute;
        }

        public T value(Entity item) {
            return (T)item.get(this.attribute);
        }

        public Predicate<Entity> createPredicate(T value) {
            return entity -> Objects.equals(entity.get(this.attribute), value);
        }
    }
}

