/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model;

import is.codion.common.model.table.TableSelectionModel;
import is.codion.common.state.State;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.framework.model.SwingEntityTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public final class SwingEntityTreeModel
extends DefaultTreeModel {
    private final TreeSelectionModel treeSelectionModel;
    private final ForeignKey parentForeignKey;

    private SwingEntityTreeModel(SwingEntityTableModel tableModel, ForeignKey parentForeignKey, Function<Entity, String> stringFunction) {
        super(new EntityTreeNode(Objects.requireNonNull(tableModel, "tableModel"), null, Objects.requireNonNull(stringFunction, "stringFunction"), Objects.requireNonNull(parentForeignKey, "parentForeignKey"), new EntityTreeNodeComparator(tableModel.entityDefinition().comparator())));
        if (!tableModel.entityType().equals(parentForeignKey.entityType())) {
            throw new IllegalArgumentException("parentForeignKey entity type (" + parentForeignKey.entityType() + ") must be the same as the table model entity type (" + tableModel.entityType() + ")");
        }
        this.parentForeignKey = parentForeignKey;
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.addTreeSelectionListener(new EntityTreeSelectionListener(this.treeSelectionModel, (TableSelectionModel<Entity>)tableModel.selectionModel(), this.getRoot()));
        this.bindEvents(tableModel);
    }

    @Override
    public EntityTreeNode getRoot() {
        return (EntityTreeNode)super.getRoot();
    }

    public TreeSelectionModel treeSelectionModel() {
        return this.treeSelectionModel;
    }

    public void refreshRoot() {
        this.refreshNode(this.getRoot());
    }

    public void select(Collection<Entity> entities) {
        Objects.requireNonNull(entities);
        this.treeSelectionModel.clearSelection();
        entities.forEach(entity -> this.treeSelectionModel.addSelectionPath(SwingEntityTreeModel.find(this.getRoot(), entity)));
    }

    public void refreshSelect(Collection<Entity> entities) {
        Objects.requireNonNull(entities);
        this.refreshRoot();
        this.select(entities.stream().filter(entity -> entity.isNotNull((Attribute)this.parentForeignKey)).collect(Collectors.toList()));
    }

    public void remove(Collection<Entity> entities) {
        for (Entity entity2 : Objects.requireNonNull(entities).stream().filter(entity -> entity.isNotNull((Attribute)this.parentForeignKey)).collect(Collectors.toList())) {
            TreePath treePath = SwingEntityTreeModel.find(this.getRoot(), entity2);
            if (treePath == null) continue;
            this.removeNodeFromParent((EntityTreeNode)treePath.getLastPathComponent());
        }
    }

    public static SwingEntityTreeModel swingEntityTreeModel(SwingEntityTableModel tableModel, ForeignKey parentForeignKey) {
        return SwingEntityTreeModel.swingEntityTreeModel(tableModel, parentForeignKey, Object::toString);
    }

    public static SwingEntityTreeModel swingEntityTreeModel(SwingEntityTableModel tableModel, ForeignKey parentForeignKey, Function<Entity, String> stringFunction) {
        return new SwingEntityTreeModel(tableModel, parentForeignKey, stringFunction);
    }

    private void refreshNode(EntityTreeNode treeNode) {
        treeNode.refresh();
        this.nodeStructureChanged(treeNode);
    }

    private void bindEvents(SwingEntityTableModel tableModel) {
        tableModel.refresher().addRefreshListener(this::refreshRoot);
        tableModel.editModel().addAfterUpdateListener(updatedEntities -> this.refreshSelect(updatedEntities.values()));
        tableModel.editModel().addAfterInsertListener(this::refreshSelect);
        tableModel.editModel().addAfterDeleteListener(this::remove);
    }

    private static TreePath find(EntityTreeNode root, Entity entity) {
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            EntityTreeNode node = (EntityTreeNode)enumeration.nextElement();
            if (!Objects.equals(node.nodeEntity, entity)) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    public static final class EntityTreeNode
    extends DefaultMutableTreeNode {
        private final SwingEntityTableModel tableModel;
        private final Entity nodeEntity;
        private final Comparator<EntityTreeNode> nodeComparator;
        private final Function<Entity, String> stringFunction;
        private final ForeignKey parentForeignKey;

        private EntityTreeNode(SwingEntityTableModel tableModel, Entity nodeEntity, Function<Entity, String> stringFunction, ForeignKey parentForeignKey, Comparator<EntityTreeNode> nodeComparator) {
            super(nodeEntity);
            if (nodeEntity != null && !nodeEntity.entityType().equals(tableModel.entityType())) {
                throw new IllegalArgumentException("Entity of type " + tableModel.entityType() + " expected, got: " + nodeEntity.entityType());
            }
            this.tableModel = tableModel;
            this.nodeEntity = nodeEntity;
            this.stringFunction = stringFunction;
            this.parentForeignKey = parentForeignKey;
            this.nodeComparator = nodeComparator;
        }

        public EntityTreeNode refresh() {
            this.removeAllChildren();
            this.loadChildren().forEach(this::add);
            return this;
        }

        public Entity entity() {
            return this.nodeEntity;
        }

        @Override
        public String toString() {
            return this.nodeEntity == null ? "" : this.stringFunction.apply(this.nodeEntity);
        }

        private List<EntityTreeNode> loadChildren() {
            return this.tableModel.items().stream().filter(entity -> Objects.equals(this.nodeEntity, entity.referencedEntity(this.parentForeignKey))).map(entity -> new EntityTreeNode(this.tableModel, (Entity)entity, this.stringFunction, this.parentForeignKey, this.nodeComparator)).map(EntityTreeNode::refresh).sorted(this.nodeComparator).collect(Collectors.toList());
        }
    }

    private static final class EntityTreeNodeComparator
    implements Comparator<EntityTreeNode> {
        private final Comparator<Entity> entityComparator;

        private EntityTreeNodeComparator(Comparator<Entity> entityComparator) {
            this.entityComparator = entityComparator;
        }

        @Override
        public int compare(EntityTreeNode node1, EntityTreeNode node2) {
            if (node1.getChildCount() > 0 && node2.getChildCount() == 0) {
                return -1;
            }
            if (node2.getChildCount() > 0 && node1.getChildCount() == 0) {
                return 1;
            }
            return this.entityComparator.compare(node1.nodeEntity, node2.nodeEntity);
        }
    }

    private static final class EntityTreeSelectionListener
    implements TreeSelectionListener {
        private final TableSelectionModel<Entity> tableSelectionModel;
        private final TreeSelectionModel treeSelectionModel;
        private final State treeSelectionChangingState = State.state();
        private final State tableSelectionChangingState = State.state();

        private EntityTreeSelectionListener(TreeSelectionModel treeSelectionModel, TableSelectionModel<Entity> tableSelectionModel, EntityTreeNode rootNode) {
            this.treeSelectionModel = treeSelectionModel;
            this.tableSelectionModel = tableSelectionModel;
            this.tableSelectionModel.addSelectedItemsListener(selected -> {
                try {
                    this.tableSelectionChangingState.set((Object)true);
                    if (!((Boolean)this.treeSelectionChangingState.get()).booleanValue()) {
                        treeSelectionModel.clearSelection();
                        selected.forEach(entity -> treeSelectionModel.addSelectionPath(SwingEntityTreeModel.find(rootNode, entity)));
                    }
                }
                finally {
                    this.tableSelectionChangingState.set((Object)false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent event) {
            try {
                this.treeSelectionChangingState.set((Object)true);
                if (!((Boolean)this.tableSelectionChangingState.get()).booleanValue()) {
                    ArrayList<Entity> selectedEntities = new ArrayList<Entity>(this.treeSelectionModel.getSelectionCount());
                    for (TreePath selectedPath : this.treeSelectionModel.getSelectionPaths()) {
                        selectedEntities.add(((EntityTreeNode)selectedPath.getLastPathComponent()).entity());
                    }
                    this.tableSelectionModel.setSelectedItems(selectedEntities);
                }
            }
            finally {
                this.treeSelectionChangingState.set((Object)false);
            }
        }
    }
}

