/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.generator;

import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.swing.framework.model.tools.generator.DatabaseDomain;
import is.codion.swing.framework.model.tools.metadata.MetaDataSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public final class SchemaRow {
    final MetaDataSchema metadata;
    final String catalog;
    final String schema;
    boolean populated;
    DatabaseDomain domainModel;
    final Collection<EntityDefinition> entityDefinitions = new ArrayList<EntityDefinition>();

    SchemaRow(MetaDataSchema metadata, String catalog, String schema, boolean populated) {
        this.metadata = metadata;
        this.catalog = catalog;
        this.schema = schema;
        this.populated = populated;
    }

    String catalog() {
        return this.catalog;
    }

    String name() {
        return this.schema;
    }

    boolean populated() {
        return this.populated;
    }

    Optional<DatabaseDomain> domain() {
        return Optional.ofNullable(this.domainModel);
    }

    void setDomain(DatabaseDomain domain) {
        this.domainModel = domain;
        this.entityDefinitions.clear();
        this.entityDefinitions.addAll(domain.entities().definitions());
        this.populated = true;
    }
}

