/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import is.codion.common.Separators;
import is.codion.common.Text;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.DomainModel;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.swing.framework.model.tools.generator.DatabaseDomain;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

final class DomainToString {
    private static final String INDENT = "\t";
    private static final String DOUBLE_INDENT = "\t\t";
    private static final String TRIPLE_INDENT = "\t\t\t";
    private static final String DOMAIN = "DOMAIN";

    private DomainToString() {
    }

    static String apiString(List<DatabaseDomain> domains, String packageName) {
        return domains.stream().map(domain -> DomainToString.toApiString(domain.type().name(), DomainToString.sortDefinitions((Domain)domain), packageName)).collect(Collectors.joining(Separators.LINE_SEPARATOR + Separators.LINE_SEPARATOR));
    }

    static String implementationString(Collection<DatabaseDomain> domains, String packageName) {
        return domains.stream().map(domain -> DomainToString.toImplementationString(domain.type().name(), DomainToString.sortDefinitions((Domain)domain), packageName)).collect(Collectors.joining(Separators.LINE_SEPARATOR + Separators.LINE_SEPARATOR));
    }

    static String combinedString(Collection<DatabaseDomain> domains, String packageName) {
        return domains.stream().map(domain -> DomainToString.toCombinedString(domain.type().name(), DomainToString.sortDefinitions((Domain)domain), packageName)).collect(Collectors.joining(Separators.LINE_SEPARATOR + Separators.LINE_SEPARATOR));
    }

    private static String toApiString(String domainName, List<EntityDefinition> definitions, String packageName) {
        String className = DomainToString.interfaceName(domainName, true);
        TypeSpec.Builder classBuilder = TypeSpec.interfaceBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(FieldSpec.builder(DomainType.class, (String)DOMAIN, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("domainType($L)", new Object[]{className + ".class"}).build());
        definitions.forEach(definition -> classBuilder.addType(DomainToString.createInterface(definition)));
        return DomainToString.removeInterfaceLineBreaks(JavaFile.builder((String)(packageName.isEmpty() ? "" : packageName), (TypeSpec)classBuilder.build()).addStaticImport(DomainType.class, new String[]{"domainType"}).skipJavaLangImports(true).indent(INDENT).build().toString());
    }

    private static String toImplementationString(String domainName, List<EntityDefinition> definitions, String packageName) {
        String className = DomainToString.interfaceName(domainName, true);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)(className + "Impl")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(DomainModel.class);
        Map<EntityDefinition, String> definitionMethods = DomainToString.addDefinitionMethods(definitions, classBuilder);
        Object implementationPackage = packageName.isEmpty() ? "" : packageName + ".impl";
        JavaFile.Builder fileBuilder = JavaFile.builder((String)implementationPackage, (TypeSpec)classBuilder.addMethod(DomainToString.createDomainConstructor(definitionMethods)).build()).addStaticImport(KeyGenerator.class, new String[]{"identity"}).skipJavaLangImports(true).indent(INDENT);
        if (!((String)implementationPackage).isEmpty()) {
            fileBuilder.addStaticImport(ClassName.bestGuess((String)(packageName + "." + className)), new String[]{DOMAIN});
        }
        String sourceString = fileBuilder.build().toString();
        if (!packageName.isEmpty()) {
            sourceString = DomainToString.addInterfaceImports(sourceString, definitions, packageName + "." + className);
        }
        return sourceString;
    }

    private static String toCombinedString(String domainName, List<EntityDefinition> definitions, String packageName) {
        String className = DomainToString.interfaceName(domainName, true);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(FieldSpec.builder(DomainType.class, (String)DOMAIN, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("domainType($L)", new Object[]{className + ".class"}).build()).superclass(DomainModel.class);
        Map<EntityDefinition, String> definitionMethods = DomainToString.addDefinitionMethods(definitions, classBuilder);
        definitions.forEach(definition -> classBuilder.addType(DomainToString.createInterface(definition)));
        JavaFile.Builder fileBuilder = JavaFile.builder((String)packageName, (TypeSpec)classBuilder.addMethod(DomainToString.createDomainConstructor(definitionMethods)).build()).addStaticImport(DomainType.class, new String[]{"domainType"}).addStaticImport(KeyGenerator.class, new String[]{"identity"}).skipJavaLangImports(true).indent(INDENT);
        if (!packageName.isEmpty()) {
            fileBuilder.addStaticImport(ClassName.bestGuess((String)(packageName + "." + className)), new String[]{DOMAIN});
        }
        String sourceString = fileBuilder.build().toString();
        if (!packageName.isEmpty()) {
            sourceString = DomainToString.addInterfaceImports(sourceString, definitions, packageName + "." + className);
        }
        return DomainToString.removeInterfaceLineBreaks(sourceString);
    }

    private static MethodSpec createDomainConstructor(Map<EntityDefinition, String> definitionMethods) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(DOMAIN)", new Object[0]);
        if (DomainToString.cyclicalDependencies(definitionMethods.keySet())) {
            constructorBuilder.addStatement("setStrictForeignKeys(false)", new Object[0]);
        }
        StringBuilder addParameters = DomainToString.createAddParameters(new ArrayList<String>(definitionMethods.values()));
        return constructorBuilder.addStatement("add(" + addParameters + ")", new Object[0]).build();
    }

    private static Map<EntityDefinition, String> addDefinitionMethods(Collection<EntityDefinition> definitions, TypeSpec.Builder classBuilder) {
        LinkedHashMap<EntityDefinition, String> definitionMethods = new LinkedHashMap<EntityDefinition, String>();
        definitions.forEach(definition -> DomainToString.addDefinition(definition, classBuilder, definitionMethods::put));
        return definitionMethods;
    }

    private static void addDefinition(EntityDefinition definition, TypeSpec.Builder classBuilder, BiConsumer<EntityDefinition, String> onMethod) {
        MethodSpec definitionMethod = DomainToString.createDefinitionMethod(definition);
        classBuilder.addMethod(definitionMethod);
        onMethod.accept(definition, definitionMethod.name);
    }

    private static TypeSpec createInterface(EntityDefinition definition) {
        String interfaceName = DomainToString.interfaceName(definition.tableName(), true);
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addField(FieldSpec.builder(EntityType.class, (String)"TYPE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("DOMAIN.entityType($S)", new Object[]{definition.tableName().toLowerCase()}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        definition.attributes().definitions().stream().filter(ColumnDefinition.class::isInstance).forEach(columnDefinition -> DomainToString.appendAttribute(interfaceBuilder, columnDefinition));
        definition.attributes().definitions().stream().filter(ForeignKeyDefinition.class::isInstance).forEach(foreignKeyDefinition -> DomainToString.appendAttribute(interfaceBuilder, foreignKeyDefinition));
        return interfaceBuilder.build();
    }

    private static MethodSpec createDefinitionMethod(EntityDefinition definition) {
        String interfaceName = DomainToString.interfaceName(definition.tableName(), true);
        StringBuilder builder = new StringBuilder().append("return ").append(interfaceName).append(".TYPE.define(").append(Separators.LINE_SEPARATOR).append(String.join((CharSequence)("," + Separators.LINE_SEPARATOR), DomainToString.createAttributes(definition.attributes().definitions(), definition, interfaceName))).append(")");
        if (definition.primaryKey().generated()) {
            builder.append(Separators.LINE_SEPARATOR).append(INDENT).append(".keyGenerator(identity())");
        }
        if (!Text.nullOrEmpty((String)definition.caption())) {
            builder.append(Separators.LINE_SEPARATOR).append(INDENT).append(".caption(\"").append(definition.caption()).append("\")");
        }
        if (!Text.nullOrEmpty((String)definition.description())) {
            builder.append(Separators.LINE_SEPARATOR).append(INDENT).append(".description(\"").append(definition.description()).append("\")");
        }
        if (definition.readOnly()) {
            builder.append(Separators.LINE_SEPARATOR).append(INDENT).append(".readOnly(true)");
        }
        builder.append(Separators.LINE_SEPARATOR).append(INDENT).append(".build();");
        return MethodSpec.methodBuilder((String)DomainToString.interfaceName(definition.tableName(), false)).addModifiers(new Modifier[]{Modifier.STATIC}).returns(EntityDefinition.class).addCode(builder.toString(), new Object[0]).build();
    }

    private static StringBuilder createAddParameters(List<String> definitionMethodNames) {
        StringBuilder definitionMethods = new StringBuilder();
        for (int i = 0; i < definitionMethodNames.size(); ++i) {
            definitionMethods.append(definitionMethodNames.get(i)).append("()");
            if (i >= definitionMethodNames.size() - 1) continue;
            if ((i + 1) % 3 != 0) {
                definitionMethods.append(", ");
                continue;
            }
            if (i <= 0) continue;
            definitionMethods.append(",\n");
        }
        return definitionMethods;
    }

    private static List<String> createAttributes(Collection<AttributeDefinition<?>> attributeDefinitions, EntityDefinition definition, String interfaceName) {
        return attributeDefinitions.stream().map(attributeDefinition -> DomainToString.createAttribute(attributeDefinition, definition, interfaceName)).collect(Collectors.toList());
    }

    private static String createAttribute(AttributeDefinition<?> attributeDefinition, EntityDefinition definition, String interfaceName) {
        if (attributeDefinition instanceof ColumnDefinition) {
            ColumnDefinition columnDefinition = (ColumnDefinition)attributeDefinition;
            return DomainToString.columnDefinition(interfaceName, columnDefinition, definition.foreignKeys().foreignKeyColumn(columnDefinition.attribute()), definition.primaryKey().columns().size() > 1, definition.readOnly());
        }
        return DomainToString.foreignKeyDefinition(interfaceName, (ForeignKeyDefinition)attributeDefinition);
    }

    private static void appendAttribute(TypeSpec.Builder interfaceBuilder, AttributeDefinition<?> attributeDefinition) {
        if (attributeDefinition instanceof ColumnDefinition) {
            ColumnDefinition columnDefinition = (ColumnDefinition)attributeDefinition;
            FieldSpec.Builder columnBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get(Column.class, (Type[])new Type[]{columnDefinition.attribute().type().valueClass()}), (String)columnDefinition.name().toUpperCase(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
            DomainToString.addInitializer(columnBuilder, columnDefinition);
            interfaceBuilder.addField(columnBuilder.build());
        } else if (attributeDefinition instanceof ForeignKeyDefinition) {
            ForeignKeyDefinition foreignKeyDefinition = (ForeignKeyDefinition)attributeDefinition;
            interfaceBuilder.addField(FieldSpec.builder(ForeignKey.class, (String)attributeDefinition.attribute().name().toUpperCase(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("TYPE.foreignKey($S, $L)", new Object[]{attributeDefinition.attribute().name().toLowerCase(), DomainToString.createReferences(foreignKeyDefinition)}).build());
        }
    }

    private static void addInitializer(FieldSpec.Builder columnBuilder, ColumnDefinition<?> columnDefinition) {
        if (Object.class.equals((Object)columnDefinition.attribute().type().valueClass())) {
            columnBuilder.initializer("TYPE.column($S, $L)", new Object[]{columnDefinition.name().toLowerCase(), "Object.class"});
        } else {
            columnBuilder.initializer("TYPE.$LColumn($S)", new Object[]{DomainToString.attributeTypePrefix(columnDefinition.attribute().type().valueClass().getSimpleName()), columnDefinition.name().toLowerCase()});
        }
    }

    private static String createReferences(ForeignKeyDefinition foreignKeyDefinition) {
        return foreignKeyDefinition.references().stream().map(reference -> reference.column().name().toUpperCase() + ", " + DomainToString.interfaceName(reference.foreign().entityType().name(), true) + "." + reference.foreign().name().toUpperCase()).collect(Collectors.joining(", "));
    }

    private static String foreignKeyDefinition(String interfaceName, ForeignKeyDefinition definition) {
        String foreignKeyName = definition.attribute().name().toUpperCase();
        return DOUBLE_INDENT + interfaceName + "." + foreignKeyName + ".define()" + Separators.LINE_SEPARATOR + TRIPLE_INDENT + ".foreignKey()" + Separators.LINE_SEPARATOR + TRIPLE_INDENT + ".caption(\"" + definition.caption() + "\")";
    }

    private static String columnDefinition(String interfaceName, ColumnDefinition<?> column, boolean foreignKeyColumn, boolean compositePrimaryKey, boolean readOnly) {
        StringBuilder builder = new StringBuilder(DOUBLE_INDENT).append(interfaceName).append(".").append(column.name().toUpperCase()).append(".define()").append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".").append(DomainToString.definitionType(column, compositePrimaryKey));
        if (!foreignKeyColumn && !column.primaryKey()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".caption(").append("\"").append(column.caption()).append("\")");
        }
        if (!column.nullable() && !column.primaryKey()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".nullable(false)");
        }
        if (column.lazy()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".lazy(true)");
        }
        if (!readOnly) {
            if (column.columnHasDefaultValue()) {
                builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".columnHasDefaultValue(true)");
            }
            if (column.attribute().type().isString() && column.maximumLength() != -1) {
                builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".maximumLength(").append(column.maximumLength()).append(")");
            }
            if (column.attribute().type().isDecimal() && column.maximumFractionDigits() >= 1) {
                builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".maximumFractionDigits(").append(column.maximumFractionDigits()).append(")");
            }
        }
        if (!Text.nullOrEmpty((String)column.description())) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".description(").append("\"").append(column.description()).append("\")");
        }
        return builder.toString();
    }

    private static String attributeTypePrefix(String valueClassName) {
        if ("byte[]".equals(valueClassName)) {
            return "byteArray";
        }
        return valueClassName.substring(0, 1).toLowerCase() + valueClassName.substring(1);
    }

    private static String definitionType(ColumnDefinition<?> column, boolean compositePrimaryKey) {
        if (column.primaryKey()) {
            return compositePrimaryKey ? "primaryKey(" + column.primaryKeyIndex() + ")" : "primaryKey()";
        }
        return "column()";
    }

    static String interfaceName(String tableName, boolean uppercase) {
        Object name = tableName.toLowerCase();
        if (((String)name).contains(".")) {
            name = ((String)name).substring(((String)name).lastIndexOf(46) + 1);
        }
        name = DomainToString.underscoreToCamelCase((String)name);
        if (uppercase) {
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        }
        return name;
    }

    private static String removeInterfaceLineBreaks(String sourceString) {
        String[] lines = sourceString.split("\n");
        for (int i = 1; i < lines.length - 1; ++i) {
            String line = lines[i];
            if (line == null || !line.trim().isEmpty() || !DomainToString.betweenColumnsOrForeignKeys(lines, i)) continue;
            lines[i] = null;
        }
        return Arrays.stream(lines).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    private static String addInterfaceImports(String sourceString, Collection<EntityDefinition> definitions, String parentInterface) {
        List<String> interfaceNames = definitions.stream().map(DomainToString::createInterface).map(interfaceSpec -> interfaceSpec.name).sorted().collect(Collectors.toList());
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : sourceString.split("\n")) {
            lines.add(line);
            if (!line.endsWith("EntityDefinition;")) continue;
            interfaceNames.forEach(name -> lines.add("import " + parentInterface + "." + name + ";"));
        }
        return String.join((CharSequence)"\n", lines);
    }

    private static boolean betweenColumnsOrForeignKeys(String[] lines, int lineIndex) {
        return DomainToString.betweenLinesStartingWith(lines, lineIndex, "Column") || DomainToString.betweenLinesStartingWith(lines, lineIndex, "ForeignKey");
    }

    private static boolean betweenLinesStartingWith(String[] lines, int lineIndex, String prefix) {
        String previousLine = lines[lineIndex - 1];
        String nextLine = lines[lineIndex + 1];
        return DomainToString.lineStartsWith(previousLine, prefix) && DomainToString.lineStartsWith(nextLine, prefix);
    }

    private static boolean lineStartsWith(String line, String prefix) {
        return line != null && line.trim().startsWith(prefix);
    }

    static String apiSearchString(EntityDefinition definition) {
        return "interface " + DomainToString.interfaceName(definition.tableName(), true) + " ";
    }

    static String implSearchString(EntityDefinition definition) {
        return "EntityDefinition " + DomainToString.interfaceName(definition.tableName(), false) + "()";
    }

    static List<EntityDefinition> sortDefinitions(Domain domain) {
        Map<EntityType, Set<EntityType>> dependencies = DomainToString.dependencies(domain);
        Collection definitions = domain.entities().definitions();
        return Stream.concat(definitions.stream().filter(definition -> ((Set)dependencies.get(definition.entityType())).isEmpty()).sorted(Comparator.comparing(EntityDefinition::tableName)), definitions.stream().filter(definition -> !((Set)dependencies.get(definition.entityType())).isEmpty()).sorted(Comparator.comparing(EntityDefinition::tableName)).sorted(new DependencyOrder(dependencies))).collect(Collectors.toList());
    }

    static boolean cyclicalDependencies(Collection<EntityDefinition> definitions) {
        Map<EntityType, EntityDefinition> definitionMap = definitions.stream().collect(Collectors.toMap(EntityDefinition::entityType, Function.identity()));
        for (EntityDefinition definition : definitions) {
            Set<EntityType> dependencies = DomainToString.dependencies(definition.foreignKeys().get(), new HashSet<EntityType>(), definitionMap);
            if (!dependencies.contains(definition.entityType())) continue;
            return true;
        }
        return false;
    }

    private static Map<EntityType, Set<EntityType>> dependencies(Domain domain) {
        Map definitions = domain.entities().definitions().stream().collect(Collectors.toMap(EntityDefinition::entityType, Function.identity()));
        return domain.entities().definitions().stream().collect(Collectors.toMap(EntityDefinition::entityType, definition -> DomainToString.dependencies(definition, definitions)));
    }

    private static Set<EntityType> dependencies(EntityDefinition definition, Map<EntityType, EntityDefinition> definitions) {
        return DomainToString.dependencies(definition.foreignKeys().get(), new HashSet<EntityType>(), definitions);
    }

    private static Set<EntityType> dependencies(Collection<ForeignKey> foreignKeys, Set<EntityType> dependencies, Map<EntityType, EntityDefinition> definitions) {
        foreignKeys.stream().filter(foreignKey -> !foreignKey.referencedType().equals(foreignKey.entityType())).filter(foreignKey -> !dependencies.contains(foreignKey.referencedType())).forEach(foreignKey -> {
            dependencies.add(foreignKey.referencedType());
            dependencies.addAll(DomainToString.dependencies(((EntityDefinition)definitions.get(foreignKey.referencedType())).foreignKeys().get(), dependencies, definitions));
        });
        return dependencies;
    }

    static String underscoreToCamelCase(String text) {
        if (!Objects.requireNonNull(text, "text").contains("_")) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        boolean firstDone = false;
        List strings = Arrays.stream(text.toLowerCase().split("_")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
        if (strings.size() == 1) {
            return (String)strings.get(0);
        }
        for (String split : strings) {
            if (!firstDone) {
                builder.append(Character.toLowerCase(split.charAt(0)));
                firstDone = true;
            } else {
                builder.append(Character.toUpperCase(split.charAt(0)));
            }
            if (split.length() <= 1) continue;
            builder.append(split.substring(1).toLowerCase());
        }
        return builder.toString();
    }

    private static final class DependencyOrder
    implements Comparator<EntityDefinition> {
        private final Map<EntityType, Set<EntityType>> dependencies;

        private DependencyOrder(Map<EntityType, Set<EntityType>> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public int compare(EntityDefinition definition1, EntityDefinition definition2) {
            if (this.dependencies.get(definition1.entityType()).contains(definition2.entityType())) {
                return 1;
            }
            if (this.dependencies.get(definition2.entityType()).contains(definition1.entityType())) {
                return -1;
            }
            return 0;
        }
    }
}

