/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.generator;

import is.codion.common.Text;
import is.codion.framework.domain.DomainModel;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.framework.model.tools.metadata.MetaDataColumn;
import is.codion.swing.framework.model.tools.metadata.MetaDataForeignKeyConstraint;
import is.codion.swing.framework.model.tools.metadata.MetaDataSchema;
import is.codion.swing.framework.model.tools.metadata.MetaDataTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class DatabaseDomain
extends DomainModel {
    private static final int MAXIMUM_COLUMN_SIZE = Integer.MAX_VALUE;
    private final Map<MetaDataTable, EntityType> tableEntityTypes = new HashMap<MetaDataTable, EntityType>();

    DatabaseDomain(MetaDataSchema schema) {
        super(DomainType.domainType((String)schema.name()));
        this.setStrictForeignKeys(false);
        schema.tables().values().forEach(this::defineEntity);
    }

    String tableType(EntityType entityType) {
        return this.tableEntityTypes.entrySet().stream().filter(entry -> ((EntityType)entry.getValue()).equals(entityType)).findFirst().map(Map.Entry::getKey).map(MetaDataTable::tableType).orElseThrow(IllegalArgumentException::new);
    }

    private void defineEntity(MetaDataTable table) {
        if (!this.tableEntityTypes.containsKey(table)) {
            EntityType entityType = this.type().entityType(table.schema().name() + "." + table.tableName());
            this.tableEntityTypes.put(table, entityType);
            table.foreignKeys().stream().map(MetaDataForeignKeyConstraint::referencedTable).filter(referencedTable -> !referencedTable.equals(table)).forEach(this::defineEntity);
            this.defineEntity(table, entityType);
        }
    }

    private void defineEntity(MetaDataTable table, EntityType entityType) {
        List<AttributeDefinition.Builder<?, ?>> attributeDefinitionBuilders = this.defineAttributes(table, entityType, new ArrayList<MetaDataForeignKeyConstraint>(table.foreignKeys()));
        if (!attributeDefinitionBuilders.isEmpty()) {
            EntityDefinition.Builder entityDefinitionBuilder = entityType.define(attributeDefinitionBuilders.toArray(new AttributeDefinition.Builder[0]));
            entityDefinitionBuilder.caption(DatabaseDomain.caption(table.tableName()));
            if (DatabaseDomain.tableHasAutoIncrementPrimaryKeyColumn(table)) {
                entityDefinitionBuilder.keyGenerator(KeyGenerator.identity());
            }
            if (!Text.nullOrEmpty((String)table.comment())) {
                entityDefinitionBuilder.description(table.comment());
            }
            entityDefinitionBuilder.readOnly("view".equalsIgnoreCase(table.tableType()));
            this.add(new EntityDefinition.Builder[]{entityDefinitionBuilder});
        }
    }

    private List<AttributeDefinition.Builder<?, ?>> defineAttributes(MetaDataTable table, EntityType entityType, Collection<MetaDataForeignKeyConstraint> foreignKeyConstraints) {
        ArrayList builders = new ArrayList();
        table.columns().forEach(column -> {
            builders.add((AttributeDefinition.Builder<?, ?>)DatabaseDomain.columnDefinitionBuilder(column, entityType));
            if (column.foreignKeyColumn()) {
                foreignKeyConstraints.stream().filter(foreignKeyConstraint -> DatabaseDomain.lastKeyColumn(foreignKeyConstraint, column)).findFirst().ifPresent(foreignKeyConstraint -> {
                    foreignKeyConstraints.remove(foreignKeyConstraint);
                    builders.add(this.foreignKeyDefinitionBuilder((MetaDataForeignKeyConstraint)foreignKeyConstraint, entityType));
                });
            }
        });
        return builders;
    }

    private AttributeDefinition.Builder<?, ?> foreignKeyDefinitionBuilder(MetaDataForeignKeyConstraint foreignKeyConstraint, EntityType entityType) {
        MetaDataTable referencedTable = foreignKeyConstraint.referencedTable();
        EntityType referencedEntityType = this.tableEntityTypes.get(referencedTable);
        ForeignKey foreignKey = entityType.foreignKey(DatabaseDomain.createForeignKeyName(foreignKeyConstraint) + "_FK", foreignKeyConstraint.references().entrySet().stream().map(entry -> ForeignKey.reference(DatabaseDomain.column(entityType, (MetaDataColumn)entry.getKey()), DatabaseDomain.column(referencedEntityType, (MetaDataColumn)entry.getValue()))).collect(Collectors.toList()));
        return foreignKey.define().foreignKey().caption(DatabaseDomain.caption(referencedTable.tableName().toLowerCase()));
    }

    private static ColumnDefinition.Builder<?, ?> columnDefinitionBuilder(MetaDataColumn metadataColumn, EntityType entityType) {
        String caption = DatabaseDomain.caption(metadataColumn.columnName());
        Column column = DatabaseDomain.column(entityType, metadataColumn);
        ColumnDefinition.Builder builder = metadataColumn.primaryKeyColumn() ? column.define().primaryKey(metadataColumn.primaryKeyIndex() - 1) : (ColumnDefinition.Builder)column.define().column().caption(caption);
        if (!metadataColumn.primaryKeyColumn() && metadataColumn.nullable() == 0) {
            builder.nullable(false);
        }
        if (column.type().isString() && metadataColumn.columnSize() > 0 && metadataColumn.columnSize() < Integer.MAX_VALUE) {
            builder.maximumLength(metadataColumn.columnSize());
        }
        if (column.type().isDecimal() && metadataColumn.decimalDigits() >= 1) {
            builder.maximumFractionDigits(metadataColumn.decimalDigits());
        }
        if (!metadataColumn.primaryKeyColumn() && metadataColumn.defaultValue() != null) {
            builder.columnHasDefaultValue(true);
        }
        if (!Text.nullOrEmpty((String)metadataColumn.comment())) {
            builder.description(metadataColumn.comment());
        }
        return builder;
    }

    private static <T> Column<T> column(EntityType entityType, MetaDataColumn column) {
        return entityType.column(column.columnName(), column.columnClass());
    }

    private static String caption(String name) {
        String caption = name.toLowerCase().replace("_", " ");
        return caption.substring(0, 1).toUpperCase() + caption.substring(1);
    }

    private static boolean lastKeyColumn(MetaDataForeignKeyConstraint foreignKeyConstraint, MetaDataColumn column) {
        return foreignKeyConstraint.references().keySet().stream().mapToInt(MetaDataColumn::position).max().orElse(-1) == column.position();
    }

    private static String createForeignKeyName(MetaDataForeignKeyConstraint foreignKeyConstraint) {
        return foreignKeyConstraint.references().keySet().stream().map(MetaDataColumn::columnName).map(String::toUpperCase).collect(Collectors.joining("_"));
    }

    private static boolean tableHasAutoIncrementPrimaryKeyColumn(MetaDataTable table) {
        return table.columns().stream().filter(MetaDataColumn::primaryKeyColumn).anyMatch(MetaDataColumn::autoIncrement);
    }
}

