/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.common.db.result.ResultPacker;
import is.codion.swing.framework.model.tools.metadata.MetaDataColumn;
import is.codion.swing.framework.model.tools.metadata.MetaDataForeignKeyColumn;
import is.codion.swing.framework.model.tools.metadata.MetaDataForeignKeyConstraint;
import is.codion.swing.framework.model.tools.metadata.MetaDataPrimaryKeyColumn;
import is.codion.swing.framework.model.tools.metadata.MetaDataSchema;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MetaDataTable {
    private final MetaDataSchema schema;
    private final String tableName;
    private final String tableType;
    private final String comment;
    private final List<MetaDataForeignKeyColumn> foreignKeyColumns;
    private final Map<String, MetaDataColumn> columns = new LinkedHashMap<String, MetaDataColumn>();
    private final List<MetaDataForeignKeyConstraint> foreignKeys = new ArrayList<MetaDataForeignKeyConstraint>();

    MetaDataTable(MetaDataSchema schema, String tableName, String tableType, String comment, List<MetaDataColumn> columns, List<MetaDataForeignKeyColumn> foreignKeyColumns) {
        this.schema = Objects.requireNonNull(schema);
        this.tableName = Objects.requireNonNull(tableName);
        this.tableType = Objects.requireNonNull(tableType);
        this.comment = comment == null ? null : comment.trim().replace("\"", "\\\"");
        this.foreignKeyColumns = Objects.requireNonNull(foreignKeyColumns);
        Objects.requireNonNull(columns).forEach(column -> this.columns.put(column.columnName(), (MetaDataColumn)column));
    }

    public String tableName() {
        return this.tableName;
    }

    public MetaDataSchema schema() {
        return this.schema;
    }

    public String tableType() {
        return this.tableType;
    }

    public String comment() {
        return this.comment;
    }

    public List<MetaDataColumn> columns() {
        return Collections.unmodifiableList(new ArrayList<MetaDataColumn>(this.columns.values()));
    }

    public Collection<String> referencedSchemaNames() {
        return this.foreignKeyColumns.stream().filter(this::referencesExternalSchema).map(MetaDataForeignKeyColumn::pkSchemaName).collect(Collectors.toSet());
    }

    public Collection<MetaDataForeignKeyConstraint> foreignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys);
    }

    public String toString() {
        return this.schema.name() + "." + this.tableName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetaDataTable table = (MetaDataTable)object;
        return Objects.equals(this.schema, table.schema()) && Objects.equals(this.tableName, table.tableName());
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.tableName);
    }

    void resolveForeignKeys(Map<String, MetaDataSchema> schemas) {
        for (MetaDataForeignKeyColumn foreignKeyColumn : this.foreignKeyColumns) {
            MetaDataForeignKeyConstraint foreignKeyConstraint;
            MetaDataTable referencedTable = MetaDataTable.referencedTable(foreignKeyColumn, schemas);
            if (foreignKeyColumn.keySeq() == 1) {
                foreignKeyConstraint = new MetaDataForeignKeyConstraint(referencedTable);
                this.foreignKeys.add(foreignKeyConstraint);
            } else {
                foreignKeyConstraint = this.foreignKeys.get(this.foreignKeys.size() - 1);
            }
            foreignKeyConstraint.addReference(this.columns.get(foreignKeyColumn.fkColumnName()), referencedTable.columns.get(foreignKeyColumn.pkColumnName()));
        }
    }

    private boolean referencesExternalSchema(MetaDataForeignKeyColumn foreignKeyColumn) {
        return !foreignKeyColumn.pkSchemaName().equals(this.schema.name());
    }

    private static MetaDataTable referencedTable(MetaDataForeignKeyColumn foreignKeyColumn, Map<String, MetaDataSchema> schemas) {
        MetaDataTable referencedTable = schemas.get(foreignKeyColumn.pkSchemaName()).tables().get(foreignKeyColumn.pkTableName());
        if (referencedTable == null) {
            throw new IllegalStateException("Referenced table not found: " + foreignKeyColumn.pkSchemaName() + "." + foreignKeyColumn.pkTableName());
        }
        return referencedTable;
    }

    static final class TablePacker
    implements ResultPacker<MetaDataTable> {
        private final MetaDataSchema schema;
        private final DatabaseMetaData metaData;
        private final String catalog;

        TablePacker(MetaDataSchema schema, DatabaseMetaData metaData, String catalog) {
            this.schema = schema;
            this.metaData = metaData;
            this.catalog = catalog;
        }

        public MetaDataTable get(ResultSet resultSet) throws SQLException {
            String tableName = resultSet.getString("TABLE_NAME");
            String remarks = resultSet.getString("REMARKS");
            String tableType = resultSet.getString("TABLE_TYPE");
            List<MetaDataPrimaryKeyColumn> primaryKeyColumns = TablePacker.primaryKeyColumns(this.schema, this.metaData, this.catalog, tableName);
            List<MetaDataForeignKeyColumn> foreignKeyColumns = TablePacker.foreignKeyColumns(this.schema, this.metaData, this.catalog, tableName);
            List<MetaDataColumn> columns = TablePacker.columns(this.schema, this.metaData, this.catalog, tableName, primaryKeyColumns, foreignKeyColumns);
            return new MetaDataTable(this.schema, tableName, tableType, remarks, columns, foreignKeyColumns);
        }

        private static List<MetaDataPrimaryKeyColumn> primaryKeyColumns(MetaDataSchema schema, DatabaseMetaData metaData, String catalog, String tableName) throws SQLException {
            try (ResultSet resultSet = metaData.getPrimaryKeys(catalog, schema.name(), tableName);){
                List list = new MetaDataPrimaryKeyColumn.PrimaryKeyColumnPacker().pack(resultSet);
                return list;
            }
        }

        private static List<MetaDataForeignKeyColumn> foreignKeyColumns(MetaDataSchema schema, DatabaseMetaData metaData, String catalog, String tableName) throws SQLException {
            try (ResultSet resultSet = metaData.getImportedKeys(catalog, schema.name(), tableName);){
                List list = new MetaDataForeignKeyColumn.ForeignKeyColumnPacker().pack(resultSet);
                return list;
            }
        }

        private static List<MetaDataColumn> columns(MetaDataSchema schema, DatabaseMetaData metaData, String catalog, String tableName, List<MetaDataPrimaryKeyColumn> primaryKeyColumns, List<MetaDataForeignKeyColumn> foreignKeyColumns) throws SQLException {
            try (ResultSet resultSet = metaData.getColumns(catalog, schema.name(), tableName, null);){
                List list = new MetaDataColumn.ColumnPacker(primaryKeyColumns, foreignKeyColumns).pack(resultSet);
                return list;
            }
        }
    }
}

