/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.swing.framework.model.tools.metadata.MetaDataTable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MetaDataSchema {
    private final String catalog;
    private final String name;
    private final Map<String, MetaDataTable> tables = new HashMap<String, MetaDataTable>();
    private boolean populated = false;

    MetaDataSchema(String name, String catalog) {
        this.name = Objects.requireNonNull(name);
        this.catalog = catalog;
    }

    public String name() {
        return this.name;
    }

    public String catalog() {
        return this.catalog;
    }

    public Map<String, MetaDataTable> tables() {
        return Collections.unmodifiableMap(this.tables);
    }

    public void populate(DatabaseMetaData metaData, Map<String, MetaDataSchema> schemas, Consumer<String> schemaNotifier, Set<String> populatedSchemas) {
        if (!populatedSchemas.contains(this.name)) {
            schemaNotifier.accept(this.name);
            this.tables.clear();
            try (ResultSet resultSet = metaData.getTables(null, this.name, null, new String[]{"TABLE", "VIEW"});){
                this.tables.putAll(new MetaDataTable.TablePacker(this, metaData, null).pack(resultSet).stream().collect(Collectors.toMap(MetaDataTable::tableName, Function.identity())));
                this.tables.values().stream().flatMap(table -> table.referencedSchemaNames().stream()).map(schemas::get).forEach(schema -> schema.populate(metaData, schemas, schemaNotifier, populatedSchemas));
                this.tables.values().forEach(table -> table.resolveForeignKeys(schemas));
                this.populated = true;
                populatedSchemas.add(this.name);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean populated() {
        return this.populated;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetaDataSchema schema = (MetaDataSchema)object;
        return this.name.equals(schema.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

