/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.common.db.result.ResultPacker;
import is.codion.swing.framework.model.tools.metadata.MetaDataForeignKeyColumn;
import is.codion.swing.framework.model.tools.metadata.MetaDataPrimaryKeyColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class MetaDataColumn {
    private final String columnName;
    private final int dataType;
    private final String typeName;
    private final Class<?> columnClass;
    private final int position;
    private final int columnSize;
    private final int decimalDigits;
    private final int nullable;
    private final String defaultValue;
    private final String comment;
    private final int primaryKeyIndex;
    private final boolean foreignKeyColumn;
    private final boolean autoIncrement;
    private final boolean generated;

    MetaDataColumn(String columnName, int dataType, String typeName, Class<?> columnClass, int position, int columnSize, int decimalDigits, int nullable, String defaultValue, String comment, int primaryKeyIndex, boolean foreignKeyColumn, boolean autoIncrement, boolean generated) {
        this.columnName = Objects.requireNonNull(columnName);
        this.columnClass = Objects.requireNonNull(columnClass);
        this.dataType = dataType;
        this.typeName = typeName;
        this.position = position;
        this.columnSize = columnSize;
        this.decimalDigits = decimalDigits;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.comment = comment == null ? null : comment.trim().replace("\"", "\\\"");
        this.primaryKeyIndex = primaryKeyIndex;
        this.foreignKeyColumn = foreignKeyColumn;
        this.autoIncrement = autoIncrement;
        this.generated = generated;
    }

    public String columnName() {
        return this.columnName;
    }

    public int dataType() {
        return this.dataType;
    }

    public String typeName() {
        return this.typeName;
    }

    public int position() {
        return this.position;
    }

    public boolean primaryKeyColumn() {
        return this.primaryKeyIndex != -1;
    }

    public int primaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    public boolean foreignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public Class<?> columnClass() {
        return this.columnClass;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public int nullable() {
        return this.nullable;
    }

    public int columnSize() {
        return this.columnSize;
    }

    public int decimalDigits() {
        return this.decimalDigits;
    }

    public String comment() {
        return this.comment;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public boolean generated() {
        return this.generated;
    }

    public String toString() {
        return this.columnName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetaDataColumn column = (MetaDataColumn)object;
        return this.columnName.equals(column.columnName);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    static final class ColumnPacker
    implements ResultPacker<MetaDataColumn> {
        private static final String YES = "YES";
        private final Collection<MetaDataPrimaryKeyColumn> primaryKeyColumns;
        private final List<MetaDataForeignKeyColumn> foreignKeyColumns;

        ColumnPacker(Collection<MetaDataPrimaryKeyColumn> primaryKeyColumns, List<MetaDataForeignKeyColumn> foreignKeyColumns) {
            this.primaryKeyColumns = primaryKeyColumns;
            this.foreignKeyColumns = foreignKeyColumns;
        }

        public MetaDataColumn get(ResultSet resultSet) throws SQLException {
            int dataType = resultSet.getInt("DATA_TYPE");
            int decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
            if (resultSet.wasNull()) {
                decimalDigits = -1;
            }
            Class<?> columnClass = ColumnPacker.columnClass(dataType, decimalDigits);
            String columnName = resultSet.getString("COLUMN_NAME");
            String typeName = resultSet.getString("TYPE_NAME");
            try {
                return new MetaDataColumn(columnName, dataType, typeName, columnClass, resultSet.getInt("ORDINAL_POSITION"), resultSet.getInt("COLUMN_SIZE"), decimalDigits, resultSet.getInt("NULLABLE"), resultSet.getString("COLUMN_DEF"), resultSet.getString("REMARKS"), this.primaryKeyColumnIndex(columnName), this.foreignKeyColumn(columnName), YES.equals(resultSet.getString("IS_AUTOINCREMENT")), YES.equals(resultSet.getString("IS_GENERATEDCOLUMN")));
            }
            catch (SQLException e) {
                System.err.println("Exception fetching column: " + columnName + ", " + e.getMessage());
                throw e;
            }
        }

        private int primaryKeyColumnIndex(String columnName) {
            return this.primaryKeyColumns.stream().filter(primaryKeyColumn -> columnName.equals(primaryKeyColumn.columnName())).findFirst().map(MetaDataPrimaryKeyColumn::index).orElse(-1);
        }

        private boolean foreignKeyColumn(String columnName) {
            return this.foreignKeyColumns.stream().anyMatch(foreignKeyColumn -> foreignKeyColumn.fkColumnName().equals(columnName));
        }

        private static Class<?> columnClass(int sqlType, int decimalDigits) {
            switch (sqlType) {
                case -5: {
                    return Long.class;
                }
                case -8: 
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return Short.class;
                }
                case 1: {
                    return Character.class;
                }
                case 91: {
                    return LocalDate.class;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    return decimalDigits == 0 ? Integer.class : Double.class;
                }
                case 92: {
                    return LocalTime.class;
                }
                case 2013: {
                    return OffsetTime.class;
                }
                case 93: {
                    return LocalDateTime.class;
                }
                case 2014: {
                    return OffsetDateTime.class;
                }
                case -1: 
                case 12: {
                    return String.class;
                }
                case 2004: {
                    return byte[].class;
                }
                case -7: 
                case 16: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }
    }
}

