/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.loadtest;

import is.codion.framework.model.EntityTableModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class EntityLoadTestUtil {
    private static final Random RANDOM = new Random();

    private EntityLoadTestUtil() {
    }

    public static void selectRandomRow(EntityTableModel<?> tableModel) {
        if (tableModel.getRowCount() == 0) {
            return;
        }
        tableModel.selectionModel().setSelectedIndex(RANDOM.nextInt(tableModel.getRowCount()));
    }

    public static void selectRandomRows(EntityTableModel<?> tableModel, int count) {
        if (tableModel.getRowCount() == 0) {
            return;
        }
        if (tableModel.getRowCount() <= count) {
            tableModel.selectionModel().selectAll();
        } else {
            int startIdx = RANDOM.nextInt(tableModel.getRowCount() - count);
            tableModel.selectionModel().setSelectedIndexes((Collection)IntStream.range(startIdx, count + startIdx).boxed().collect(Collectors.toList()));
        }
    }

    public static void selectRandomRows(EntityTableModel<?> tableModel, double ratio) {
        EntityLoadTestUtil.selectRandomRows(tableModel, ratio > 0.0 ? (int)Math.floor((double)tableModel.getRowCount() * ratio) : 1);
    }

    public static void selectRandomItem(EntityComboBoxModel comboBoxModel) {
        List visibleItems;
        if (comboBoxModel.cleared()) {
            comboBoxModel.refresh();
        }
        if ((visibleItems = comboBoxModel.visibleItems()).isEmpty() || visibleItems.size() == 1 && visibleItems.get(0) == null) {
            return;
        }
        int fromIndex = visibleItems.get(0) == null ? 1 : 0;
        comboBoxModel.setSelectedItem(visibleItems.get(RANDOM.nextInt(visibleItems.size() - fromIndex) + fromIndex));
    }
}

