/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.common.db.exception.DatabaseException;
import is.codion.swing.framework.model.tools.metadata.MetaDataSchema;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class MetaDataModel {
    private final Map<String, MetaDataSchema> schemas;
    private final DatabaseMetaData metaData;

    public MetaDataModel(DatabaseMetaData metaData) throws DatabaseException {
        this.metaData = Objects.requireNonNull(metaData);
        try {
            this.schemas = MetaDataModel.discoverSchemas(metaData);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public Collection<MetaDataSchema> schemas() {
        return Collections.unmodifiableCollection(this.schemas.values());
    }

    public void populateSchema(String schemaName, Consumer<String> schemaNotifier) {
        MetaDataSchema schema = this.schemas.get(Objects.requireNonNull(schemaName));
        if (schema == null) {
            throw new IllegalArgumentException("Schema not found: " + schemaName);
        }
        schema.populate(this.metaData, this.schemas, schemaNotifier, new HashSet<String>());
    }

    private static Map<String, MetaDataSchema> discoverSchemas(DatabaseMetaData metaData) throws SQLException {
        HashMap<String, MetaDataSchema> schemas = new HashMap<String, MetaDataSchema>();
        try (ResultSet resultSet = metaData.getSchemas();){
            while (resultSet.next()) {
                String tableSchem = resultSet.getString("TABLE_SCHEM");
                if (tableSchem == null) continue;
                schemas.put(tableSchem, new MetaDataSchema(tableSchem, resultSet.getString("TABLE_CATALOG")));
            }
        }
        return schemas;
    }
}

