/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.swing.framework.model.tools.metadata.ForeignKeyColumn;
import is.codion.swing.framework.model.tools.metadata.ForeignKeyConstraint;
import is.codion.swing.framework.model.tools.metadata.MetadataColumn;
import is.codion.swing.framework.model.tools.metadata.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Table {
    private final Schema schema;
    private final String tableName;
    private final String comment;
    private final List<ForeignKeyColumn> foreignKeyColumns;
    private final Map<String, MetadataColumn> columns = new LinkedHashMap<String, MetadataColumn>();
    private final List<ForeignKeyConstraint> foreignKeys = new ArrayList<ForeignKeyConstraint>();

    Table(Schema schema, String tableName, String comment, List<MetadataColumn> columns, List<ForeignKeyColumn> foreignKeyColumns) {
        this.schema = Objects.requireNonNull(schema);
        this.tableName = Objects.requireNonNull(tableName);
        this.comment = comment;
        this.foreignKeyColumns = Objects.requireNonNull(foreignKeyColumns);
        Objects.requireNonNull(columns).forEach(column -> this.columns.put(column.columnName(), (MetadataColumn)column));
    }

    public String tableName() {
        return this.tableName;
    }

    public Schema schema() {
        return this.schema;
    }

    public String comment() {
        return this.comment;
    }

    public List<MetadataColumn> columns() {
        return Collections.unmodifiableList(new ArrayList<MetadataColumn>(this.columns.values()));
    }

    public Collection<String> referencedSchemaNames() {
        return this.foreignKeyColumns.stream().filter(this::referencesExternalSchema).map(ForeignKeyColumn::pkSchemaName).collect(Collectors.toSet());
    }

    public Collection<ForeignKeyConstraint> foreignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys);
    }

    public String toString() {
        return this.schema.name() + "." + this.tableName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Table table = (Table)object;
        return Objects.equals(this.schema, table.schema()) && Objects.equals(this.tableName, table.tableName());
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.tableName);
    }

    void resolveForeignKeys(Map<String, Schema> schemas) {
        for (ForeignKeyColumn foreignKeyColumn : this.foreignKeyColumns) {
            ForeignKeyConstraint foreignKeyConstraint;
            Table referencedTable = Table.referencedTable(foreignKeyColumn, schemas);
            if (foreignKeyColumn.keySeq() == 1) {
                foreignKeyConstraint = new ForeignKeyConstraint(referencedTable);
                this.foreignKeys.add(foreignKeyConstraint);
            } else {
                foreignKeyConstraint = this.foreignKeys.get(this.foreignKeys.size() - 1);
            }
            foreignKeyConstraint.addReference(this.columns.get(foreignKeyColumn.fkColumnName()), referencedTable.columns.get(foreignKeyColumn.pkColumnName()));
        }
    }

    private boolean referencesExternalSchema(ForeignKeyColumn foreignKeyColumn) {
        return !foreignKeyColumn.pkSchemaName().equals(this.schema.name());
    }

    private static Table referencedTable(ForeignKeyColumn foreignKeyColumn, Map<String, Schema> schemas) {
        Table referencedTable = schemas.get(foreignKeyColumn.pkSchemaName()).tables().get(foreignKeyColumn.pkTableName());
        if (referencedTable == null) {
            throw new IllegalStateException("Referenced table not found: " + foreignKeyColumn.pkSchemaName() + "." + foreignKeyColumn.pkTableName());
        }
        return referencedTable;
    }
}

