/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.explorer;

import is.codion.common.Separators;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.framework.model.tools.explorer.DatabaseDomain;
import is.codion.swing.framework.model.tools.explorer.DefinitionRow;
import is.codion.swing.framework.model.tools.explorer.DomainToString;
import is.codion.swing.framework.model.tools.metadata.MetaDataModel;
import is.codion.swing.framework.model.tools.metadata.Schema;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.SortOrder;

public final class DatabaseExplorerModel {
    private final MetaDataModel metaDataModel;
    private final FilteredTableModel<Schema, Integer> schemaTableModel;
    private final FilteredTableModel<DefinitionRow, Integer> definitionTableModel;
    private final Connection connection;
    private final Value<String> domainSourceValue = Value.value();

    private DatabaseExplorerModel(Database database, User user) throws DatabaseException {
        this.connection = Objects.requireNonNull(database, "database").createConnection(user);
        try {
            this.metaDataModel = new MetaDataModel(this.connection.getMetaData());
            this.schemaTableModel = FilteredTableModel.builder((FilteredTableModel.ColumnFactory)new SchemaColumnFactory(), (FilteredTableModel.ColumnValueProvider)new SchemaColumnValueProvider()).itemSupplier(this.metaDataModel::schemas).build();
            this.schemaTableModel.sortModel().setSortOrder((Object)0, SortOrder.ASCENDING);
            this.definitionTableModel = FilteredTableModel.builder((FilteredTableModel.ColumnFactory)new DefinitionColumnFactory(), (FilteredTableModel.ColumnValueProvider)new DefinitionColumnValueProvider()).itemSupplier((Supplier)new DefinitionItemSupplier()).build();
            this.schemaTableModel.refresh();
            this.bindEvents();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public FilteredTableModel<Schema, Integer> schemaModel() {
        return this.schemaTableModel;
    }

    public FilteredTableModel<DefinitionRow, Integer> definitionModel() {
        return this.definitionTableModel;
    }

    public ValueObserver<String> domainSourceObserver() {
        return this.domainSourceValue.observer();
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bindEvents() {
        this.schemaTableModel.selectionModel().addSelectionListener(() -> this.definitionTableModel.refresh());
        this.definitionTableModel.selectionModel().addSelectionListener(this::updateCodeValue);
    }

    public void populateSelected(Consumer<String> schemaNotifier) {
        this.schemaTableModel.selectionModel().getSelectedItems().forEach(schema -> this.metaDataModel.populateSchema(schema.name(), schemaNotifier));
        this.definitionTableModel.refresh();
    }

    public static DatabaseExplorerModel databaseExplorerModel(Database database, User user) throws DatabaseException {
        return new DatabaseExplorerModel(database, user);
    }

    private void updateCodeValue() {
        this.domainSourceValue.set((Object)this.definitionTableModel.selectionModel().getSelectedItems().stream().map(definitionRow -> DomainToString.toString(definitionRow.definition)).collect(Collectors.joining(Separators.LINE_SEPARATOR + Separators.LINE_SEPARATOR)));
    }

    private static Collection<DefinitionRow> createDomainDefinitions(Schema schema) {
        DatabaseDomain domain = new DatabaseDomain(DomainType.domainType((String)schema.name()), schema.tables().values());
        return domain.entities().definitions().stream().map(definition -> new DefinitionRow(domain, (EntityDefinition)definition)).collect(Collectors.toList());
    }

    static {
        EntityDefinition.STRICT_FOREIGN_KEYS.set((Object)false);
    }

    private static final class SchemaColumnFactory
    implements FilteredTableModel.ColumnFactory<Integer> {
        private SchemaColumnFactory() {
        }

        public List<FilteredTableColumn<Integer>> createColumns() {
            FilteredTableColumn schemaColumn = FilteredTableColumn.builder((int)0).headerValue((Object)"Schema").columnClass(String.class).build();
            FilteredTableColumn populatedColumn = FilteredTableColumn.builder((int)1).headerValue((Object)"Populated").columnClass(Boolean.class).build();
            return Arrays.asList(schemaColumn, populatedColumn);
        }
    }

    private static final class SchemaColumnValueProvider
    implements FilteredTableModel.ColumnValueProvider<Schema, Integer> {
        private static final int SCHEMA = 0;
        private static final int POPULATED = 1;

        private SchemaColumnValueProvider() {
        }

        public Object value(Schema row, Integer columnIdentifier) {
            switch (columnIdentifier) {
                case 0: {
                    return row.name();
                }
                case 1: {
                    return row.populated();
                }
            }
            throw new IllegalArgumentException("Unknown column: " + columnIdentifier);
        }
    }

    private static final class DefinitionColumnFactory
    implements FilteredTableModel.ColumnFactory<Integer> {
        private DefinitionColumnFactory() {
        }

        public List<FilteredTableColumn<Integer>> createColumns() {
            FilteredTableColumn domainColumn = FilteredTableColumn.builder((int)0).headerValue((Object)"Domain").columnClass(String.class).build();
            FilteredTableColumn entityTypeColumn = FilteredTableColumn.builder((int)1).headerValue((Object)"Entity").columnClass(String.class).build();
            return Arrays.asList(domainColumn, entityTypeColumn);
        }
    }

    private static final class DefinitionColumnValueProvider
    implements FilteredTableModel.ColumnValueProvider<DefinitionRow, Integer> {
        private static final int DOMAIN = 0;
        private static final int ENTITY = 1;

        private DefinitionColumnValueProvider() {
        }

        public Object value(DefinitionRow row, Integer columnIdentifier) {
            switch (columnIdentifier) {
                case 0: {
                    return row.domain.type().name();
                }
                case 1: {
                    return row.definition.entityType().name();
                }
            }
            throw new IllegalArgumentException("Unknown column: " + columnIdentifier);
        }
    }

    private final class DefinitionItemSupplier
    implements Supplier<Collection<DefinitionRow>> {
        private DefinitionItemSupplier() {
        }

        @Override
        public Collection<DefinitionRow> get() {
            ArrayList<DefinitionRow> items = new ArrayList<DefinitionRow>();
            DatabaseExplorerModel.this.schemaTableModel.selectionModel().getSelectedItems().forEach(schema -> items.addAll(DatabaseExplorerModel.createDomainDefinitions(schema)));
            return items;
        }
    }
}

