/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.explorer;

import is.codion.common.NullOrEmpty;
import is.codion.framework.domain.DefaultDomain;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.KeyGenerator;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.swing.framework.model.tools.metadata.ForeignKeyConstraint;
import is.codion.swing.framework.model.tools.metadata.MetadataColumn;
import is.codion.swing.framework.model.tools.metadata.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class DatabaseDomain
extends DefaultDomain {
    private static final int MAXIMUM_COLUMN_SIZE = Integer.MAX_VALUE;
    private final Map<Table, EntityType> tableEntityTypes = new HashMap<Table, EntityType>();

    DatabaseDomain(DomainType domainType, Collection<Table> tables) {
        super(domainType);
        tables.forEach(this::defineEntity);
    }

    private void defineEntity(Table table) {
        if (!this.tableEntityTypes.containsKey(table)) {
            EntityType entityType = this.type().entityType(table.schema().name() + "." + table.tableName());
            this.tableEntityTypes.put(table, entityType);
            table.foreignKeys().stream().map(ForeignKeyConstraint::referencedTable).filter(referencedTable -> !referencedTable.equals(table)).forEach(this::defineEntity);
            this.define(table, entityType);
        }
    }

    private void define(Table table, EntityType entityType) {
        List<AttributeDefinition.Builder<?, ?>> definitionBuilders = this.definitionBuilders(table, entityType, new ArrayList<ForeignKeyConstraint>(table.foreignKeys()));
        if (!definitionBuilders.isEmpty()) {
            EntityDefinition.Builder definitionBuilder = entityType.define(definitionBuilders.toArray(new AttributeDefinition.Builder[0]));
            if (DatabaseDomain.tableHasAutoIncrementPrimaryKeyColumn(table)) {
                definitionBuilder.keyGenerator(KeyGenerator.identity());
            }
            if (!NullOrEmpty.nullOrEmpty((String)table.comment())) {
                definitionBuilder.description(table.comment());
            }
            this.add(definitionBuilder);
        }
    }

    private List<AttributeDefinition.Builder<?, ?>> definitionBuilders(Table table, EntityType entityType, Collection<ForeignKeyConstraint> foreignKeyConstraints) {
        ArrayList builders = new ArrayList();
        table.columns().forEach(column -> {
            builders.add((AttributeDefinition.Builder<?, ?>)DatabaseDomain.columnDefinitionBuilder(column, entityType));
            if (column.foreignKeyColumn()) {
                foreignKeyConstraints.stream().filter(foreignKeyConstraint -> DatabaseDomain.lastKeyColumn(foreignKeyConstraint, column)).findFirst().ifPresent(foreignKeyConstraint -> {
                    foreignKeyConstraints.remove(foreignKeyConstraint);
                    builders.add(this.foreignKeyDefinitionBuilder((ForeignKeyConstraint)foreignKeyConstraint, entityType));
                });
            }
        });
        return builders;
    }

    private AttributeDefinition.Builder<?, ?> foreignKeyDefinitionBuilder(ForeignKeyConstraint foreignKeyConstraint, EntityType entityType) {
        Table referencedTable = foreignKeyConstraint.referencedTable();
        EntityType referencedEntityType = this.tableEntityTypes.get(referencedTable);
        ForeignKey foreignKey = entityType.foreignKey(DatabaseDomain.createForeignKeyName(foreignKeyConstraint) + "_FK", foreignKeyConstraint.references().entrySet().stream().map(entry -> ForeignKey.reference(DatabaseDomain.column(entityType, (MetadataColumn)entry.getKey()), DatabaseDomain.column(referencedEntityType, (MetadataColumn)entry.getValue()))).collect(Collectors.toList()));
        return foreignKey.define().foreignKey().caption(DatabaseDomain.caption(referencedTable.tableName().toLowerCase()));
    }

    private static ColumnDefinition.Builder<?, ?> columnDefinitionBuilder(MetadataColumn metadataColumn, EntityType entityType) {
        String caption = DatabaseDomain.caption(metadataColumn.columnName());
        Column column = DatabaseDomain.column(entityType, metadataColumn);
        ColumnDefinition.Builder builder = metadataColumn.primaryKeyColumn() ? column.define().primaryKey(metadataColumn.primaryKeyIndex() - 1) : (ColumnDefinition.Builder)column.define().column().caption(caption);
        if (!metadataColumn.primaryKeyColumn() && metadataColumn.nullable() == 0) {
            builder.nullable(false);
        }
        if (column.type().isString() && metadataColumn.columnSize() > 0 && metadataColumn.columnSize() < Integer.MAX_VALUE) {
            builder.maximumLength(metadataColumn.columnSize());
        }
        if (column.type().isDecimal() && metadataColumn.decimalDigits() >= 1) {
            builder.maximumFractionDigits(metadataColumn.decimalDigits());
        }
        if (!metadataColumn.primaryKeyColumn() && metadataColumn.defaultValue() != null) {
            builder.columnHasDefaultValue(true);
        }
        if (!NullOrEmpty.nullOrEmpty((String)metadataColumn.comment())) {
            builder.description(metadataColumn.comment());
        }
        return builder;
    }

    private static <T> Column<T> column(EntityType entityType, MetadataColumn column) {
        return entityType.column(column.columnName(), column.columnClass());
    }

    private static String caption(String name) {
        String caption = name.toLowerCase().replace("_", " ");
        return caption.substring(0, 1).toUpperCase() + caption.substring(1);
    }

    private static boolean lastKeyColumn(ForeignKeyConstraint foreignKeyConstraint, MetadataColumn column) {
        return foreignKeyConstraint.references().keySet().stream().mapToInt(MetadataColumn::position).max().orElse(-1) == column.position();
    }

    private static String createForeignKeyName(ForeignKeyConstraint foreignKeyConstraint) {
        return foreignKeyConstraint.references().keySet().stream().map(MetadataColumn::columnName).map(String::toUpperCase).collect(Collectors.joining("_"));
    }

    private static boolean tableHasAutoIncrementPrimaryKeyColumn(Table table) {
        return table.columns().stream().filter(MetadataColumn::primaryKeyColumn).anyMatch(MetadataColumn::autoIncrement);
    }
}

