/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.loadtest;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.model.EntityTableModel;
import is.codion.swing.common.model.tools.loadtest.LoadTestModel;
import is.codion.swing.common.model.tools.loadtest.UsageScenario;
import is.codion.swing.framework.model.SwingEntityApplicationModel;
import is.codion.swing.framework.model.component.EntityComboBoxModel;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class EntityLoadTestModel<M extends SwingEntityApplicationModel> {
    private static final int DEFAULT_LOAD_TEST_THINKTIME = 2000;
    private static final int DEFAULT_LOAD_TEST_BATCH_SIZE = 10;
    private static final int DEFAULT_LOAD_TEST_LOGIN_DELAY = 2;
    public static final PropertyValue<String> LOAD_TEST_REMOTE_HOSTNAME = Configuration.stringValue((String)"codion.loadtest.remote.hostname", (String)"localhost");
    public static final PropertyValue<Integer> LOAD_TEST_THINKTIME = Configuration.integerValue((String)"codion.loadtest.thinktime", (int)2000);
    public static final PropertyValue<Integer> LOAD_TEST_BATCH_SIZE = Configuration.integerValue((String)"codion.loadtest.batchsize", (int)10);
    public static final PropertyValue<Integer> LOAD_TEST_LOGIN_DELAY = Configuration.integerValue((String)"codion.loadtest.logindelay", (int)2);
    private static final Random RANDOM = new Random();
    private final LoadTestModel<M> loadTestModel;

    protected EntityLoadTestModel(User user, Collection<? extends UsageScenario<M>> usageScenarios) {
        this.loadTestModel = LoadTestModel.builder(this::createApplication, this::closeApplication).usageScenarios(usageScenarios).user(user).minimumThinkTime((Integer)LOAD_TEST_THINKTIME.get() / 2).maximumThinkTime(((Integer)LOAD_TEST_THINKTIME.get()).intValue()).loginDelayFactor(((Integer)LOAD_TEST_LOGIN_DELAY.get()).intValue()).applicationBatchSize(((Integer)LOAD_TEST_BATCH_SIZE.get()).intValue()).titleFactory(loadTest -> this.getClass().getSimpleName() + " - " + (String)EntityConnectionProvider.CLIENT_CONNECTION_TYPE.get()).build();
    }

    public final LoadTestModel<M> loadTestModel() {
        return this.loadTestModel;
    }

    public static void selectRandomRow(EntityTableModel<?> tableModel) {
        if (tableModel.getRowCount() == 0) {
            return;
        }
        tableModel.selectionModel().setSelectedIndex(RANDOM.nextInt(tableModel.getRowCount()));
    }

    public static void selectRandomRows(EntityTableModel<?> tableModel, int count) {
        if (tableModel.getRowCount() == 0) {
            return;
        }
        if (tableModel.getRowCount() <= count) {
            tableModel.selectionModel().selectAll();
        } else {
            int startIdx = RANDOM.nextInt(tableModel.getRowCount() - count);
            tableModel.selectionModel().setSelectedIndexes((Collection)IntStream.range(startIdx, count + startIdx).boxed().collect(Collectors.toList()));
        }
    }

    public static void selectRandomRows(EntityTableModel<?> tableModel, double ratio) {
        EntityLoadTestModel.selectRandomRows(tableModel, ratio > 0.0 ? (int)Math.floor((double)tableModel.getRowCount() * ratio) : 1);
    }

    public static void selectRandomItem(EntityComboBoxModel comboBoxModel) {
        List visibleItems;
        if (comboBoxModel.cleared()) {
            comboBoxModel.refresh();
        }
        if ((visibleItems = comboBoxModel.visibleItems()).isEmpty() || visibleItems.size() == 1 && visibleItems.get(0) == null) {
            return;
        }
        int fromIndex = visibleItems.get(0) == null ? 1 : 0;
        comboBoxModel.setSelectedItem(visibleItems.get(RANDOM.nextInt(visibleItems.size() - fromIndex) + fromIndex));
    }

    protected abstract M createApplication(User var1);

    private void closeApplication(M application) {
        application.connectionProvider().close();
    }
}

