/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.common.db.result.ResultPacker;
import is.codion.swing.framework.model.tools.metadata.ForeignKeyColumn;
import is.codion.swing.framework.model.tools.metadata.MetadataColumn;
import is.codion.swing.framework.model.tools.metadata.PrimaryKeyColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Collection;
import java.util.List;

final class ColumnPacker
implements ResultPacker<MetadataColumn> {
    private static final String YES = "YES";
    private final Collection<PrimaryKeyColumn> primaryKeyColumns;
    private final List<ForeignKeyColumn> foreignKeyColumns;

    ColumnPacker(Collection<PrimaryKeyColumn> primaryKeyColumns, List<ForeignKeyColumn> foreignKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
        this.foreignKeyColumns = foreignKeyColumns;
    }

    public MetadataColumn get(ResultSet resultSet) throws SQLException {
        Class<?> columnClass;
        int dataType = resultSet.getInt("DATA_TYPE");
        int decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
        if (resultSet.wasNull()) {
            decimalDigits = -1;
        }
        if ((columnClass = ColumnPacker.columnClass(dataType, decimalDigits)) != null) {
            String columnName = resultSet.getString("COLUMN_NAME");
            try {
                return new MetadataColumn(columnName, columnClass, resultSet.getInt("ORDINAL_POSITION"), resultSet.getInt("COLUMN_SIZE"), decimalDigits, resultSet.getInt("NULLABLE"), resultSet.getString("COLUMN_DEF"), resultSet.getString("REMARKS"), this.primaryKeyColumnIndex(columnName), this.foreignKeyColumn(columnName), YES.equals(resultSet.getString("IS_AUTOINCREMENT")), YES.equals(resultSet.getString("IS_GENERATEDCOLUMN")));
            }
            catch (SQLException e) {
                System.err.println("Exception fetching column: " + columnName + ", " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    private int primaryKeyColumnIndex(String columnName) {
        return this.primaryKeyColumns.stream().filter(primaryKeyColumn -> columnName.equals(primaryKeyColumn.columnName())).findFirst().map(PrimaryKeyColumn::index).orElse(-1);
    }

    private boolean foreignKeyColumn(String columnName) {
        return this.foreignKeyColumns.stream().anyMatch(foreignKeyColumn -> foreignKeyColumn.fkColumnName().equals(columnName));
    }

    private static Class<?> columnClass(int sqlType, int decimalDigits) {
        switch (sqlType) {
            case -5: {
                return Long.class;
            }
            case -8: 
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Short.class;
            }
            case 1: {
                return Character.class;
            }
            case 91: {
                return LocalDate.class;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return decimalDigits == 0 ? Integer.class : Double.class;
            }
            case 92: {
                return LocalTime.class;
            }
            case 2013: {
                return OffsetTime.class;
            }
            case 93: {
                return LocalDateTime.class;
            }
            case 2014: {
                return OffsetDateTime.class;
            }
            case -1: 
            case 12: {
                return String.class;
            }
            case 2004: {
                return byte[].class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
        }
        return null;
    }
}

