/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.common.db.result.ResultPacker;
import is.codion.swing.framework.model.tools.metadata.ColumnPacker;
import is.codion.swing.framework.model.tools.metadata.ForeignKeyColumn;
import is.codion.swing.framework.model.tools.metadata.ForeignKeyColumnPacker;
import is.codion.swing.framework.model.tools.metadata.MetadataColumn;
import is.codion.swing.framework.model.tools.metadata.PrimaryKeyColumn;
import is.codion.swing.framework.model.tools.metadata.PrimaryKeyColumnPacker;
import is.codion.swing.framework.model.tools.metadata.Schema;
import is.codion.swing.framework.model.tools.metadata.Table;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

final class TablePacker
implements ResultPacker<Table> {
    private final Schema schema;
    private final DatabaseMetaData metaData;
    private final String catalog;

    TablePacker(Schema schema, DatabaseMetaData metaData, String catalog) {
        this.schema = schema;
        this.metaData = metaData;
        this.catalog = catalog;
    }

    public Table get(ResultSet resultSet) throws SQLException {
        String tableName = resultSet.getString("TABLE_NAME");
        String remarks = resultSet.getString("REMARKS");
        List<PrimaryKeyColumn> primaryKeyColumns = TablePacker.primaryKeyColumns(this.schema, this.metaData, this.catalog, tableName);
        List<ForeignKeyColumn> foreignKeyColumns = TablePacker.foreignKeyColumns(this.schema, this.metaData, this.catalog, tableName);
        List<MetadataColumn> columns = TablePacker.columns(this.schema, this.metaData, this.catalog, tableName, primaryKeyColumns, foreignKeyColumns);
        return new Table(this.schema, tableName, remarks, columns, foreignKeyColumns);
    }

    private static List<PrimaryKeyColumn> primaryKeyColumns(Schema schema, DatabaseMetaData metaData, String catalog, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getPrimaryKeys(catalog, schema.name(), tableName);){
            List list = new PrimaryKeyColumnPacker().pack(resultSet);
            return list;
        }
    }

    private static List<ForeignKeyColumn> foreignKeyColumns(Schema schema, DatabaseMetaData metaData, String catalog, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getImportedKeys(catalog, schema.name(), tableName);){
            List list = new ForeignKeyColumnPacker().pack(resultSet);
            return list;
        }
    }

    private static List<MetadataColumn> columns(Schema schema, DatabaseMetaData metaData, String catalog, String tableName, List<PrimaryKeyColumn> primaryKeyColumns, List<ForeignKeyColumn> foreignKeyColumns) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(catalog, schema.name(), tableName, null);){
            List list = new ColumnPacker(primaryKeyColumns, foreignKeyColumns).pack(resultSet);
            return list;
        }
    }
}

