/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.metadata;

import is.codion.swing.framework.model.tools.metadata.Table;
import is.codion.swing.framework.model.tools.metadata.TablePacker;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Schema {
    private final String name;
    private final Map<String, Table> tables = new HashMap<String, Table>();
    private boolean populated = false;

    Schema(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String name() {
        return this.name;
    }

    public Map<String, Table> tables() {
        return Collections.unmodifiableMap(this.tables);
    }

    public void populate(DatabaseMetaData metaData, Map<String, Schema> schemas, Consumer<String> schemaNotifier) {
        if (!this.populated) {
            schemaNotifier.accept(this.name);
            try (ResultSet resultSet = metaData.getTables(null, this.name, null, new String[]{"TABLE", "VIEW"});){
                this.tables.putAll(new TablePacker(this, metaData, null).pack(resultSet).stream().collect(Collectors.toMap(Table::tableName, Function.identity())));
                this.tables.values().stream().flatMap(table -> table.referencedSchemaNames().stream()).map(schemas::get).forEach(schema -> schema.populate(metaData, schemas, schemaNotifier));
                this.tables.values().forEach(table -> table.resolveForeignKeys(schemas));
                this.populated = true;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean populated() {
        return this.populated;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Schema schema = (Schema)object;
        return this.name.equals(schema.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

