/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.framework.model.tools.explorer;

import is.codion.common.NullOrEmpty;
import is.codion.common.Separators;
import is.codion.common.Text;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.BlobColumnDefinition;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class DomainToString {
    private static final String INDENT = "\t";
    private static final String DOUBLE_INDENT = "\t\t";
    private static final String TRIPLE_INDENT = "\t\t\t";

    private DomainToString() {
    }

    static String toString(EntityDefinition definition) {
        StringBuilder builder = new StringBuilder();
        String interfaceName = DomainToString.interfaceName(definition.tableName(), true);
        builder.append("public interface ").append(interfaceName).append(" {").append(Separators.LINE_SEPARATOR);
        builder.append(INDENT).append("EntityType TYPE = ").append("DOMAIN.entityType(\"").append(definition.tableName().toLowerCase()).append("\");").append(Separators.LINE_SEPARATOR).append(Separators.LINE_SEPARATOR);
        List<AttributeDefinition> columnDefinitions = definition.attributes().definitions().stream().filter(ColumnDefinition.class::isInstance).collect(Collectors.toList());
        columnDefinitions.forEach(columnDefinition -> DomainToString.appendAttribute(builder, columnDefinition));
        List<AttributeDefinition> foreignKeyDefinitions = definition.attributes().definitions().stream().filter(ForeignKeyDefinition.class::isInstance).collect(Collectors.toList());
        if (!foreignKeyDefinitions.isEmpty()) {
            builder.append(Separators.LINE_SEPARATOR);
            foreignKeyDefinitions.forEach(foreignKeyDefinition -> DomainToString.appendAttribute(builder, foreignKeyDefinition));
        }
        builder.append("}").append(Separators.LINE_SEPARATOR).append(Separators.LINE_SEPARATOR);
        builder.append("void ").append(DomainToString.interfaceName(definition.tableName(), false)).append("() {").append(Separators.LINE_SEPARATOR);
        builder.append(INDENT).append("add(").append(interfaceName).append(".TYPE.define(").append(Separators.LINE_SEPARATOR);
        builder.append(String.join((CharSequence)("," + Separators.LINE_SEPARATOR), DomainToString.attributeStrings(definition.attributes().definitions(), interfaceName, definition))).append(")");
        if (definition.description() != null) {
            builder.append(Separators.LINE_SEPARATOR).append(DOUBLE_INDENT).append(".description(\"").append(definition.description()).append("\")");
        }
        builder.append(");");
        builder.append(Separators.LINE_SEPARATOR);
        builder.append("}");
        return builder.toString();
    }

    private static void appendAttribute(StringBuilder builder, AttributeDefinition<?> attributeDefinition) {
        if (attributeDefinition instanceof ColumnDefinition) {
            ColumnDefinition columnDefinition = (ColumnDefinition)attributeDefinition;
            String valueClassName = columnDefinition.attribute().type().valueClass().getSimpleName();
            builder.append(INDENT).append("Column<").append(valueClassName).append("> ").append(columnDefinition.name().toUpperCase()).append(" = TYPE.").append(DomainToString.attributeTypePrefix(valueClassName)).append("Column(\"").append(columnDefinition.name().toLowerCase()).append("\");").append(Separators.LINE_SEPARATOR);
        } else if (attributeDefinition instanceof ForeignKeyDefinition) {
            ForeignKeyDefinition foreignKeyDefinition = (ForeignKeyDefinition)attributeDefinition;
            ArrayList references = new ArrayList();
            foreignKeyDefinition.references().forEach(reference -> {
                StringBuilder referenceBuilder = new StringBuilder();
                referenceBuilder.append(reference.column().name().toUpperCase()).append(", ").append(DomainToString.interfaceName(reference.foreign().entityType().name(), true)).append(".").append(reference.foreign().name().toUpperCase());
                references.add(referenceBuilder.toString());
            });
            builder.append(INDENT).append("ForeignKey ").append(attributeDefinition.attribute().name().toUpperCase()).append(" = TYPE.foreignKey(\"").append(attributeDefinition.attribute().name().toLowerCase()).append("\", " + String.join((CharSequence)("," + Separators.LINE_SEPARATOR), references) + ");").append(Separators.LINE_SEPARATOR);
        }
    }

    private static List<String> attributeStrings(List<AttributeDefinition<?>> attributeDefinitions, String interfaceName, EntityDefinition definition) {
        ArrayList<String> strings = new ArrayList<String>();
        attributeDefinitions.forEach(attributeDefinition -> {
            if (attributeDefinition instanceof ColumnDefinition) {
                ColumnDefinition columnDefinition = (ColumnDefinition)attributeDefinition;
                strings.add(DomainToString.columnDefinition(interfaceName, columnDefinition, definition.foreignKeys().foreignKeyColumn(columnDefinition.attribute()), definition.primaryKey().columns().size() > 1));
            } else if (attributeDefinition instanceof ForeignKeyDefinition) {
                strings.add(DomainToString.foreignKeyDefinition(interfaceName, (ForeignKeyDefinition)attributeDefinition));
            }
        });
        return strings;
    }

    private static String foreignKeyDefinition(String interfaceName, ForeignKeyDefinition definition) {
        StringBuilder builder = new StringBuilder();
        String foreignKey = definition.attribute().name().toUpperCase();
        builder.append(DOUBLE_INDENT).append(interfaceName).append(".").append(foreignKey).append(".define()").append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".foreignKey()").append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".caption(\"").append(definition.caption()).append("\")");
        return builder.toString();
    }

    private static String columnDefinition(String interfaceName, ColumnDefinition<?> column, boolean isForeignKey, boolean compositePrimaryKey) {
        StringBuilder builder = new StringBuilder(DOUBLE_INDENT).append(interfaceName).append(".").append(column.name().toUpperCase()).append(".define()").append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".").append(DomainToString.definitionType(column, compositePrimaryKey));
        if (!isForeignKey && !column.primaryKey()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".caption(").append("\"").append(column.caption()).append("\")");
        }
        if (column instanceof BlobColumnDefinition && ((BlobColumnDefinition)column).eagerlyLoaded()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".eagerlyLoaded()");
        }
        if (column.columnHasDefaultValue()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".columnHasDefaultValue(true)");
        }
        if (!column.nullable() && !column.primaryKey()) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".nullable(false)");
        }
        if (String.class.equals((Object)column.attribute().type().valueClass())) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".maximumLength(").append(column.maximumLength()).append(")");
        }
        if (Double.class.equals((Object)column.attribute().type().valueClass()) && column.maximumFractionDigits() >= 1) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".maximumFractionDigits(").append(column.maximumFractionDigits()).append(")");
        }
        if (!NullOrEmpty.nullOrEmpty((String)column.description())) {
            builder.append(Separators.LINE_SEPARATOR).append(TRIPLE_INDENT).append(".description(").append("\"").append(column.description()).append("\")");
        }
        return builder.toString();
    }

    private static String attributeTypePrefix(String valueClassName) {
        if ("byte[]".equals(valueClassName)) {
            return "byteArray";
        }
        return valueClassName.substring(0, 1).toLowerCase() + valueClassName.substring(1);
    }

    private static String definitionType(ColumnDefinition<?> column, boolean compositePrimaryKey) {
        if (column.attribute().type().isByteArray()) {
            return "blobColumn()";
        }
        if (column.primaryKey()) {
            return compositePrimaryKey ? "primaryKey(" + column.primaryKeyIndex() + ")" : "primaryKey()";
        }
        return "column()";
    }

    private static String interfaceName(String tableName, boolean uppercase) {
        Object name = tableName.toLowerCase();
        if (((String)name).contains(".")) {
            name = ((String)name).substring(((String)name).lastIndexOf(46) + 1);
        }
        name = Text.underscoreToCamelCase((String)name);
        if (uppercase) {
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        }
        return name;
    }
}

