/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.model.worker.ProgressWorker;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultExceptionDialogBuilder;
import is.codion.swing.common.ui.dialog.ExceptionDialogBuilder;
import is.codion.swing.common.ui.dialog.ProgressDialog;
import is.codion.swing.common.ui.dialog.ProgressWorkerDialogBuilder;
import java.awt.Dimension;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class DefaultProgressWorkerDialogBuilder<T, V>
extends AbstractDialogBuilder<ProgressWorkerDialogBuilder<T, V>>
implements ProgressWorkerDialogBuilder<T, V> {
    private final ProgressWorker.Builder<T, V> progressWorkerBuilder;
    private final ProgressDialog.Builder progressDialogBuilder;
    private Consumer<T> onResult;
    private Consumer<Exception> onException;

    DefaultProgressWorkerDialogBuilder(ProgressWorker.ResultTask<V> task) {
        this.progressWorkerBuilder = ProgressWorker.builder(task);
        this.progressDialogBuilder = new ProgressDialog.DefaultBuilder();
    }

    DefaultProgressWorkerDialogBuilder(ProgressWorker.ProgressResultTask<T, V> progressTask) {
        this.progressWorkerBuilder = ProgressWorker.builder(progressTask);
        this.progressDialogBuilder = new ProgressDialog.DefaultBuilder();
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> indeterminate(boolean indeterminate) {
        this.progressDialogBuilder.indeterminate(indeterminate);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> maximumProgress(int maximumProgress) {
        this.progressDialogBuilder.maximumProgress(maximumProgress);
        this.progressWorkerBuilder.maximumProgress(maximumProgress);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> stringPainted(boolean stringPainted) {
        this.progressDialogBuilder.stringPainted(stringPainted);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> border(Border border) {
        this.progressDialogBuilder.border(border);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> northPanel(JPanel northPanel) {
        this.progressDialogBuilder.northPanel(northPanel);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> westPanel(JPanel westPanel) {
        this.progressDialogBuilder.westPanel(westPanel);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> eastPanel(JPanel eastPanel) {
        this.progressDialogBuilder.eastPanel(eastPanel);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> control(Control.Builder<?, ?> controlBuilder) {
        this.progressDialogBuilder.control(controlBuilder);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> control(Control control) {
        this.progressDialogBuilder.control(control);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> progressBarSize(Dimension progressBarSize) {
        this.progressDialogBuilder.progressBarSize(progressBarSize);
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> onResult(Runnable onResult) {
        return this.onResult((T result) -> onResult.run());
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> onResult(Consumer<T> onResult) {
        this.onResult = onResult;
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> onResult(String resultMessage) {
        Objects.requireNonNull(resultMessage);
        return this.onResult((T result) -> JOptionPane.showMessageDialog(this.owner, resultMessage, null, 1));
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> onException(Consumer<Exception> onException) {
        this.onException = onException;
        return this;
    }

    @Override
    public ProgressWorkerDialogBuilder<T, V> onException(String exceptionTitle) {
        return this.onException((Exception exception) -> {
            if (!(exception instanceof CancelException)) {
                ((ExceptionDialogBuilder)((ExceptionDialogBuilder)new DefaultExceptionDialogBuilder().owner(this.owner)).title(exceptionTitle)).show((Throwable)exception);
            }
        });
    }

    @Override
    public ProgressWorker<T, V> execute() {
        ProgressWorker<T, V> worker = this.build();
        worker.execute();
        return worker;
    }

    @Override
    public ProgressWorker<T, V> build() {
        ProgressDialog progressDialog = ((ProgressDialog.Builder)((ProgressDialog.Builder)((ProgressDialog.Builder)((ProgressDialog.Builder)this.progressDialogBuilder.owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).title((ValueObserver<String>)this.title)).icon(this.icon)).build();
        return this.progressWorkerBuilder.onStarted(() -> progressDialog.setVisible(true)).onProgress(progressDialog::setProgress).onPublish(chunks -> progressDialog.setMessage(this.message((List<V>)chunks))).onDone(() -> DefaultProgressWorkerDialogBuilder.closeDialog(progressDialog)).onResult(result -> this.onResult(result, progressDialog)).onInterrupted(() -> DefaultProgressWorkerDialogBuilder.closeDialog(progressDialog)).onException(exception -> this.onException((Exception)exception, progressDialog)).onCancelled(() -> DefaultProgressWorkerDialogBuilder.closeDialog(progressDialog)).build();
    }

    private String message(List<V> chunks) {
        return chunks.isEmpty() ? null : Objects.toString(chunks.get(chunks.size() - 1));
    }

    private void onResult(T result, ProgressDialog progressDialog) {
        DefaultProgressWorkerDialogBuilder.closeDialog(progressDialog);
        if (this.onResult != null) {
            this.onResult.accept(result);
        }
    }

    private void onException(Exception exception, ProgressDialog progressDialog) {
        DefaultProgressWorkerDialogBuilder.closeDialog(progressDialog);
        if (!(exception instanceof CancelException)) {
            if (this.onException != null) {
                this.onException.accept(exception);
            } else {
                ((ExceptionDialogBuilder)((ExceptionDialogBuilder)new DefaultExceptionDialogBuilder().owner(this.owner)).title(Messages.error())).show(exception);
            }
        }
    }

    private static void closeDialog(ProgressDialog progressDialog) {
        progressDialog.setVisible(false);
        progressDialog.dispose();
    }
}

