/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.key.KeyEvents;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.KeyStroke;

final class DefaultControlMap
implements ControlMap {
    private final Map<ControlKey<?>, Value<Control>> controls = new HashMap();
    private final Map<ControlKey<?>, Value<KeyStroke>> keyStrokes = new HashMap();

    DefaultControlMap(Class<?> controlKeysClass) {
        this(Stream.of(controlKeysClass.getFields()).filter(DefaultControlMap::publicStaticFinalControlKey).map(DefaultControlMap::controlKey).collect(Collectors.toList()));
    }

    private DefaultControlMap(Collection<ControlKey<?>> controlKeys) {
        this.controls.putAll(controlKeys.stream().collect(Collectors.toMap(Function.identity(), controlKey -> Value.nullable().build())));
        this.keyStrokes.putAll(controlKeys.stream().collect(Collectors.toMap(Function.identity(), controlKey -> Value.nullable((Object)((KeyStroke)controlKey.defaultKeystroke().get())).build())));
    }

    private DefaultControlMap(DefaultControlMap controlMap) {
        controlMap.controls.forEach((controlKey, controlValue) -> this.controls.put((ControlKey<?>)controlKey, (Value<Control>)Value.nullable((Object)((Control)controlValue.get())).build()));
        controlMap.keyStrokes.forEach((controlKey, keyStrokeValue) -> this.keyStrokes.put((ControlKey<?>)controlKey, (Value<KeyStroke>)Value.nullable((Object)((KeyStroke)keyStrokeValue.get())).build()));
    }

    @Override
    public <T extends Control> Value<T> control(ControlKey<T> controlKey) {
        Value<Control> value = this.controls.get(Objects.requireNonNull(controlKey));
        if (value == null) {
            throw new IllegalArgumentException("Unknown controlKey: " + controlKey);
        }
        return value;
    }

    @Override
    public Collection<Value<Control>> controls() {
        return this.controls.values();
    }

    @Override
    public Value<KeyStroke> keyStroke(ControlKey<?> controlKey) {
        Value<KeyStroke> keyStroke = this.keyStrokes.get(Objects.requireNonNull(controlKey));
        if (keyStroke == null) {
            throw new IllegalArgumentException("Unknown controlKey: " + controlKey);
        }
        return keyStroke;
    }

    @Override
    public Optional<KeyEvents.Builder> keyEvent(ControlKey<?> controlKey) {
        Optional keyStroke = this.keyStroke(controlKey).optional();
        Optional control = this.control(controlKey).optional();
        if (keyStroke.isPresent() && control.isPresent()) {
            return Optional.of(KeyEvents.builder((KeyStroke)keyStroke.get()).action((Action)control.get()));
        }
        return Optional.empty();
    }

    @Override
    public ControlMap copy() {
        return new DefaultControlMap(this);
    }

    private static boolean publicStaticFinalControlKey(Field field) {
        return Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && ControlKey.class.isAssignableFrom(field.getType());
    }

    private static ControlKey<?> controlKey(Field field) {
        try {
            return (ControlKey)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

