/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.DefaultControlBuilderFactory;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public interface Control
extends Action {
    public Optional<String> description();

    public Optional<String> name();

    public StateObserver enabled();

    public OptionalInt mnemonic();

    public Optional<KeyStroke> keyStroke();

    public Optional<Icon> smallIcon();

    public Optional<Icon> largeIcon();

    public Optional<Color> background();

    public Optional<Color> foreground();

    public Optional<Font> font();

    public Collection<String> keys();

    @Override
    public void setEnabled(boolean var1);

    public <C extends Control, B extends Builder<C, B>> Builder<C, B> copy();

    public static CommandControl commandControl(Command command) {
        return (CommandControl)Control.builder().command(command).build();
    }

    public static CommandControl actionControl(ActionCommand actionCommand) {
        return (CommandControl)Control.builder().action(actionCommand).build();
    }

    public static ToggleControl toggleControl(Value<Boolean> value) {
        return (ToggleControl)Control.builder().toggle(value).build();
    }

    public static ToggleControl toggleControl(State state) {
        return (ToggleControl)Control.builder().toggle(state).build();
    }

    public static BuilderFactory builder() {
        return new DefaultControlBuilderFactory();
    }

    public static interface BuilderFactory {
        public CommandControl.CommandControlBuilder command(Command var1);

        public CommandControl.CommandControlBuilder action(ActionCommand var1);

        public ToggleControl.ToggleControlBuilder toggle(Value<Boolean> var1);

        public ToggleControl.ToggleControlBuilder toggle(State var1);
    }

    public static interface Command {
        public void execute() throws Exception;
    }

    public static interface ActionCommand {
        public void execute(ActionEvent var1) throws Exception;
    }

    public static interface Builder<C extends Control, B extends Builder<C, B>> {
        public B name(String var1);

        public B enabled(StateObserver var1);

        public B mnemonic(int var1);

        public B smallIcon(Icon var1);

        public B largeIcon(Icon var1);

        public B description(String var1);

        public B foreground(Color var1);

        public B background(Color var1);

        public B font(Font var1);

        public B keyStroke(KeyStroke var1);

        public B value(String var1, Object var2);

        public C build();
    }
}

