/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.ui.component.text.CaseDocumentFilter;
import is.codion.swing.common.ui.component.text.MaximumTextFieldLength;
import is.codion.swing.common.ui.component.text.SelectAllFocusListener;
import is.codion.swing.common.ui.component.text.TextFieldDocumentCase;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class TextComponents {
    private static final String TEXT_COMPONENT = "textComponent";
    private static Dimension preferredTextFieldSize;

    private TextComponents() {
    }

    public static void maximumLength(Document document, int maximumLength) {
        new MaximumTextFieldLength(document, maximumLength);
    }

    public static void upperCase(Document document) {
        new TextFieldDocumentCase(document, CaseDocumentFilter.DocumentCase.UPPERCASE);
    }

    public static void lowerCase(Document document) {
        new TextFieldDocumentCase(document, CaseDocumentFilter.DocumentCase.LOWERCASE);
    }

    public static <T extends JTextComponent> T selectAllOnFocusGained(T textComponent) {
        Objects.requireNonNull(textComponent, TEXT_COMPONENT);
        textComponent.addFocusListener(new SelectAllFocusListener(textComponent));
        return textComponent;
    }

    public static <T extends JTextComponent> T selectNoneOnFocusGained(T textComponent) {
        Objects.requireNonNull(textComponent, TEXT_COMPONENT);
        for (FocusListener listener : textComponent.getFocusListeners()) {
            if (!(listener instanceof SelectAllFocusListener)) continue;
            textComponent.removeFocusListener(listener);
        }
        return textComponent;
    }

    public static synchronized Dimension preferredTextFieldSize() {
        if (preferredTextFieldSize == null) {
            preferredTextFieldSize = new JTextField().getPreferredSize();
        }
        return preferredTextFieldSize;
    }

    public static int preferredTextFieldHeight() {
        return TextComponents.preferredTextFieldSize().height;
    }
}

