/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.component.text.AbstractTextComponentValue;
import is.codion.swing.common.ui.component.text.DefaultTextFieldBuilder;
import is.codion.swing.common.ui.component.text.HintTextField;
import is.codion.swing.common.ui.component.text.NumberDocument;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.component.text.UpdateOn;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public final class NumberField<T extends Number>
extends HintTextField {
    public static final PropertyValue<Boolean> CONVERT_GROUPING_TO_DECIMAL_SEPARATOR = Configuration.booleanValue((String)(NumberField.class.getName() + ".convertGroupingToDecimalSeparator"), (boolean)true);

    private NumberField(AbstractNumberFieldBuilder<T> builder) {
        super(builder.createDocument());
        NumberDocument<T> document = this.document();
        document.setTextComponent(this);
        DocumentFilter documentFilter = document.getDocumentFilter();
        ((NumberDocument.NumberParsingDocumentFilter)documentFilter).setMinimumValue(builder.minimumValue);
        ((NumberDocument.NumberParsingDocumentFilter)documentFilter).setMaximumValue(builder.maximumValue);
        ((NumberDocument.NumberParsingDocumentFilter)documentFilter).setSilentValidation(builder.silentValidation);
        ((NumberDocument.NumberParsingDocumentFilter)documentFilter).setConvertGroupingToDecimalSeparator(builder.convertGroupingToDecimalSeparator);
        if (document.getFormat() instanceof DecimalFormat) {
            this.addKeyListener(new GroupingSkipAdapter());
        }
        if (builder.groupingUsed != null) {
            document.setGroupingUsed(builder.groupingUsed);
        }
        if (builder.groupingSeparator != '\u0000') {
            document.setGroupingSeparator(builder.groupingSeparator);
        }
        if (document instanceof NumberDocument.DecimalDocument) {
            if (builder.maximumFractionDigits != -1) {
                ((NumberDocument.DecimalDocument)document).setMaximumFractionDigits(builder.maximumFractionDigits);
            }
            if (builder.decimalSeparator != '\u0000') {
                document.setDecimalSeparator(builder.decimalSeparator);
            }
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (this.getDocument() instanceof NumberDocument) {
            throw new UnsupportedOperationException("NumberField document can not be set");
        }
        super.setDocument(doc);
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this.document().setGroupingUsed(groupingUsed);
    }

    public void setNumber(T number) {
        this.document().setNumber(number);
    }

    public T getNumber() {
        return this.document().getNumber();
    }

    public void setValueRange(Number minimumValue, Number maximumValue) {
        ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).setMinimumValue(minimumValue);
        ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).setMaximumValue(maximumValue);
    }

    public void setMinimumValue(Number minimumValue) {
        ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).setMinimumValue(minimumValue);
    }

    public Number getMinimumValue() {
        return ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).getMinimumValue();
    }

    public void setMaximumValue(Number maximumValue) {
        ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).setMaximumValue(maximumValue);
    }

    public Number getMaximumValue() {
        return ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).getMaximumValue();
    }

    public void setSeparators(char decimalSeparator, char groupingSeparator) {
        this.document().setSeparators(decimalSeparator, groupingSeparator);
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.document().setDecimalSeparator(decimalSeparator);
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.document().setGroupingSeparator(groupingSeparator);
    }

    public int getMaximumFractionDigits() {
        NumberDocument<T> typedDocument = this.document();
        if (!(typedDocument instanceof NumberDocument.DecimalDocument)) {
            throw new IllegalStateException("This is not a decimal based NumberField");
        }
        return ((NumberDocument.DecimalDocument)typedDocument).getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        NumberDocument<T> typedDocument = this.document();
        if (!(typedDocument instanceof NumberDocument.DecimalDocument)) {
            throw new IllegalStateException("This is not a decimal based NumberField");
        }
        ((NumberDocument.DecimalDocument)this.document()).setMaximumFractionDigits(maximumFractionDigits);
    }

    public void setConvertGroupingToDecimalSeparator(boolean convertGroupingToDecimalSeparator) {
        ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).setConvertGroupingToDecimalSeparator(convertGroupingToDecimalSeparator);
    }

    public boolean isConvertGroupingToDecimalSeparator() {
        return ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).isConvertGroupingToDecimalSeparator();
    }

    public void setSilentValidation(boolean silentValidation) {
        ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).setSilentValidation(silentValidation);
    }

    public boolean isSilentValidation() {
        return ((NumberDocument.NumberParsingDocumentFilter)this.document().getDocumentFilter()).isSilentValidation();
    }

    public ValueObserver<T> value() {
        return this.document().value();
    }

    public static <T extends Number> Builder<T> builder(Class<T> valueClass) {
        return NumberField.createBuilder(valueClass, null);
    }

    public static <T extends Number> Builder<T> builder(Class<T> valueClass, Value<T> linkedValue) {
        return NumberField.createBuilder(valueClass, Objects.requireNonNull(linkedValue));
    }

    NumberDocument<T> document() {
        return (NumberDocument)super.getDocument();
    }

    private static <T extends Number> Builder<T> createBuilder(Class<T> valueClass, Value<T> linkedValue) {
        Objects.requireNonNull(valueClass);
        if (valueClass.equals(Short.class)) {
            return new DefaultShortFieldBuilder((Value<Short>)linkedValue);
        }
        if (valueClass.equals(Integer.class)) {
            return new DefaultIntegerFieldBuilder((Value<Integer>)linkedValue);
        }
        if (valueClass.equals(Long.class)) {
            return new DefaultLongFieldBuilder((Value<Long>)linkedValue);
        }
        if (valueClass.equals(Double.class)) {
            return new DefaultDoubleFieldBuilder((Value<Double>)linkedValue);
        }
        if (valueClass.equals(BigDecimal.class)) {
            return new DefaultBigDecimalFieldBuilder((Value<BigDecimal>)linkedValue);
        }
        throw new IllegalArgumentException("Unsupported number type: " + valueClass);
    }

    private static NumberFormat nonGroupingIntegerFormat() {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        return format;
    }

    private static DecimalFormat decimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(340);
        return decimalFormat;
    }

    private static abstract class AbstractNumberFieldBuilder<T extends Number>
    extends DefaultTextFieldBuilder<T, NumberField<T>, Builder<T>>
    implements Builder<T> {
        protected boolean nullable = true;
        private Number maximumValue;
        private Number minimumValue;
        private boolean silentValidation = false;
        private char groupingSeparator = '\u0000';
        private Boolean groupingUsed;
        private char decimalSeparator = '\u0000';
        private int maximumFractionDigits = -1;
        private boolean convertGroupingToDecimalSeparator = (Boolean)CONVERT_GROUPING_TO_DECIMAL_SEPARATOR.get();

        protected AbstractNumberFieldBuilder(Class<T> type, Value<T> linkedValue) {
            super(type, linkedValue);
        }

        @Override
        public Builder<T> nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public final Builder<T> valueRange(Number minimumValue, Number maximumValue) {
            this.minimumValue(minimumValue);
            this.maximumValue(maximumValue);
            return this;
        }

        @Override
        public final Builder<T> minimumValue(Number minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        @Override
        public final Builder<T> maximumValue(Number maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        @Override
        public Builder<T> silentValidation(boolean silentValidation) {
            this.silentValidation = silentValidation;
            return this;
        }

        @Override
        public final Builder<T> groupingSeparator(char groupingSeparator) {
            this.groupingSeparator = groupingSeparator;
            return this;
        }

        @Override
        public final Builder<T> groupingUsed(boolean groupingUsed) {
            this.groupingUsed = groupingUsed;
            return this;
        }

        @Override
        public final Builder<T> maximumFractionDigits(int maximumFractionDigits) {
            this.maximumFractionDigits = maximumFractionDigits;
            return this;
        }

        @Override
        public final Builder<T> decimalSeparator(char decimalSeparator) {
            if (decimalSeparator == this.groupingSeparator) {
                throw new IllegalArgumentException("Decimal separator must not be the same as grouping separator");
            }
            this.decimalSeparator = decimalSeparator;
            return this;
        }

        @Override
        public final Builder<T> convertGroupingToDecimalSeparator(boolean convertGroupingToDecimalSeparator) {
            this.convertGroupingToDecimalSeparator = convertGroupingToDecimalSeparator;
            return this;
        }

        @Override
        protected final NumberField<T> createTextField() {
            return new NumberField(this);
        }

        protected abstract NumberDocument<T> createDocument();

        @Override
        protected final void setInitialValue(NumberField<T> component, T initialValue) {
            component.setNumber(initialValue);
        }

        protected final NumberFormat initializeFormat(NumberFormat defaultFormat) {
            NumberFormat format = (NumberFormat)this.format();
            if (format != null) {
                NumberFormat cloned = (NumberFormat)format.clone();
                cloned.setGroupingUsed(format.isGroupingUsed());
                cloned.setMaximumIntegerDigits(format.getMaximumIntegerDigits());
                cloned.setMaximumFractionDigits(format.getMaximumFractionDigits());
                cloned.setMinimumFractionDigits(format.getMinimumFractionDigits());
                cloned.setRoundingMode(format.getRoundingMode());
                cloned.setCurrency(format.getCurrency());
                cloned.setParseIntegerOnly(format.isParseIntegerOnly());
                return cloned;
            }
            return defaultFormat;
        }
    }

    private final class GroupingSkipAdapter
    extends KeyAdapter {
        private GroupingSkipAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 8: {
                    this.skipGroupingSeparator(false);
                    break;
                }
                case 127: {
                    this.skipGroupingSeparator(true);
                    break;
                }
            }
        }

        private void skipGroupingSeparator(boolean forward) {
            NumberDocument numberDocument = NumberField.this.document();
            char groupingSeparator = ((DecimalFormat)numberDocument.getFormat()).getDecimalFormatSymbols().getGroupingSeparator();
            try {
                char beforeCaret;
                int caretPosition = NumberField.this.getCaretPosition();
                if (forward && caretPosition < NumberField.this.getDocument().getLength() - 1) {
                    char afterCaret = numberDocument.getText(caretPosition, 1).charAt(0);
                    if (groupingSeparator == afterCaret) {
                        NumberField.this.setCaretPosition(caretPosition + 1);
                    }
                } else if (!forward && caretPosition > 0 && groupingSeparator == (beforeCaret = numberDocument.getText(caretPosition - 1, 1).charAt(0))) {
                    NumberField.this.setCaretPosition(caretPosition - 1);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static interface Builder<T extends Number>
    extends TextFieldBuilder<T, NumberField<T>, Builder<T>> {
        public Builder<T> nullable(boolean var1);

        public Builder<T> valueRange(Number var1, Number var2);

        public Builder<T> minimumValue(Number var1);

        public Builder<T> maximumValue(Number var1);

        public Builder<T> silentValidation(boolean var1);

        public Builder<T> groupingSeparator(char var1);

        public Builder<T> groupingUsed(boolean var1);

        public Builder<T> maximumFractionDigits(int var1);

        public Builder<T> decimalSeparator(char var1);

        public Builder<T> convertGroupingToDecimalSeparator(boolean var1);
    }

    private static final class DefaultShortFieldBuilder
    extends AbstractNumberFieldBuilder<Short> {
        private DefaultShortFieldBuilder(Value<Short> linkedValue) {
            super(Short.class, linkedValue);
        }

        @Override
        protected NumberDocument<Short> createDocument() {
            return new NumberDocument<Short>(this.initializeFormat(NumberField.nonGroupingIntegerFormat()), Short.class);
        }

        @Override
        protected ComponentValue<Short, NumberField<Short>> createComponentValue(NumberField<Short> component) {
            return new ShortFieldValue(component, this.nullable, this.updateOn);
        }
    }

    private static final class DefaultIntegerFieldBuilder
    extends AbstractNumberFieldBuilder<Integer> {
        private DefaultIntegerFieldBuilder(Value<Integer> linkedValue) {
            super(Integer.class, linkedValue);
        }

        @Override
        protected NumberDocument<Integer> createDocument() {
            return new NumberDocument<Integer>(this.initializeFormat(NumberField.nonGroupingIntegerFormat()), Integer.class);
        }

        @Override
        protected ComponentValue<Integer, NumberField<Integer>> createComponentValue(NumberField<Integer> component) {
            return new IntegerFieldValue(component, this.nullable, this.updateOn);
        }
    }

    private static final class DefaultLongFieldBuilder
    extends AbstractNumberFieldBuilder<Long> {
        private DefaultLongFieldBuilder(Value<Long> linkedValue) {
            super(Long.class, linkedValue);
        }

        @Override
        protected NumberDocument<Long> createDocument() {
            return new NumberDocument<Long>(this.initializeFormat(NumberField.nonGroupingIntegerFormat()), Long.class);
        }

        @Override
        protected ComponentValue<Long, NumberField<Long>> createComponentValue(NumberField<Long> component) {
            return new LongFieldValue(component, this.nullable, this.updateOn);
        }
    }

    private static final class DefaultDoubleFieldBuilder
    extends AbstractNumberFieldBuilder<Double> {
        private DefaultDoubleFieldBuilder(Value<Double> linkedValue) {
            super(Double.class, linkedValue);
        }

        @Override
        protected NumberDocument<Double> createDocument() {
            return new NumberDocument.DecimalDocument<Double>((DecimalFormat)this.initializeFormat(NumberField.decimalFormat()), false);
        }

        @Override
        protected ComponentValue<Double, NumberField<Double>> createComponentValue(NumberField<Double> component) {
            return new DoubleFieldValue(component, this.nullable, this.updateOn);
        }
    }

    private static final class DefaultBigDecimalFieldBuilder
    extends AbstractNumberFieldBuilder<BigDecimal> {
        private DefaultBigDecimalFieldBuilder(Value<BigDecimal> linkedValue) {
            super(BigDecimal.class, linkedValue);
        }

        @Override
        protected NumberDocument<BigDecimal> createDocument() {
            return new NumberDocument.DecimalDocument<BigDecimal>((DecimalFormat)this.initializeFormat(NumberField.decimalFormat()), true);
        }

        @Override
        protected ComponentValue<BigDecimal, NumberField<BigDecimal>> createComponentValue(NumberField<BigDecimal> component) {
            return new BigDecimalFieldValue(component, this.nullable, this.updateOn);
        }
    }

    private static final class BigDecimalFieldValue
    extends AbstractTextComponentValue<BigDecimal, NumberField<BigDecimal>> {
        private BigDecimalFieldValue(NumberField<BigDecimal> doubleField, boolean nullable, UpdateOn updateOn) {
            super(doubleField, nullable ? null : BigDecimal.ZERO, updateOn);
        }

        @Override
        protected BigDecimal getComponentValue() {
            BigDecimal number = (BigDecimal)((NumberField)this.component()).getNumber();
            if (number == null) {
                return this.isNullable() ? null : BigDecimal.ZERO;
            }
            return number;
        }

        @Override
        protected void setComponentValue(BigDecimal value) {
            ((NumberField)this.component()).setNumber(value);
        }
    }

    private static final class LongFieldValue
    extends AbstractTextComponentValue<Long, NumberField<Long>> {
        private LongFieldValue(NumberField<Long> longField, boolean nullable, UpdateOn updateOn) {
            super(longField, nullable ? null : Long.valueOf(0L), updateOn);
        }

        @Override
        protected Long getComponentValue() {
            Object number = ((NumberField)this.component()).getNumber();
            if (number == null) {
                return this.isNullable() ? null : Long.valueOf(0L);
            }
            return ((Number)number).longValue();
        }

        @Override
        protected void setComponentValue(Long value) {
            ((NumberField)this.component()).setNumber(value);
        }
    }

    private static final class IntegerFieldValue
    extends AbstractTextComponentValue<Integer, NumberField<Integer>> {
        private IntegerFieldValue(NumberField<Integer> integerField, boolean nullable, UpdateOn updateOn) {
            super(integerField, nullable ? null : Integer.valueOf(0), updateOn);
        }

        @Override
        protected Integer getComponentValue() {
            Object number = ((NumberField)this.component()).getNumber();
            if (number == null) {
                return this.isNullable() ? null : Integer.valueOf(0);
            }
            return ((Number)number).intValue();
        }

        @Override
        protected void setComponentValue(Integer value) {
            ((NumberField)this.component()).setNumber(value);
        }
    }

    private static final class DoubleFieldValue
    extends AbstractTextComponentValue<Double, NumberField<Double>> {
        private DoubleFieldValue(NumberField<Double> doubleField, boolean nullable, UpdateOn updateOn) {
            super(doubleField, nullable ? null : Double.valueOf(0.0), updateOn);
        }

        @Override
        protected Double getComponentValue() {
            Object number = ((NumberField)this.component()).getNumber();
            if (number == null) {
                return this.isNullable() ? null : Double.valueOf(0.0);
            }
            return ((Number)number).doubleValue();
        }

        @Override
        protected void setComponentValue(Double value) {
            ((NumberField)this.component()).setNumber(value);
        }
    }

    private static final class ShortFieldValue
    extends AbstractTextComponentValue<Short, NumberField<Short>> {
        private ShortFieldValue(NumberField<Short> shortField, boolean nullable, UpdateOn updateOn) {
            super(shortField, nullable ? null : Short.valueOf((short)0), updateOn);
        }

        @Override
        protected Short getComponentValue() {
            Object number = ((NumberField)this.component()).getNumber();
            if (number == null) {
                return this.isNullable() ? null : Short.valueOf((short)0);
            }
            return ((Number)number).shortValue();
        }

        @Override
        protected void setComponentValue(Short value) {
            ((NumberField)this.component()).setNumber(value);
        }
    }
}

