/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.text.MaskFormatterBuilder;
import is.codion.swing.common.ui.component.text.MaskedTextFieldBuilder;
import is.codion.swing.common.ui.component.text.MaskedTextFieldValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.text.ParseException;
import javax.swing.JFormattedTextField;

final class DefaultMaskedTextFieldBuilder
extends AbstractComponentBuilder<String, JFormattedTextField, MaskedTextFieldBuilder>
implements MaskedTextFieldBuilder {
    private final MaskFormatterBuilder maskFormatterBuilder = MaskFormatterBuilder.builder();
    private int columns = -1;
    private int focusLostBehaviour = 0;

    DefaultMaskedTextFieldBuilder(Value<String> linkedValue) {
        super(linkedValue);
    }

    @Override
    public MaskedTextFieldBuilder mask(String mask) {
        this.maskFormatterBuilder.mask(mask);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder valueContainsLiteralCharacters(boolean valueContainsLiteralCharacters) {
        this.maskFormatterBuilder.valueContainsLiteralCharacters(valueContainsLiteralCharacters);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder placeholder(String placeholder) {
        this.maskFormatterBuilder.placeholder(placeholder);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder placeholderCharacter(char placeholderCharacter) {
        this.maskFormatterBuilder.placeholderCharacter(placeholderCharacter);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder allowsInvalid(boolean allowsInvalid) {
        this.maskFormatterBuilder.allowsInvalid(allowsInvalid);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder commitsOnValidEdit(boolean commitsOnValidEdit) {
        this.maskFormatterBuilder.commitsOnValidEdit(commitsOnValidEdit);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder validCharacters(String validCharacters) {
        this.maskFormatterBuilder.validCharacters(validCharacters);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder invalidCharacters(String invalidCharacters) {
        this.maskFormatterBuilder.invalidCharacters(invalidCharacters);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder overwriteMode(boolean overwriteMode) {
        this.maskFormatterBuilder.overwriteMode(overwriteMode);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder emptyStringToNullValue(boolean emptyStringToNullValue) {
        this.maskFormatterBuilder.emptyStringToNullValue(emptyStringToNullValue);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder invalidStringToNullValue(boolean invalidStringToNullValue) {
        this.maskFormatterBuilder.invalidStringToNullValue(invalidStringToNullValue);
        return this;
    }

    @Override
    public MaskedTextFieldBuilder columns(int columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public MaskedTextFieldBuilder focusLostBehaviour(int focusLostBehaviour) {
        this.focusLostBehaviour = focusLostBehaviour;
        return this;
    }

    @Override
    protected JFormattedTextField createComponent() {
        try {
            JFormattedTextField textField = new JFormattedTextField(this.maskFormatterBuilder.build());
            textField.setFocusLostBehavior(this.focusLostBehaviour);
            if (this.columns != -1) {
                textField.setColumns(this.columns);
            }
            return textField;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ComponentValue<String, JFormattedTextField> createComponentValue(JFormattedTextField component) {
        return new MaskedTextFieldValue<String>(component);
    }

    @Override
    protected void setInitialValue(JFormattedTextField component, String initialValue) {
        component.setText(initialValue);
    }
}

