/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.swing.common.model.component.text.DocumentAdapter;
import is.codion.swing.common.ui.component.text.NumberDocument;
import is.codion.swing.common.ui.component.text.UpdateOn;
import is.codion.swing.common.ui.component.text.ValidationDocumentFilter;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.Consumer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public abstract class AbstractTextComponentValue<T, C extends JTextComponent>
extends AbstractComponentValue<T, C> {
    protected AbstractTextComponentValue(C component) {
        this(component, null);
    }

    protected AbstractTextComponentValue(C component, T nullValue) {
        this(component, nullValue, UpdateOn.VALUE_CHANGE);
    }

    protected AbstractTextComponentValue(C component, T nullValue, UpdateOn updateOn) {
        super(component, nullValue);
        DocumentFilter documentFilter = ((AbstractDocument)((JTextComponent)component).getDocument()).getDocumentFilter();
        if (documentFilter instanceof ValidationDocumentFilter) {
            ((ValidationDocumentFilter)documentFilter).addValidator(arg_0 -> ((AbstractTextComponentValue)this).validate(arg_0));
        }
        if (updateOn == UpdateOn.VALUE_CHANGE) {
            Document document = ((JTextComponent)component).getDocument();
            if (document instanceof NumberDocument) {
                ((NumberDocument)document).value().addConsumer((Consumer)new NotifyOnNumberChanged());
            } else {
                document.addDocumentListener((DocumentListener)((Object)new NotifyOnContentsChanged()));
            }
        } else {
            ((Component)component).addFocusListener(new NotifyOnFocusLost());
        }
    }

    private final class NotifyOnNumberChanged
    implements Consumer<Number> {
        private NotifyOnNumberChanged() {
        }

        @Override
        public void accept(Number value) {
            AbstractTextComponentValue.this.notifyListeners();
        }
    }

    private final class NotifyOnContentsChanged
    implements DocumentAdapter {
        private NotifyOnContentsChanged() {
        }

        public void contentsChanged(DocumentEvent e) {
            AbstractTextComponentValue.this.notifyListeners();
        }
    }

    private final class NotifyOnFocusLost
    extends FocusAdapter {
        private NotifyOnFocusLost() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                AbstractTextComponentValue.this.notifyListeners();
            }
        }
    }
}

