/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.swing.common.ui.component.table.DefaultFilterTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilterTable;
import is.codion.swing.common.ui.component.table.FilterTableColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

final class FilterTableHeaderRenderer<R, C>
implements TableCellRenderer {
    private static final int SORT_ICON_SIZE = 5;
    private final FilterTable<R, C> filterTable;
    private final TableCellRenderer wrappedRenderer;
    private final TableCellRenderer columnCellRenderer;

    FilterTableHeaderRenderer(FilterTable<R, C> filterTable, FilterTableColumn<C> column) {
        this.filterTable = filterTable;
        this.wrappedRenderer = column.getHeaderRenderer();
        this.columnCellRenderer = column.getCellRenderer();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = this.wrappedRenderer == null ? this.filterTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.filterTable, value, isSelected, hasFocus, row, column) : this.wrappedRenderer.getTableCellRendererComponent(this.filterTable, value, isSelected, hasFocus, row, column);
        Font defaultFont = component.getFont();
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            TableColumn tableColumn = this.filterTable.getColumnModel().getColumn(column);
            ColumnConditionModel filterModel = (ColumnConditionModel)this.filterTable.model().filterModel().conditionModels().get(((FilterTableColumn)tableColumn).identifier());
            label.setFont(filterModel != null && (Boolean)filterModel.enabled().get() != false ? defaultFont.deriveFont(2) : defaultFont);
            label.setIcon(this.sortArrowIcon(((FilterTableColumn)tableColumn).identifier(), label.getFont().getSize() + 5));
            label.setIconTextGap(0);
            if (this.columnCellRenderer instanceof JLabel) {
                label.setHorizontalAlignment(((JLabel)((Object)this.columnCellRenderer)).getHorizontalAlignment());
            } else if (this.columnCellRenderer instanceof AbstractButton) {
                label.setHorizontalAlignment(((AbstractButton)((Object)this.columnCellRenderer)).getHorizontalAlignment());
            }
            if (this.columnCellRenderer instanceof DefaultFilterTableCellRenderer) {
                Border tableCellBorder = ((DefaultFilterTableCellRenderer)this.columnCellRenderer).settings().defaultCellBorder();
                label.setBorder(label.getBorder() == null ? tableCellBorder : BorderFactory.createCompoundBorder(label.getBorder(), tableCellBorder));
            }
        }
        return component;
    }

    private Icon sortArrowIcon(C columnIdentifier, int iconSizePixels) {
        SortOrder sortOrder = this.filterTable.sortModel().sortOrder(columnIdentifier);
        if (sortOrder == SortOrder.UNSORTED) {
            return null;
        }
        return new Arrow(sortOrder == SortOrder.DESCENDING, iconSizePixels, this.filterTable.sortModel().sortPriority(columnIdentifier));
    }

    private static final class Arrow
    implements Icon {
        private static final double PRIORITY_SIZE_RATIO = 0.8;
        private static final double PRIORITY_SIZE_CONST = 2.0;
        private static final int ALIGNMENT_CONSTANT = 6;
        private final boolean descending;
        private final int size;
        private final int priority;

        private Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)this.size / 2.0 * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            int theY = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, theY);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -theY);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

