/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.ui.component.table.DefaultFilterTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilterTableCellRenderer;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.function.Function;

public class DefaultFilterTableCellRendererBuilder<R, C>
implements FilterTableCellRenderer.Builder<R, C> {
    final FilterTableModel<R, C> tableModel;
    final C columnIdentifier;
    private final Class<?> columnClass;
    private final boolean useBooleanRenderer;
    int horizontalAlignment;
    boolean toolTipData;
    boolean columnShading = true;
    boolean alternateRowColoring = (Boolean)FilterTableCellRenderer.ALTERNATE_ROW_COLORING.get();
    int leftPadding = (Integer)FilterTableCellRenderer.TABLE_CELL_LEFT_PADDING.get();
    int rightPadding = (Integer)FilterTableCellRenderer.TABLE_CELL_RIGHT_PADDING.get();
    Function<Object, String> string = new DefaultString();
    FilterTableCellRenderer.CellColors<C> cellColors = new DefaultCellColors<C>();

    protected DefaultFilterTableCellRendererBuilder(FilterTableModel<R, C> tableModel, C columnIdentifier, Class<?> columnClass) {
        this(tableModel, columnIdentifier, columnClass, Boolean.class.equals(Objects.requireNonNull(columnClass)));
    }

    protected DefaultFilterTableCellRendererBuilder(FilterTableModel<R, C> tableModel, C columnIdentifier, Class<?> columnClass, boolean useBooleanRenderer) {
        this.tableModel = Objects.requireNonNull(tableModel);
        this.columnIdentifier = Objects.requireNonNull(columnIdentifier);
        this.columnClass = Objects.requireNonNull(columnClass);
        this.useBooleanRenderer = useBooleanRenderer;
        this.horizontalAlignment = this.defaultHorizontalAlignment();
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> toolTipData(boolean toolTipData) {
        this.toolTipData = toolTipData;
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> columnShading(boolean columnShading) {
        this.columnShading = columnShading;
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> alternateRowColoring(boolean alternateRowColoring) {
        this.alternateRowColoring = alternateRowColoring;
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> leftPadding(int leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> rightPadding(int rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> string(Function<Object, String> string) {
        this.string = Objects.requireNonNull(string);
        return this;
    }

    @Override
    public final FilterTableCellRenderer.Builder<R, C> cellColors(FilterTableCellRenderer.CellColors<C> cellColors) {
        this.cellColors = Objects.requireNonNull(cellColors);
        return this;
    }

    @Override
    public final FilterTableCellRenderer build() {
        return this.useBooleanRenderer ? new DefaultFilterTableCellRenderer.BooleanRenderer(this, this.settings(this.leftPadding, this.rightPadding, this.alternateRowColoring)) : new DefaultFilterTableCellRenderer(this, this.settings(this.leftPadding, this.rightPadding, this.alternateRowColoring));
    }

    protected FilterTableCellRenderer.Settings<C> settings(int leftPadding, int rightPadding, boolean alternateRowColoring) {
        return new FilterTableCellRenderer.Settings(leftPadding, rightPadding, alternateRowColoring);
    }

    private int defaultHorizontalAlignment() {
        if (this.useBooleanRenderer) {
            return (Integer)FilterTableCellRenderer.BOOLEAN_HORIZONTAL_ALIGNMENT.get();
        }
        if (Number.class.isAssignableFrom(this.columnClass)) {
            return (Integer)FilterTableCellRenderer.NUMERICAL_HORIZONTAL_ALIGNMENT.get();
        }
        if (Temporal.class.isAssignableFrom(this.columnClass)) {
            return (Integer)FilterTableCellRenderer.TEMPORAL_HORIZONTAL_ALIGNMENT.get();
        }
        return (Integer)FilterTableCellRenderer.HORIZONTAL_ALIGNMENT.get();
    }

    private static final class DefaultString
    implements Function<Object, String> {
        private DefaultString() {
        }

        @Override
        public String apply(Object value) {
            return value == null ? "" : value.toString();
        }
    }

    private static final class DefaultCellColors<R>
    implements FilterTableCellRenderer.CellColors<R> {
        private DefaultCellColors() {
        }
    }
}

