/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.spinner;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.spinner.SpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.SpinnerMouseWheelListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;

abstract class AbstractSpinnerBuilder<T, B extends SpinnerBuilder<T, B>>
extends AbstractComponentBuilder<T, JSpinner, B>
implements SpinnerBuilder<T, B> {
    protected final SpinnerModel spinnerModel;
    private boolean editable = true;
    private int columns = -1;
    private boolean mouseWheelScrolling = true;
    private boolean mouseWheelScrollingReversed = false;
    private int horizontalAlignment = -1;

    protected AbstractSpinnerBuilder(SpinnerModel spinnerModel, Value<T> linkedValue) {
        super(linkedValue);
        this.spinnerModel = Objects.requireNonNull(spinnerModel);
    }

    @Override
    public final B editable(boolean editable) {
        this.editable = editable;
        return (B)((SpinnerBuilder)this.self());
    }

    @Override
    public final B columns(int columns) {
        this.columns = columns;
        return (B)((SpinnerBuilder)this.self());
    }

    @Override
    public final B mouseWheelScrolling(boolean mouseWheelScrolling) {
        this.mouseWheelScrolling = mouseWheelScrolling;
        if (mouseWheelScrolling) {
            this.mouseWheelScrollingReversed = false;
        }
        return (B)((SpinnerBuilder)this.self());
    }

    @Override
    public B mouseWheelScrollingReversed(boolean mouseWheelScrollingReversed) {
        this.mouseWheelScrollingReversed = mouseWheelScrollingReversed;
        if (mouseWheelScrollingReversed) {
            this.mouseWheelScrolling = false;
        }
        return (B)((SpinnerBuilder)this.self());
    }

    @Override
    public final B horizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (B)((SpinnerBuilder)this.self());
    }

    @Override
    protected final JSpinner createComponent() {
        JSpinner spinner = this.createSpinner();
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField editorField = ((JSpinner.DefaultEditor)editor).getTextField();
            if (this.editable) {
                spinner.setFocusable(false);
            } else {
                editorField.setEditable(false);
                editorField.setFocusable(false);
            }
            if (this.columns != -1) {
                editorField.setColumns(this.columns);
            }
            if (this.horizontalAlignment != -1) {
                editorField.setHorizontalAlignment(this.horizontalAlignment);
            }
        }
        if (this.mouseWheelScrolling) {
            spinner.addMouseWheelListener(new SpinnerMouseWheelListener(this.spinnerModel, false));
        }
        if (this.mouseWheelScrollingReversed) {
            spinner.addMouseWheelListener(new SpinnerMouseWheelListener(this.spinnerModel, true));
        }
        return spinner;
    }

    @Override
    protected void setInitialValue(JSpinner component, T initialValue) {
        component.setValue(initialValue);
    }

    protected JSpinner createSpinner() {
        return new JSpinner(this.spinnerModel);
    }
}

