/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.listbox;

import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.key.KeyEvents;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

final class ListComboBox<T>
extends JComboBox<T> {
    private final Value<T> itemValue;
    private final ValueSet<T> linkedValue;

    ListComboBox(FilterComboBoxModel<T> comboBoxModel, ComponentValue<T, ? extends JComponent> itemValue, ValueSet<T> linkedValue) {
        super(comboBoxModel);
        this.itemValue = itemValue;
        this.linkedValue = linkedValue;
        this.linkedValue.link(new ListBoxItemValue<T>(itemValue, comboBoxModel));
        KeyEvents.builder(155).action(Control.commandControl(this::addItem)).enable(itemValue.component());
        KeyEvents.builder(127).action(Control.commandControl(this::removeItem)).enable(itemValue.component());
        KeyEvents.builder(127).modifiers(128).action(Control.commandControl(this::clear)).enable(itemValue.component());
    }

    @Override
    public FilterComboBoxModel<T> getModel() {
        return (FilterComboBoxModel)super.getModel();
    }

    Value<T> itemValue() {
        return this.itemValue;
    }

    ValueSet<T> linkedValue() {
        return this.linkedValue;
    }

    private void addItem() {
        FilterComboBoxModel<T> comboBoxModel = this.getModel();
        if (this.itemValue.isNotNull() && !comboBoxModel.containsItem(this.itemValue.get())) {
            comboBoxModel.add(this.itemValue.get());
            this.itemValue.clear();
            if (this.isPopupVisible()) {
                this.hidePopup();
                this.showPopup();
            }
        }
    }

    private void removeItem() {
        FilterComboBoxModel<T> comboBoxModel = this.getModel();
        int index = this.getSelectedIndex();
        if (index != -1) {
            Object selecteditem = comboBoxModel.getSelectedItem();
            comboBoxModel.remove(selecteditem);
            this.setSelectedIndex(Math.min(index, comboBoxModel.getSize() - 1));
        }
    }

    private void clear() {
        this.getModel().clear();
    }

    private static final class ListBoxItemValue<T>
    extends AbstractValue<Set<T>> {
        private final Value<T> itemValue;
        private final FilterComboBoxModel<T> comboBoxModel;

        private ListBoxItemValue(Value<T> itemValue, FilterComboBoxModel<T> comboBoxModel) {
            super(Collections.emptySet());
            this.itemValue = itemValue;
            this.comboBoxModel = comboBoxModel;
            this.comboBoxModel.addListDataListener((ListDataListener)new ComboBoxModelListener());
            itemValue.addListener(() -> this.notifyListeners());
        }

        public Set<T> get() {
            return Stream.concat(Stream.of(this.itemValue.get()), IntStream.range(0, this.comboBoxModel.getSize()).mapToObj(arg_0 -> this.comboBoxModel.getElementAt(arg_0))).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        protected void setValue(Set<T> value) {
            this.comboBoxModel.clear();
            value.forEach(arg_0 -> this.comboBoxModel.add(arg_0));
        }

        private final class ComboBoxModelListener
        implements ListDataListener {
            private ComboBoxModelListener() {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListBoxItemValue.this.notifyListeners();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListBoxItemValue.this.notifyListeners();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListBoxItemValue.this.notifyListeners();
            }
        }
    }
}

