/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.listbox;

import is.codion.common.value.ValueSet;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.listbox.ListBoxBuilder;
import is.codion.swing.common.ui.component.listbox.ListComboBox;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

final class DefaultListBoxBuilder<T>
extends AbstractComponentBuilder<Set<T>, JComboBox<T>, ListBoxBuilder<T>>
implements ListBoxBuilder<T> {
    private final ComponentValue<T, ? extends JComponent> itemValue;
    private final ValueSet<T> linkedValue;
    private Function<Object, String> string = new DefaultString();

    DefaultListBoxBuilder(ComponentValue<T, ? extends JComponent> itemValue, ValueSet<T> linkedValue) {
        this.itemValue = itemValue;
        this.linkedValue = linkedValue;
    }

    @Override
    public ListBoxBuilder<T> string(Function<Object, String> string) {
        this.string = Objects.requireNonNull(string);
        return this;
    }

    @Override
    protected JComboBox<T> createComponent() {
        FilterComboBoxModel comboBoxModel = FilterComboBoxModel.filterComboBoxModel();
        ListComboBox<T> comboBox = new ListComboBox<T>(comboBoxModel, this.itemValue, this.linkedValue);
        comboBox.setEditor(new Editor<T>(this.itemValue));
        comboBox.setEditable(true);
        comboBox.setRenderer(new Renderer(DefaultListBoxBuilder.horizontalAlignment(this.itemValue.component()), this.string));
        return comboBox;
    }

    @Override
    protected ComponentValue<Set<T>, JComboBox<T>> createComponentValue(JComboBox<T> comboBox) {
        return new ListBoxComponentValue((ListComboBox)comboBox);
    }

    @Override
    protected void setInitialValue(JComboBox<T> comboBox, Set<T> initialValue) {
        FilterComboBoxModel comboBoxModel = (FilterComboBoxModel)comboBox.getModel();
        comboBoxModel.clear();
        if (initialValue != null) {
            initialValue.forEach(arg_0 -> ((FilterComboBoxModel)comboBoxModel).add(arg_0));
        }
    }

    private static int horizontalAlignment(JComponent component) {
        if (component instanceof JTextField) {
            return ((JTextField)component).getHorizontalAlignment();
        }
        return 0;
    }

    private static final class DefaultString
    implements Function<Object, String> {
        private DefaultString() {
        }

        @Override
        public String apply(Object value) {
            return value == null ? "" : value.toString();
        }
    }

    private static final class Editor<T>
    implements ComboBoxEditor {
        private final ComponentValue<T, ? extends JComponent> itemValue;

        private Editor(ComponentValue<T, ? extends JComponent> itemValue) {
            this.itemValue = itemValue;
        }

        @Override
        public void setItem(Object anObject) {
            this.itemValue.set(anObject);
        }

        @Override
        public Component getEditorComponent() {
            return this.itemValue.component();
        }

        @Override
        public Object getItem() {
            return this.itemValue.get();
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }
    }

    private static final class Renderer<T>
    implements ListCellRenderer<T> {
        private final Function<Object, String> string;
        private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

        private Renderer(int horizontalAlignment, Function<Object, String> string) {
            this.string = string;
            this.listCellRenderer.setHorizontalAlignment(horizontalAlignment);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.listCellRenderer.getListCellRendererComponent(list, this.string.apply(value), index, isSelected, cellHasFocus);
        }
    }

    private static final class ListBoxComponentValue<T>
    extends AbstractComponentValue<Set<T>, JComboBox<T>>
    implements ComponentValue<Set<T>, JComboBox<T>> {
        public ListBoxComponentValue(ListComboBox<T> comboBox) {
            super(comboBox, Collections.emptySet());
            comboBox.linkedValue().addListener(() -> this.notifyListeners());
        }

        @Override
        protected Set<T> getComponentValue() {
            ListComboBox comboBox = (ListComboBox)this.component();
            FilterComboBoxModel comboBoxModel = comboBox.getModel();
            return Stream.concat(Stream.of(comboBox.itemValue().get()), IntStream.range(0, comboBoxModel.getSize()).mapToObj(arg_0 -> comboBoxModel.getElementAt(arg_0))).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        protected void setComponentValue(Set<T> value) {
            ListComboBox comboBox = (ListComboBox)this.component();
            FilterComboBoxModel comboBoxModel = comboBox.getModel();
            comboBoxModel.clear();
            value.forEach(arg_0 -> comboBoxModel.add(arg_0));
        }
    }
}

