/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.list;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.list.AbstractListBuilder;
import is.codion.swing.common.ui.component.list.ListBuilder;
import is.codion.swing.common.ui.component.value.AbstractComponentValue;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

final class DefaultListItemsBuilder<T>
extends AbstractListBuilder<T, List<T>, ListBuilder.Items<T>>
implements ListBuilder.Items<T> {
    private int selectionMode = 2;

    DefaultListItemsBuilder(ListModel<T> listModel, Value<List<T>> linkedValue) {
        super(listModel, linkedValue);
    }

    @Override
    public ListBuilder.Items<T> selectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        return this;
    }

    @Override
    protected JList<T> createComponent() {
        JList list = this.createList();
        list.setSelectionMode(this.selectionMode);
        return list;
    }

    @Override
    protected ComponentValue<List<T>, JList<T>> createComponentValue(JList<T> component) {
        return new ListItemsValue<T>(component);
    }

    @Override
    protected void setInitialValue(JList<T> component, List<T> initialValue) {
        ListItemsValue.setItems(component, initialValue);
    }

    private static final class ListItemsValue<T>
    extends AbstractComponentValue<List<T>, JList<T>> {
        private ListItemsValue(JList<T> list) {
            super(list, Collections.emptyList());
            list.getModel().addListDataListener(new DefaultListDataNotifier());
        }

        @Override
        protected List<T> getComponentValue() {
            return new ArrayList<T>(this.getItems());
        }

        @Override
        protected void setComponentValue(List<T> value) {
            ListItemsValue.setItems((JList)this.component(), value);
        }

        private Collection<T> getItems() {
            DefaultListModel listModel = (DefaultListModel)((JList)this.component()).getModel();
            return IntStream.range(0, listModel.getSize()).mapToObj(listModel::getElementAt).collect(Collectors.toList());
        }

        private static <T> void setItems(JList<T> list, List<T> items) {
            DefaultListModel listModel = (DefaultListModel)list.getModel();
            listModel.removeAllElements();
            if (items != null) {
                listModel.addAll(items);
            }
        }

        private final class DefaultListDataNotifier
        implements ListDataListener {
            private DefaultListDataNotifier() {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListItemsValue.this.notifyListeners();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListItemsValue.this.notifyListeners();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListItemsValue.this.notifyListeners();
            }
        }
    }
}

