/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.calendar;

import is.codion.common.item.Item;
import is.codion.common.resource.MessageBundle;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.border.Borders;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.label.LabelBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.spinner.ItemSpinnerBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlKey;
import is.codion.swing.common.ui.control.ControlMap;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public final class CalendarPanel
extends JPanel {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(CalendarPanel.class, (ResourceBundle)ResourceBundle.getBundle(CalendarPanel.class.getName()));
    private static final Set<Class<? extends Temporal>> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(LocalDate.class, LocalDateTime.class)));
    private static final int YEAR_COLUMNS = 4;
    private static final int TIME_COLUMNS = 2;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MAX_DAYS_IN_MONTH = 31;
    private static final int MAX_DAY_FILLERS = 14;
    private static final int DAY_GRID_ROWS = 6;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL);
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private final Value<LocalDate> localDateValue;
    private final Value<LocalDateTime> localDateTimeValue;
    private final Value<Integer> yearValue;
    private final Value<Month> monthValue;
    private final Value<Integer> dayValue;
    private final Value<Integer> hourValue;
    private final Value<Integer> minuteValue;
    private final State todaySelected;
    private final ControlMap controlMap;
    private final Map<Integer, JToggleButton> dayButtons;
    private final Map<Integer, State> dayStates;
    private final JPanel dayGridPanel;
    private final List<JLabel> dayFillLabels;
    private final JLabel formattedDateLabel;
    private final boolean includeTime;
    private final boolean includeTodayButton;

    CalendarPanel(DefaultBuilder builder) {
        this.includeTime = builder.includeTime;
        this.includeTodayButton = builder.includeTodayButton;
        this.controlMap = builder.controlMap;
        LocalDateTime dateTime = builder.initialValue == null ? LocalDateTime.now() : builder.initialValue;
        this.yearValue = Value.nonNull((Object)dateTime.getYear()).listener(this::updateDateTime).listener((Runnable)new LayoutDayPanelListener()).build();
        this.monthValue = Value.nonNull((Object)dateTime.getMonth()).listener(this::updateDateTime).listener((Runnable)new LayoutDayPanelListener()).build();
        this.dayValue = Value.nonNull((Object)dateTime.getDayOfMonth()).listener(this::updateDateTime).build();
        if (this.includeTime) {
            this.hourValue = Value.nonNull((Object)dateTime.getHour()).listener(this::updateDateTime).build();
            this.minuteValue = Value.nonNull((Object)dateTime.getMinute()).listener(this::updateDateTime).build();
        } else {
            this.hourValue = Value.nonNull((Object)0).build();
            this.minuteValue = Value.nonNull((Object)0).build();
        }
        this.localDateValue = Value.nullable((Object)this.createLocalDateTime().toLocalDate()).build();
        this.localDateTimeValue = Value.nullable((Object)this.createLocalDateTime()).build();
        this.todaySelected = State.state((boolean)this.todaySelected());
        this.dayStates = this.createDayStates();
        this.dayButtons = this.createDayButtons();
        this.dayFillLabels = IntStream.rangeClosed(0, 15).mapToObj(counter -> new JLabel()).collect(Collectors.toList());
        this.dayGridPanel = new JPanel(new GridLayout(6, 7));
        this.formattedDateLabel = new JLabel("", 0);
        this.formattedDateLabel.setBorder(Borders.emptyBorder());
        this.initializeUI();
        this.createControls();
        this.addKeyEvents();
        this.updateFormattedDate();
    }

    public void setLocalDate(LocalDate date) {
        this.setLocalDateTime(Objects.requireNonNull(date).atStartOfDay());
    }

    public LocalDate getLocalDate() {
        return LocalDate.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get(), (int)((Integer)this.dayValue.get()));
    }

    public void setLocalDateTime(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime);
        if (this.includeTime) {
            this.setYearMonthDayHourMinute(dateTime);
        } else {
            this.setYearMonthDay(dateTime.toLocalDate());
        }
    }

    public LocalDateTime getLocalDateTime() {
        return (LocalDateTime)this.localDateTimeValue.get();
    }

    public void requestCurrentDayButtonFocus() {
        this.dayButtons.get(this.dayValue.get()).requestFocusInWindow();
    }

    public ValueObserver<LocalDate> localDateValue() {
        return this.localDateValue.observer();
    }

    public ValueObserver<LocalDateTime> localDateTimeValue() {
        return this.localDateTimeValue.observer();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static Collection<Class<? extends Temporal>> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    void previousMonth() {
        this.subtractOne(ChronoUnit.MONTHS);
    }

    void nextMonth() {
        this.addOne(ChronoUnit.MONTHS);
    }

    void previousYear() {
        this.subtractOne(ChronoUnit.YEARS);
    }

    void nextYear() {
        this.addOne(ChronoUnit.YEARS);
    }

    void previousWeek() {
        this.subtractOne(ChronoUnit.WEEKS);
    }

    void nextWeek() {
        this.addOne(ChronoUnit.WEEKS);
    }

    void previousDay() {
        this.subtractOne(ChronoUnit.DAYS);
    }

    void nextDay() {
        this.addOne(ChronoUnit.DAYS);
    }

    void previousHour() {
        this.subtractOne(ChronoUnit.HOURS);
    }

    void nextHour() {
        this.addOne(ChronoUnit.HOURS);
    }

    void previousMinute() {
        this.subtractOne(ChronoUnit.MINUTES);
    }

    void nextMinute() {
        this.addOne(ChronoUnit.MINUTES);
    }

    private void subtractOne(ChronoUnit unit) {
        boolean dayPanelHasFocus = this.dayPanelHasFocus();
        if (unit.isDateBased()) {
            this.setYearMonthDay(this.getLocalDate().minus(1L, unit));
        } else {
            this.setYearMonthDayHourMinute(this.getLocalDateTime().minus(1L, unit));
        }
        if (dayPanelHasFocus) {
            this.requestCurrentDayButtonFocus();
        }
    }

    private void addOne(ChronoUnit unit) {
        boolean dayPanelHasFocus = this.dayPanelHasFocus();
        if (unit.isDateBased()) {
            this.setYearMonthDay(this.getLocalDate().plus(1L, unit));
        } else {
            this.setYearMonthDayHourMinute(this.getLocalDateTime().plus(1L, unit));
        }
        if (dayPanelHasFocus) {
            this.requestCurrentDayButtonFocus();
        }
    }

    private Map<Integer, State> createDayStates() {
        Map<Integer, State> states = IntStream.rangeClosed(1, 31).boxed().collect(Collectors.toMap(Integer::valueOf, this::createDayState));
        State.group(states.values());
        return states;
    }

    private State createDayState(int dayOfMonth) {
        State dayState = State.state(((Integer)this.dayValue.get() == dayOfMonth ? 1 : 0) != 0);
        dayState.addConsumer(selected -> {
            if (selected.booleanValue()) {
                this.dayValue.set((Object)dayOfMonth);
            }
        });
        return dayState;
    }

    private Map<Integer, JToggleButton> createDayButtons() {
        Insets margin = new Insets(0, 0, 0, 0);
        return this.dayStates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (JToggleButton)((ToggleButtonBuilder)((ToggleButtonBuilder)Components.toggleButton((Value<Boolean>)((Value)entry.getValue())).text(Integer.toString((Integer)entry.getKey()))).margin(margin)).build()));
    }

    private void initializeUI() {
        this.setLayout(Layouts.borderLayout());
        this.setBorder(Borders.emptyBorder());
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)this.createDayPanel(), "Center");
        this.layoutDayPanel();
    }

    private JPanel createNorthPanel() {
        return (JPanel)Components.borderLayoutPanel().northComponent((JComponent)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().centerComponent(this.formattedDateLabel).border(BorderFactory.createTitledBorder(""))).build()).centerComponent((JComponent)((PanelBuilder)Components.flowLayoutPanel(1).add(this.createYearMonthHourMinutePanel()).border(BorderFactory.createTitledBorder(""))).build()).build();
    }

    private JPanel createYearMonthHourMinutePanel() {
        JSpinner yearSpinner = this.createYearSpinner();
        JSpinner monthSpinner = this.createMonthSpinner(yearSpinner);
        JSpinner hourSpinner = this.createHourSpinner();
        JSpinner minuteSpinner = this.createMinuteSpinner();
        PanelBuilder yearMonthHourMinutePanel = Components.flexibleGridLayoutPanel(1, 0).add(monthSpinner).add(yearSpinner);
        if (this.includeTime) {
            yearMonthHourMinutePanel.addAll(hourSpinner, new JLabel(":", 0), minuteSpinner);
        }
        if (this.includeTodayButton) {
            yearMonthHourMinutePanel.add(this.createSelectTodayButton());
        }
        return (JPanel)yearMonthHourMinutePanel.build();
    }

    private JButton createSelectTodayButton() {
        return (JButton)((ButtonBuilder)Components.button(Control.commandControl(this::selectToday)).text(MESSAGES.getString("today")).mnemonic(MESSAGES.getString("today_mnemonic").charAt(0)).enabled(this.todaySelected.not())).build();
    }

    private JPanel createDayPanel() {
        return (JPanel)((BorderLayoutPanelBuilder)Components.borderLayoutPanel().northComponent(CalendarPanel.createDayHeaderPanel()).centerComponent(this.dayGridPanel).border(BorderFactory.createTitledBorder(""))).build();
    }

    private void layoutDayPanel() {
        boolean dayPanelHasFocus = this.dayPanelHasFocus();
        if (dayPanelHasFocus) {
            this.dayGridPanel.requestFocusInWindow();
        }
        this.dayGridPanel.removeAll();
        int firstDayOfMonth = LocalDate.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get(), 1).getDayOfWeek().getValue();
        int fieldCount = 0;
        int fillerCount = 0;
        for (int i = 1; i < firstDayOfMonth; ++i) {
            this.dayGridPanel.add(this.dayFillLabels.get(fillerCount++));
            ++fieldCount;
        }
        YearMonth yearMonth = YearMonth.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get());
        for (int dayOfMonth = 1; dayOfMonth <= yearMonth.lengthOfMonth(); ++dayOfMonth) {
            this.dayGridPanel.add(this.dayButtons.get(dayOfMonth));
            ++fieldCount;
        }
        while (fieldCount++ < 42) {
            this.dayGridPanel.add(this.dayFillLabels.get(fillerCount++));
        }
        this.validate();
        this.repaint();
        if (dayPanelHasFocus) {
            this.requestCurrentDayButtonFocus();
        }
    }

    private boolean dayPanelHasFocus() {
        return this.dayGridPanel.isAncestorOf(FocusManager.getCurrentManager().getFocusOwner());
    }

    private void setYearMonthDay(LocalDate localDate) {
        this.yearValue.set((Object)localDate.getYear());
        this.monthValue.set((Object)localDate.getMonth());
        this.dayValue.set((Object)localDate.getDayOfMonth());
    }

    private void setYearMonthDayHourMinute(LocalDateTime localDateTime) {
        this.setYearMonthDay(localDateTime.toLocalDate());
        this.hourValue.set((Object)localDateTime.getHour());
        this.minuteValue.set((Object)localDateTime.getMinute());
    }

    private LocalDateTime createLocalDateTime() {
        return LocalDateTime.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get(), (int)((Integer)this.dayValue.get()), (int)((Integer)this.hourValue.get()), (int)((Integer)this.minuteValue.get()));
    }

    private void updateDateTime() {
        YearMonth yearMonth = YearMonth.of((int)((Integer)this.yearValue.get()), (Month)this.monthValue.get());
        this.dayStates.get((Integer)this.dayValue.get() > yearMonth.lengthOfMonth() ? yearMonth.lengthOfMonth() : ((Integer)this.dayValue.get()).intValue()).set((Object)true);
        LocalDateTime localDateTime = this.createLocalDateTime();
        this.localDateValue.set((Object)localDateTime.toLocalDate());
        this.localDateTimeValue.set((Object)localDateTime);
        this.todaySelected.set((Object)this.todaySelected());
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateFormattedDate();
        } else {
            SwingUtilities.invokeLater(this::updateFormattedDate);
        }
    }

    private boolean todaySelected() {
        return this.getLocalDate().equals(LocalDate.now());
    }

    private void selectToday() {
        this.dayGridPanel.requestFocusInWindow();
        LocalDate now = LocalDate.now();
        this.setLocalDateTime(this.getLocalDateTime().withYear(now.getYear()).withMonth(now.getMonthValue()).withDayOfMonth(now.getDayOfMonth()));
        this.requestCurrentDayButtonFocus();
    }

    private void updateFormattedDate() {
        this.formattedDateLabel.setText(this.dateFormatter.format(this.getLocalDateTime()) + (String)(this.includeTime ? ", " + this.timeFormatter.format(this.getLocalDateTime()) : ""));
    }

    private void createControls() {
        this.controlMap.control(ControlKeys.PREVIOUS_YEAR).set((Object)Control.commandControl(this::previousYear));
        this.controlMap.control(ControlKeys.NEXT_YEAR).set((Object)Control.commandControl(this::nextYear));
        this.controlMap.control(ControlKeys.PREVIOUS_MONTH).set((Object)Control.commandControl(this::previousMonth));
        this.controlMap.control(ControlKeys.NEXT_MONTH).set((Object)Control.commandControl(this::nextMonth));
        this.controlMap.control(ControlKeys.PREVIOUS_WEEK).set((Object)Control.commandControl(this::previousWeek));
        this.controlMap.control(ControlKeys.NEXT_WEEK).set((Object)Control.commandControl(this::nextWeek));
        this.controlMap.control(ControlKeys.PREVIOUS_DAY).set((Object)Control.commandControl(this::previousDay));
        this.controlMap.control(ControlKeys.NEXT_DAY).set((Object)Control.commandControl(this::nextDay));
        this.controlMap.control(ControlKeys.PREVIOUS_HOUR).set((Object)Control.commandControl(this::previousHour));
        this.controlMap.control(ControlKeys.NEXT_HOUR).set((Object)Control.commandControl(this::nextHour));
        this.controlMap.control(ControlKeys.PREVIOUS_MINUTE).set((Object)Control.commandControl(this::previousMinute));
        this.controlMap.control(ControlKeys.NEXT_MINUTE).set((Object)Control.commandControl(this::nextMinute));
    }

    private void addKeyEvents() {
        this.controlMap.keyEvent(ControlKeys.PREVIOUS_YEAR).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.NEXT_YEAR).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.PREVIOUS_MONTH).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.NEXT_MONTH).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.PREVIOUS_WEEK).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.NEXT_WEEK).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.PREVIOUS_DAY).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        this.controlMap.keyEvent(ControlKeys.NEXT_DAY).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        if (this.includeTime) {
            this.controlMap.keyEvent(ControlKeys.PREVIOUS_HOUR).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
            this.controlMap.keyEvent(ControlKeys.NEXT_HOUR).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
            this.controlMap.keyEvent(ControlKeys.PREVIOUS_MINUTE).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
            this.controlMap.keyEvent(ControlKeys.NEXT_MINUTE).ifPresent(keyEvent -> keyEvent.condition(1).enable(this));
        }
    }

    private JSpinner createYearSpinner() {
        return (JSpinner)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(new SpinnerNumberModel(0, -9999, 9999, 1), this.yearValue).horizontalAlignment(0)).columns(4)).editable(false)).groupingUsed(false).onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
    }

    private JSpinner createMonthSpinner(JSpinner yearSpinner) {
        List<Item<Month>> monthItems = CalendarPanel.createMonthItems();
        JSpinner monthSpinner = (JSpinner)((ItemSpinnerBuilder)((ItemSpinnerBuilder)((ItemSpinnerBuilder)Components.itemSpinner(new SpinnerListModel(monthItems), this.monthValue).horizontalAlignment(0)).editable(false)).onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
        JFormattedTextField monthTextField = ((JSpinner.DefaultEditor)monthSpinner.getEditor()).getTextField();
        monthTextField.setFont(((JSpinner.DefaultEditor)yearSpinner.getEditor()).getTextField().getFont());
        monthItems.stream().mapToInt(item -> item.caption().length()).max().ifPresent(monthTextField::setColumns);
        return monthSpinner;
    }

    private JSpinner createHourSpinner() {
        return (JSpinner)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(new SpinnerNumberModel(0, 0, 23, 1), this.hourValue).horizontalAlignment(0)).columns(2)).editable(false)).decimalFormatPattern("00").onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
    }

    private JSpinner createMinuteSpinner() {
        return (JSpinner)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner(new SpinnerNumberModel(0, 0, 59, 1), this.minuteValue).horizontalAlignment(0)).columns(2)).editable(false)).decimalFormatPattern("00").onBuild(CalendarPanel::removeCtrlLeftRightArrowKeyEvents)).build();
    }

    private static JSpinner removeCtrlLeftRightArrowKeyEvents(JSpinner spinner) {
        InputMap inputMap = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().getInputMap(0);
        inputMap.put(KeyEvents.keyStroke(37, 128), "none");
        inputMap.put(KeyEvents.keyStroke(39, 128), "none");
        inputMap.put(KeyEvents.keyStroke(37, 64), "none");
        inputMap.put(KeyEvents.keyStroke(39, 64), "none");
        return spinner;
    }

    private static JPanel createDayHeaderPanel() {
        return (JPanel)Components.panel(new GridLayout(1, 7)).add(CalendarPanel.createDayLabel(DayOfWeek.MONDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.TUESDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.WEDNESDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.THURSDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.FRIDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.SATURDAY)).add(CalendarPanel.createDayLabel(DayOfWeek.SUNDAY)).build();
    }

    private static JLabel createDayLabel(DayOfWeek dayOfWeek) {
        return (JLabel)((LabelBuilder)Components.label(dayOfWeek.getDisplayName(TextStyle.SHORT, Locale.getDefault())).horizontalAlignment(0).border(Borders.emptyBorder())).build();
    }

    private static List<Item<Month>> createMonthItems() {
        return Arrays.stream(Month.values()).map(month -> Item.item((Object)month, (String)month.getDisplayName(TextStyle.SHORT, Locale.getDefault()))).collect(Collectors.toList());
    }

    private static final class DefaultBuilder
    implements Builder {
        private final ControlMap controlMap = ControlMap.controlMap(ControlKeys.class);
        private LocalDateTime initialValue;
        private boolean includeTime = false;
        private boolean includeTodayButton = false;

        private DefaultBuilder() {
        }

        @Override
        public Builder initialValue(LocalDate initialValue) {
            this.initialValue = initialValue == null ? LocalDate.now().atStartOfDay() : initialValue.atStartOfDay();
            return this.includeTime(false);
        }

        @Override
        public Builder initialValue(LocalDateTime initialValue) {
            this.initialValue = initialValue == null ? LocalDateTime.now() : initialValue;
            return this.includeTime(true);
        }

        @Override
        public Builder includeTime(boolean includeTime) {
            this.includeTime = includeTime;
            return this;
        }

        @Override
        public Builder includeTodayButton(boolean includeTodayButton) {
            this.includeTodayButton = includeTodayButton;
            return this;
        }

        @Override
        public Builder keyStroke(ControlKey<?> controlKey, KeyStroke keyStroke) {
            this.controlMap.keyStroke(controlKey).set((Object)keyStroke);
            return this;
        }

        @Override
        public CalendarPanel build() {
            return new CalendarPanel(this);
        }
    }

    private final class LayoutDayPanelListener
    implements Runnable {
        private LayoutDayPanelListener() {
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                CalendarPanel.this.layoutDayPanel();
            } else {
                SwingUtilities.invokeLater(CalendarPanel.this::layoutDayPanel);
            }
        }
    }

    public static final class ControlKeys {
        public static final ControlKey<CommandControl> PREVIOUS_YEAR = CommandControl.key("previousYear", KeyEvents.keyStroke(40, 128));
        public static final ControlKey<CommandControl> NEXT_YEAR = CommandControl.key("nextYear", KeyEvents.keyStroke(38, 128));
        public static final ControlKey<CommandControl> PREVIOUS_MONTH = CommandControl.key("previousMonth", KeyEvents.keyStroke(40, 64));
        public static final ControlKey<CommandControl> NEXT_MONTH = CommandControl.key("nextMonth", KeyEvents.keyStroke(38, 64));
        public static final ControlKey<CommandControl> PREVIOUS_WEEK = CommandControl.key("previousWeek", KeyEvents.keyStroke(38, 512));
        public static final ControlKey<CommandControl> NEXT_WEEK = CommandControl.key("nextWeek", KeyEvents.keyStroke(40, 512));
        public static final ControlKey<CommandControl> PREVIOUS_DAY = CommandControl.key("previousDay", KeyEvents.keyStroke(37, 512));
        public static final ControlKey<CommandControl> NEXT_DAY = CommandControl.key("nextDay", KeyEvents.keyStroke(39, 512));
        public static final ControlKey<CommandControl> PREVIOUS_HOUR = CommandControl.key("previousHour", KeyEvents.keyStroke(40, 576));
        public static final ControlKey<CommandControl> NEXT_HOUR = CommandControl.key("nextHour", KeyEvents.keyStroke(38, 576));
        public static final ControlKey<CommandControl> PREVIOUS_MINUTE = CommandControl.key("previousMinute", KeyEvents.keyStroke(40, 640));
        public static final ControlKey<CommandControl> NEXT_MINUTE = CommandControl.key("nextMinute", KeyEvents.keyStroke(38, 640));

        private ControlKeys() {
        }
    }

    public static interface Builder {
        public Builder initialValue(LocalDate var1);

        public Builder initialValue(LocalDateTime var1);

        public Builder includeTime(boolean var1);

        public Builder includeTodayButton(boolean var1);

        public Builder keyStroke(ControlKey<?> var1, KeyStroke var2);

        public CalendarPanel build();
    }
}

