/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.builder;

import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.Sizes;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.builder.ComponentBuilder;
import is.codion.swing.common.ui.component.button.MenuBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.key.TransferFocusOnEnter;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class AbstractComponentBuilder<T, C extends JComponent, B extends ComponentBuilder<T, C, B>>
implements ComponentBuilder<T, C, B> {
    private final List<Consumer<C>> buildConsumers = new ArrayList<Consumer<C>>(1);
    private final List<Consumer<ComponentValue<T, C>>> buildValueConsumers = new ArrayList<Consumer<ComponentValue<T, C>>>(1);
    private final List<Value<T>> linkedValues = new ArrayList<Value<T>>(1);
    private final List<ValueObserver<T>> linkedValueObservers = new ArrayList<ValueObserver<T>>(1);
    private final List<KeyEvents.Builder> keyEventBuilders = new ArrayList<KeyEvents.Builder>(1);
    private final Map<Object, Object> clientProperties = new HashMap<Object, Object>();
    private final List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private final List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
    private final List<MouseWheelListener> mouseWheelListeners = new ArrayList<MouseWheelListener>();
    private final List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private final List<ComponentListener> componentListeners = new ArrayList<ComponentListener>();
    private final List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();
    private final Map<String, PropertyChangeListener> propertyChangeListenerMap = new HashMap<String, PropertyChangeListener>();
    private final List<Value.Validator<T>> validators = new ArrayList<Value.Validator<T>>();
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();
    private C component;
    private ComponentValue<T, C> componentValue;
    private JLabel label;
    private boolean focusable = true;
    private int preferredHeight = -1;
    private int preferredWidth = -1;
    private int minimumHeight = -1;
    private int minimumWidth = -1;
    private int maximumHeight = -1;
    private int maximumWidth = -1;
    private boolean opaque = false;
    private boolean visible = true;
    private Border border;
    private boolean transferFocusOnEnter = (Boolean)TRANSFER_FOCUS_ON_ENTER.get();
    private String toolTipText;
    private Font font;
    private Color foreground;
    private Color background;
    private ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
    private StateObserver enabledObserver;
    private boolean enabled = true;
    private Function<C, JPopupMenu> popupMenu;
    private T initialValue;
    private Consumer<C> onSetVisible;
    private TransferHandler transferHandler;
    private boolean focusCycleRoot = false;

    protected AbstractComponentBuilder() {
        this(null);
    }

    protected AbstractComponentBuilder(Value<T> linkedValue) {
        if (linkedValue != null) {
            this.link(linkedValue);
        }
    }

    @Override
    public final B label(JLabel label) {
        this.label = label;
        return this.self();
    }

    @Override
    public final B focusable(boolean focusable) {
        this.focusable = focusable;
        return this.self();
    }

    @Override
    public final B preferredHeight(int preferredHeight) {
        this.preferredHeight = AbstractComponentBuilder.validatePositiveInteger(preferredHeight);
        return this.self();
    }

    @Override
    public final B preferredWidth(int preferredWidth) {
        this.preferredWidth = AbstractComponentBuilder.validatePositiveInteger(preferredWidth);
        return this.self();
    }

    @Override
    public final B preferredSize(Dimension preferredSize) {
        this.preferredHeight = preferredSize == null ? -1 : preferredSize.height;
        this.preferredWidth = preferredSize == null ? -1 : preferredSize.width;
        return this.self();
    }

    @Override
    public final B maximumHeight(int maximumHeight) {
        this.maximumHeight = AbstractComponentBuilder.validatePositiveInteger(maximumHeight);
        return this.self();
    }

    @Override
    public final B maximumWidth(int maximumWidth) {
        this.maximumWidth = AbstractComponentBuilder.validatePositiveInteger(maximumWidth);
        return this.self();
    }

    @Override
    public final B maximumSize(Dimension maximumSize) {
        this.maximumHeight = maximumSize == null ? -1 : maximumSize.height;
        this.maximumWidth = maximumSize == null ? -1 : maximumSize.width;
        return this.self();
    }

    @Override
    public final B minimumHeight(int minimumHeight) {
        this.minimumHeight = AbstractComponentBuilder.validatePositiveInteger(minimumHeight);
        return this.self();
    }

    @Override
    public final B minimumWidth(int minimumWidth) {
        this.minimumWidth = AbstractComponentBuilder.validatePositiveInteger(minimumWidth);
        return this.self();
    }

    @Override
    public final B minimumSize(Dimension minimumSize) {
        this.minimumHeight = minimumSize == null ? -1 : minimumSize.height;
        this.minimumWidth = minimumSize == null ? -1 : minimumSize.width;
        return this.self();
    }

    @Override
    public final B border(Border border) {
        this.border = border;
        return this.self();
    }

    @Override
    public final B transferFocusOnEnter(boolean transferFocusOnEnter) {
        this.transferFocusOnEnter = transferFocusOnEnter;
        return this.self();
    }

    @Override
    public final B enabled(boolean enabled) {
        this.enabled = enabled;
        return this.self();
    }

    @Override
    public final B enabled(StateObserver enabled) {
        this.enabledObserver = enabled;
        return this.self();
    }

    @Override
    public final B popupMenuControl(Function<C, Control> popupMenuControl) {
        Objects.requireNonNull(popupMenuControl);
        return this.popupMenuControls(comp -> Controls.controls((Control)popupMenuControl.apply(comp)));
    }

    @Override
    public final B popupMenuControls(Function<C, Controls> popupMenuControls) {
        Objects.requireNonNull(popupMenuControls);
        return this.popupMenu(comp -> MenuBuilder.builder((Controls)popupMenuControls.apply(comp)).createPopupMenu());
    }

    @Override
    public final B popupMenu(Function<C, JPopupMenu> popupMenu) {
        this.popupMenu = popupMenu;
        return this.self();
    }

    @Override
    public final B toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this.self();
    }

    @Override
    public final B font(Font font) {
        this.font = font;
        return this.self();
    }

    @Override
    public final B foreground(Color foreground) {
        this.foreground = foreground;
        return this.self();
    }

    @Override
    public final B background(Color background) {
        this.background = background;
        return this.self();
    }

    @Override
    public final B opaque(boolean opaque) {
        this.opaque = opaque;
        return this.self();
    }

    @Override
    public final B visible(boolean visible) {
        this.visible = visible;
        return this.self();
    }

    @Override
    public final B componentOrientation(ComponentOrientation componentOrientation) {
        this.componentOrientation = Objects.requireNonNull(componentOrientation);
        return this.self();
    }

    @Override
    public final B validator(Value.Validator<T> validator) {
        this.validators.add(Objects.requireNonNull(validator));
        return this.self();
    }

    @Override
    public final B keyEvent(KeyEvents.Builder keyEventBuilder) {
        this.keyEventBuilders.add(Objects.requireNonNull(keyEventBuilder));
        return this.self();
    }

    @Override
    public final B clientProperty(Object key, Object value) {
        this.clientProperties.put(Objects.requireNonNull(key), value);
        return this.self();
    }

    @Override
    public final B focusListener(FocusListener focusListener) {
        this.focusListeners.add(Objects.requireNonNull(focusListener));
        return this.self();
    }

    @Override
    public final B mouseListener(MouseListener mouseListener) {
        this.mouseListeners.add(Objects.requireNonNull(mouseListener));
        return this.self();
    }

    @Override
    public final B mouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.add(Objects.requireNonNull(mouseMotionListener));
        return this.self();
    }

    @Override
    public final B mouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.add(Objects.requireNonNull(mouseWheelListener));
        return this.self();
    }

    @Override
    public final B keyListener(KeyListener keyListener) {
        this.keyListeners.add(Objects.requireNonNull(keyListener));
        return this.self();
    }

    @Override
    public final B componentListener(ComponentListener componentListener) {
        this.componentListeners.add(Objects.requireNonNull(componentListener));
        return this.self();
    }

    @Override
    public final B propertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListeners.add(Objects.requireNonNull(propertyChangeListener));
        return this.self();
    }

    @Override
    public final B propertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListenerMap.put(Objects.requireNonNull(propertyName), Objects.requireNonNull(propertyChangeListener));
        return this.self();
    }

    @Override
    public final B transferHandler(TransferHandler transferHandler) {
        this.transferHandler = Objects.requireNonNull(transferHandler);
        return this.self();
    }

    @Override
    public final B focusCycleRoot(boolean focusCycleRoot) {
        this.focusCycleRoot = focusCycleRoot;
        return this.self();
    }

    @Override
    public final B onSetVisible(Consumer<C> onSetVisible) {
        this.onSetVisible = Objects.requireNonNull(onSetVisible);
        return this.self();
    }

    @Override
    public final B link(Value<T> linkedValue) {
        if (Objects.requireNonNull(linkedValue).isNullable() && !this.supportsNull()) {
            throw new IllegalArgumentException("Component does not support a nullable value");
        }
        this.linkedValues.add(linkedValue);
        return this.self();
    }

    @Override
    public final B link(ValueObserver<T> linkedValueObserver) {
        if (Objects.requireNonNull(linkedValueObserver).isNullable() && !this.supportsNull()) {
            throw new IllegalArgumentException("Component does not support a nullable value");
        }
        this.linkedValueObservers.add(linkedValueObserver);
        return this.self();
    }

    @Override
    public final B listener(Runnable listener) {
        this.listeners.add(Objects.requireNonNull(listener));
        return this.self();
    }

    @Override
    public final B consumer(Consumer<T> consumer) {
        this.consumers.add(Objects.requireNonNull(consumer));
        return this.self();
    }

    @Override
    public final B initialValue(T initialValue) {
        this.initialValue = initialValue;
        return this.self();
    }

    @Override
    public final ScrollPaneBuilder scrollPane() {
        return ScrollPaneBuilder.builder(this.build());
    }

    @Override
    public final B onBuild(Consumer<C> onBuild) {
        this.buildConsumers.add(Objects.requireNonNull(onBuild));
        return this.self();
    }

    @Override
    public final B onBuildValue(Consumer<ComponentValue<T, C>> onBuildValue) {
        this.buildValueConsumers.add(Objects.requireNonNull(onBuildValue));
        return this.self();
    }

    @Override
    public final C build() {
        return this.build(null);
    }

    @Override
    public final C build(Consumer<C> onBuild) {
        if (this.component != null) {
            return this.component;
        }
        this.component = this.createComponent();
        if (((Component)this.component).isFocusable() && !this.focusable) {
            ((Component)this.component).setFocusable(false);
        }
        this.setSizes(this.component);
        if (this.border != null) {
            ((JComponent)this.component).setBorder(this.border);
        }
        if (!this.enabled) {
            ((JComponent)this.component).setEnabled(false);
        }
        if (this.enabledObserver != null) {
            Utilities.linkToEnabledState(this.enabledObserver, new JComponent[]{this.component});
        }
        if (this.popupMenu != null) {
            ((JComponent)this.component).setComponentPopupMenu(this.popupMenu.apply(this.component));
        }
        if (this.toolTipText != null) {
            ((JComponent)this.component).setToolTipText(this.toolTipText);
        }
        if (this.font != null) {
            ((JComponent)this.component).setFont(this.font);
        }
        if (this.foreground != null) {
            ((JComponent)this.component).setForeground(this.foreground);
        }
        if (this.background != null) {
            ((JComponent)this.component).setBackground(this.background);
        }
        if (this.opaque) {
            ((JComponent)this.component).setOpaque(true);
        }
        ((JComponent)this.component).setVisible(this.visible);
        ((Component)this.component).setComponentOrientation(this.componentOrientation);
        this.clientProperties.forEach((key, value) -> ((JComponent)this.component).putClientProperty(key, value));
        if (this.onSetVisible != null) {
            new OnSetVisible<C>(this.component, this.onSetVisible);
        }
        if (this.transferFocusOnEnter) {
            this.enableTransferFocusOnEnter(this.component);
        }
        if (this.transferHandler != null) {
            ((JComponent)this.component).setTransferHandler(this.transferHandler);
        }
        if (this.focusCycleRoot) {
            ((Container)this.component).setFocusCycleRoot(true);
        }
        this.validators.forEach(validator -> this.componentValue(this.component).addValidator((Value.Validator)validator));
        if (this.linkedValues.isEmpty() && this.linkedValueObservers.isEmpty()) {
            this.setInitialValue(this.component, this.initialValue);
        }
        this.linkedValues.forEach(linkedValue -> this.componentValue(this.component).link((Value)linkedValue));
        this.linkedValueObservers.forEach(linkedValueObserver -> this.componentValue(this.component).link((ValueObserver)linkedValueObserver));
        this.listeners.forEach(listener -> this.componentValue(this.component).addListener((Runnable)listener));
        this.consumers.forEach(consumer -> this.componentValue(this.component).addConsumer((Consumer)consumer));
        if (this.label != null) {
            this.label.setLabelFor((Component)this.component);
        }
        this.keyEventBuilders.forEach(keyEventBuilder -> keyEventBuilder.enable(new JComponent[]{this.component}));
        this.focusListeners.forEach(focusListener -> ((Component)this.component).addFocusListener((FocusListener)focusListener));
        this.mouseListeners.forEach(mouseListener -> ((Component)this.component).addMouseListener((MouseListener)mouseListener));
        this.mouseMotionListeners.forEach(mouseMotionListener -> ((Component)this.component).addMouseMotionListener((MouseMotionListener)mouseMotionListener));
        this.mouseWheelListeners.forEach(mouseWheelListener -> ((Component)this.component).addMouseWheelListener((MouseWheelListener)mouseWheelListener));
        this.keyListeners.forEach(keyListener -> ((Component)this.component).addKeyListener((KeyListener)keyListener));
        this.componentListeners.forEach(componentListener -> ((Component)this.component).addComponentListener((ComponentListener)componentListener));
        this.propertyChangeListeners.forEach(listener -> ((Container)this.component).addPropertyChangeListener((PropertyChangeListener)listener));
        this.propertyChangeListenerMap.forEach((propertyName, listener) -> ((Container)this.component).addPropertyChangeListener((String)propertyName, (PropertyChangeListener)listener));
        this.buildConsumers.forEach(consumer -> consumer.accept(this.component));
        this.buildValueConsumers.forEach(consumer -> consumer.accept(this.buildValue()));
        if (onBuild != null) {
            onBuild.accept(this.component);
        }
        return this.component;
    }

    @Override
    public final ComponentValue<T, C> buildValue() {
        if (this.componentValue != null) {
            return this.componentValue;
        }
        this.build();
        if (this.componentValue == null) {
            this.componentValue = this.createComponentValue(this.component);
        }
        return this.componentValue;
    }

    @Override
    public final B clear() {
        this.component = null;
        this.componentValue = null;
        return this.self();
    }

    protected abstract C createComponent();

    protected abstract ComponentValue<T, C> createComponentValue(C var1);

    protected abstract void setInitialValue(C var1, T var2);

    protected boolean supportsNull() {
        return true;
    }

    protected void enableTransferFocusOnEnter(C component) {
        TransferFocusOnEnter.enable(component);
    }

    private ComponentValue<T, C> componentValue(C component) {
        if (this.componentValue == null) {
            this.componentValue = this.createComponentValue(component);
        }
        return this.componentValue;
    }

    private void setSizes(C component) {
        if (this.minimumHeight != -1) {
            Sizes.setMinimumHeight(component, this.minimumHeight);
        }
        if (this.minimumWidth != -1) {
            Sizes.setMinimumWidth(component, this.minimumWidth);
        }
        if (this.maximumHeight != -1) {
            Sizes.setMaximumHeight(component, this.maximumHeight);
        }
        if (this.maximumWidth != -1) {
            Sizes.setMaximumWidth(component, this.maximumWidth);
        }
        if (this.preferredHeight != -1) {
            Sizes.setPreferredHeight(component, this.preferredHeight);
        }
        if (this.preferredWidth != -1) {
            Sizes.setPreferredWidth(component, this.preferredWidth);
        }
    }

    protected final B self() {
        return (B)this;
    }

    private static int validatePositiveInteger(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
        return value;
    }

    private static final class OnSetVisible<C extends JComponent>
    implements AncestorListener {
        private final C component;
        private final Consumer<C> consumer;

        private OnSetVisible(C component, Consumer<C> consumer) {
            this.component = component;
            this.consumer = consumer;
            ((JComponent)this.component).addAncestorListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.consumer.accept(this.component);
            ((JComponent)this.component).removeAncestorListener(this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

