/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.laf;

import is.codion.common.Configuration;
import is.codion.common.model.UserPreferences;
import is.codion.common.property.PropertyValue;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.laf.DefaultLookAndFeelProvider;
import java.awt.Window;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public interface LookAndFeelProvider {
    public static final PropertyValue<Boolean> CROSS_PLATFORM = Configuration.booleanValue((String)(LookAndFeelProvider.class.getName() + ".crossPlatform"), (boolean)true);
    public static final PropertyValue<Boolean> SYSTEM = Configuration.booleanValue((String)(LookAndFeelProvider.class.getName() + ".system"), (boolean)true);

    public UIManager.LookAndFeelInfo lookAndFeelInfo();

    public void enable();

    public LookAndFeel lookAndFeel() throws Exception;

    public static LookAndFeelProvider lookAndFeelProvider(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        return new DefaultLookAndFeelProvider(lookAndFeelInfo);
    }

    public static LookAndFeelProvider lookAndFeelProvider(UIManager.LookAndFeelInfo lookAndFeelInfo, Consumer<UIManager.LookAndFeelInfo> enabler) {
        return new DefaultLookAndFeelProvider(lookAndFeelInfo, enabler);
    }

    public static void addLookAndFeel(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        LookAndFeelProvider.addLookAndFeel(LookAndFeelProvider.lookAndFeelProvider(lookAndFeelInfo));
    }

    public static void addLookAndFeel(UIManager.LookAndFeelInfo lookAndFeelInfo, Consumer<UIManager.LookAndFeelInfo> enabler) {
        LookAndFeelProvider.addLookAndFeel(LookAndFeelProvider.lookAndFeelProvider(lookAndFeelInfo, enabler));
    }

    public static void addLookAndFeel(LookAndFeelProvider lookAndFeelProvider) {
        DefaultLookAndFeelProvider.LOOK_AND_FEEL_PROVIDERS.put(Objects.requireNonNull(lookAndFeelProvider).lookAndFeelInfo().getClassName(), lookAndFeelProvider);
    }

    public static Map<String, LookAndFeelProvider> lookAndFeelProviders() {
        return Collections.unmodifiableMap(DefaultLookAndFeelProvider.LOOK_AND_FEEL_PROVIDERS);
    }

    public static Optional<LookAndFeelProvider> findLookAndFeelProvider(String className) {
        return className == null ? Optional.empty() : Optional.ofNullable(DefaultLookAndFeelProvider.LOOK_AND_FEEL_PROVIDERS.get(className));
    }

    public static String defaultLookAndFeelName(String userPreferencePropertyName) {
        return LookAndFeelProvider.defaultLookAndFeelName(userPreferencePropertyName, Utilities.systemLookAndFeelClassName());
    }

    public static String defaultLookAndFeelName(String userPreferencePropertyName, String defaultLookAndFeel) {
        return UserPreferences.getUserPreference((String)userPreferencePropertyName, (String)defaultLookAndFeel);
    }

    public static void enableLookAndFeel(LookAndFeelProvider lookAndFeelProvider) {
        Objects.requireNonNull(lookAndFeelProvider).enable();
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }
}

