/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.item.Item;
import is.codion.common.resource.MessageBundle;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.ui.component.combobox.ItemComboBoxBuilder;
import is.codion.swing.common.ui.control.CommandControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.dialog.DefaultFileSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.FontSizeSelectionDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

final class DefaultFontSizeSelectionDialogBuilder
implements FontSizeSelectionDialogBuilder {
    private JComponent owner;
    private int initialSelection = 100;

    DefaultFontSizeSelectionDialogBuilder() {
    }

    @Override
    public FontSizeSelectionDialogBuilder owner(JComponent owner) {
        this.owner = Objects.requireNonNull(owner);
        return this;
    }

    @Override
    public Control createControl(Consumer<Integer> selectedFontSize) {
        Objects.requireNonNull(selectedFontSize);
        MessageBundle resourceBundle = MessageBundle.messageBundle(DefaultFontSizeSelectionDialogBuilder.class, (ResourceBundle)ResourceBundle.getBundle(DefaultFontSizeSelectionDialogBuilder.class.getName()));
        String caption = resourceBundle.getString("select_font_size");
        return ((CommandControl.CommandControlBuilder)Control.builder().command(() -> this.selectFontSize(selectedFontSize)).name(caption)).build();
    }

    @Override
    public FontSizeSelectionDialogBuilder initialSelection(int initialSelection) {
        this.initialSelection = initialSelection;
        return this;
    }

    @Override
    public void selectFontSize(Consumer<Integer> selectedFontSize) {
        Objects.requireNonNull(selectedFontSize);
        MessageBundle resourceBundle = MessageBundle.messageBundle(DefaultFileSelectionDialogBuilder.class, (ResourceBundle)ResourceBundle.getBundle(DefaultFontSizeSelectionDialogBuilder.class.getName()));
        FontSizeSelectionPanel fontSizeSelectionPanel = new FontSizeSelectionPanel(this.initialSelection);
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(fontSizeSelectionPanel).owner(this.owner)).title(resourceBundle.getString("select_font_size"))).onOk(() -> selectedFontSize.accept(fontSizeSelectionPanel.selectedFontSize())).show();
    }

    private static final class FontSizeSelectionPanel
    extends JPanel {
        private final ItemComboBoxModel<Integer> fontSizeComboBoxModel;

        private FontSizeSelectionPanel(int initialFontSize) {
            super(Layouts.borderLayout());
            List<Item<Integer>> values = FontSizeSelectionPanel.initializeValues();
            this.fontSizeComboBoxModel = ItemComboBoxModel.itemComboBoxModel(values);
            this.add((Component)((ItemComboBoxBuilder)ItemComboBoxBuilder.builder(this.fontSizeComboBoxModel).initialValue(initialFontSize)).renderer(new FontSizeCellRenderer(values, initialFontSize)).build(), "Center");
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        }

        private int selectedFontSize() {
            return (Integer)((Item)this.fontSizeComboBoxModel.selectedValue()).get();
        }

        private static List<Item<Integer>> initializeValues() {
            ArrayList<Item<Integer>> values = new ArrayList<Item<Integer>>();
            for (int i = 50; i <= 200; i += 5) {
                values.add((Item<Integer>)Item.item((Object)i, (String)(i + "%")));
            }
            return values;
        }

        private static final class FontSizeCellRenderer
        implements ListCellRenderer<Item<Integer>> {
            private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
            private final List<Item<Integer>> values;
            private final Integer currentFontSize;

            private FontSizeCellRenderer(List<Item<Integer>> values, Integer currentFontSize) {
                this.values = values;
                this.currentFontSize = currentFontSize;
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Item<Integer>> list, Item<Integer> value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index >= 0) {
                    Font font = component.getFont();
                    int newSize = Math.round((float)font.getSize() * ((float)((Integer)this.values.get(index).get()).intValue() / (float)this.currentFontSize.doubleValue()));
                    component.setFont(new Font(font.getName(), font.getStyle(), newSize));
                }
                return component;
            }
        }
    }
}

