/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.Text;
import is.codion.common.i18n.Messages;
import is.codion.common.model.CancelException;
import is.codion.common.resource.MessageBundle;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.ComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultComponentDialogBuilder;
import is.codion.swing.common.ui.dialog.ExceptionDialogBuilder;
import is.codion.swing.common.ui.dialog.ExceptionPanel;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

class DefaultExceptionDialogBuilder
extends AbstractDialogBuilder<ExceptionDialogBuilder>
implements ExceptionDialogBuilder {
    private static final MessageBundle MESSAGES = MessageBundle.messageBundle(DefaultExceptionDialogBuilder.class, (ResourceBundle)ResourceBundle.getBundle(DefaultExceptionDialogBuilder.class.getName()));
    private static final int MAXIMUM_MESSAGE_LENGTH = 50;
    private Collection<Class<? extends Throwable>> unwrapExceptions = (Collection)WRAPPER_EXCEPTIONS.get();
    private String message;
    private boolean unwrap = true;
    private boolean systemProperties = (Boolean)SYSTEM_PROPERTIES.get();

    DefaultExceptionDialogBuilder() {
    }

    @Override
    public ExceptionDialogBuilder message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public ExceptionDialogBuilder unwrap(boolean unwrap) {
        this.unwrap = unwrap;
        return this;
    }

    @Override
    public ExceptionDialogBuilder unwrap(Collection<Class<? extends Throwable>> exceptions) {
        this.unwrapExceptions = Objects.requireNonNull(exceptions);
        return this;
    }

    @Override
    public ExceptionDialogBuilder systemProperties(boolean systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    @Override
    public void show(Throwable exception) {
        Objects.requireNonNull(exception);
        Throwable rootCause = this.unwrap ? DefaultExceptionDialogBuilder.unwrapExceptions(exception, this.unwrapExceptions) : exception;
        this.setTitle(rootCause);
        this.setMessage(rootCause);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.displayException(rootCause);
            } else {
                SwingUtilities.invokeAndWait(() -> this.displayException(rootCause));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setTitle(Throwable rootCause) {
        if (this.title == null) {
            this.title((ValueObserver<String>)Value.nullable((Object)DefaultExceptionDialogBuilder.messageTitle(rootCause)).build());
        }
    }

    private void setMessage(Throwable rootCause) {
        if (this.message == null) {
            String rootCauseMessage = rootCause.getMessage();
            if (Text.nullOrEmpty((String)rootCauseMessage)) {
                rootCauseMessage = rootCause.getCause() != null ? DefaultExceptionDialogBuilder.trimMessage(rootCause.getCause()) : DefaultExceptionDialogBuilder.trimMessage(rootCause);
            }
            this.message(rootCauseMessage);
        }
    }

    private void displayException(Throwable exception) {
        ExceptionPanel exceptionPanel = new ExceptionPanel(exception, this.message == null ? exception.getMessage() : this.message, this.systemProperties);
        ((ComponentDialogBuilder)((ComponentDialogBuilder)new DefaultComponentDialogBuilder(exceptionPanel).title((ValueObserver<String>)this.title)).owner(this.owner)).onShown(new OnShown(exceptionPanel)).show();
    }

    static Throwable unwrapExceptions(Throwable exception, Collection<Class<? extends Throwable>> exceptions) {
        boolean cyclicalCause;
        Class<? extends Throwable> exceptionClass;
        if (exception instanceof CancelException) {
            return exception;
        }
        if (exception.getCause() == null) {
            return exception;
        }
        boolean unwrap = false;
        Iterator<Class<? extends Throwable>> iterator = exceptions.iterator();
        while (iterator.hasNext() && !(unwrap = (exceptionClass = iterator.next()).isAssignableFrom(exception.getClass()))) {
        }
        boolean bl = cyclicalCause = exception.getCause() == exception;
        if (unwrap && !cyclicalCause) {
            return DefaultExceptionDialogBuilder.unwrapExceptions(exception.getCause(), exceptions);
        }
        return exception;
    }

    private static String messageTitle(Throwable e) {
        if (e instanceof FileNotFoundException) {
            return MESSAGES.getString("file_not_found");
        }
        return Messages.error();
    }

    private static String trimMessage(Throwable e) {
        String message = e.getMessage();
        if (message != null && message.length() > 50) {
            return message.substring(0, 50) + "...";
        }
        return message;
    }

    private static final class OnShown
    implements Consumer<JDialog> {
        private final ExceptionPanel exceptionPanel;

        private OnShown(ExceptionPanel exceptionPanel) {
            this.exceptionPanel = exceptionPanel;
        }

        @Override
        public void accept(JDialog dialog) {
            dialog.getRootPane().setDefaultButton(this.exceptionPanel.closeButton());
            this.exceptionPanel.detailsCheckBox().requestFocusInWindow();
        }
    }
}

