/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.ActionDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultComponentDialogBuilder;
import is.codion.swing.common.ui.key.KeyEvents;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.Border;

class DefaultActionDialogBuilder<B extends ActionDialogBuilder<B>>
extends AbstractDialogBuilder<B>
implements ActionDialogBuilder<B> {
    private final List<Action> actions = new ArrayList<Action>();
    private final JComponent component;
    private Action defaultAction;
    private Action escapeAction;
    private Border buttonPanelBorder = BorderFactory.createEmptyBorder(10, 10, 5, 10);
    private int buttonPanelConstraints = 4;
    private boolean modal = true;
    private boolean resizable = true;
    private Dimension size;
    private Consumer<JDialog> onShown;

    DefaultActionDialogBuilder(JComponent component) {
        this.component = Objects.requireNonNull(component);
    }

    @Override
    public B action(Action action) {
        this.actions.add(Objects.requireNonNull(action));
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public B defaultAction(Action defaultAction) {
        this.defaultAction = Objects.requireNonNull(defaultAction);
        if (!this.actions.contains(defaultAction)) {
            this.actions.add(defaultAction);
        }
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public B escapeAction(Action escapeAction) {
        this.escapeAction = Objects.requireNonNull(escapeAction);
        if (!this.actions.contains(escapeAction)) {
            this.actions.add(escapeAction);
        }
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final B modal(boolean modal) {
        this.modal = modal;
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final B resizable(boolean resizable) {
        this.resizable = resizable;
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final B size(Dimension size) {
        this.size = Objects.requireNonNull(size);
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final B buttonPanelConstraints(int buttonPanelConstraints) {
        this.buttonPanelConstraints = buttonPanelConstraints;
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final B buttonPanelBorder(Border buttonPanelBorder) {
        this.buttonPanelBorder = Objects.requireNonNull(buttonPanelBorder);
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final B onShown(Consumer<JDialog> onShown) {
        this.onShown = onShown;
        return (B)((ActionDialogBuilder)this.self());
    }

    @Override
    public final JDialog show() {
        JDialog dialog = this.build();
        dialog.setVisible(true);
        return dialog;
    }

    @Override
    public JDialog build() {
        if (this.actions.isEmpty()) {
            throw new IllegalStateException("No actions have been specified");
        }
        JPanel buttonPanel = (JPanel)ButtonPanelBuilder.builder(Controls.builder().actions(this.actions)).build();
        JPanel panel = (JPanel)BorderLayoutPanelBuilder.builder(new BorderLayout()).centerComponent(this.component).southComponent((JComponent)((PanelBuilder)PanelBuilder.builder(Layouts.flowLayout(this.buttonPanelConstraints)).add(buttonPanel).border(this.buttonPanelBorder)).build()).build();
        JDialog dialog = DefaultComponentDialogBuilder.createDialog(this.owner, (ValueObserver<String>)this.title, this.icon, panel, this.size, this.locationRelativeTo, this.location, this.modal, this.resizable, this.onShown, this.keyEventBuilders);
        dialog.setDefaultCloseOperation(0);
        if (this.defaultAction != null) {
            Arrays.stream(buttonPanel.getComponents()).filter(new IsButton()).map(new CastToButton()).filter(new IsButtonAction(this.defaultAction)).findFirst().ifPresent(new SetDefaultButton(dialog));
        }
        if (this.escapeAction != null) {
            dialog.addWindowListener(new EscapeOnWindowClosingListener(this.escapeAction));
            KeyEvents.builder(27).condition(2).action(this.escapeAction).enable(dialog.getRootPane());
        }
        return dialog;
    }

    protected final List<Action> actions() {
        return this.actions;
    }

    protected final JComponent component() {
        return this.component;
    }

    private static final class IsButton
    implements Predicate<Component> {
        private IsButton() {
        }

        @Override
        public boolean test(Component component) {
            return component instanceof JButton;
        }
    }

    private static final class CastToButton
    implements Function<Component, JButton> {
        private CastToButton() {
        }

        @Override
        public JButton apply(Component component) {
            return (JButton)component;
        }
    }

    private static final class IsButtonAction
    implements Predicate<JButton> {
        private final Action defaultAction;

        private IsButtonAction(Action defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public boolean test(JButton button) {
            return button.getAction() == this.defaultAction;
        }
    }

    private static final class SetDefaultButton
    implements Consumer<JButton> {
        private final JDialog dialog;

        private SetDefaultButton(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void accept(JButton button) {
            this.dialog.getRootPane().setDefaultButton(button);
        }
    }

    private static final class EscapeOnWindowClosingListener
    extends WindowAdapter {
        private final Action escapeAction;

        private EscapeOnWindowClosingListener(Action escapeAction) {
            this.escapeAction = escapeAction;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.escapeAction.actionPerformed(null);
        }
    }
}

