/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.swing.common.ui.control.AbstractControl;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.ControlId;
import is.codion.swing.common.ui.control.ControlSet;
import is.codion.swing.common.ui.control.Controls;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Action;

final class DefaultControls
extends AbstractControl
implements Controls {
    private final List<Action> actions = new ArrayList<Action>();

    DefaultControls(DefaultControlsBuilder builder) {
        super(builder);
        this.actions.addAll(builder.actions);
    }

    @Override
    public List<Action> actions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public int size() {
        return this.actions.size();
    }

    @Override
    public boolean empty() {
        return this.actions.stream().noneMatch(action -> action != SEPARATOR);
    }

    @Override
    public boolean notEmpty() {
        return !this.empty();
    }

    @Override
    public Action get(int index) {
        return this.actions.get(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public Controls.ControlsBuilder copy() {
        return new DefaultControlsBuilder(this);
    }

    static final class DefaultControlsBuilder
    extends AbstractControl.AbstractControlBuilder<Controls, Controls.ControlsBuilder>
    implements Controls.ControlsBuilder {
        private final List<Action> actions = new ArrayList<Action>();

        DefaultControlsBuilder() {
        }

        private DefaultControlsBuilder(DefaultControls controls) {
            this.enabled(controls.enabled());
            controls.keys().forEach(key -> this.value((String)key, controls.getValue((String)key)));
            this.actions.addAll(controls.actions);
        }

        @Override
        public Controls.ControlsBuilder control(Control control) {
            return this.controlAt(this.actions.size(), control);
        }

        @Override
        public Controls.ControlsBuilder control(Control.Builder<?, ?> controlBuilder) {
            return this.controlAt(this.actions.size(), controlBuilder);
        }

        @Override
        public Controls.ControlsBuilder controlAt(int index, Control control) {
            this.actions.add(index, Objects.requireNonNull(control));
            return this;
        }

        @Override
        public Controls.ControlsBuilder controlAt(int index, Control.Builder<?, ?> controlBuilder) {
            this.actions.add(index, (Action)Objects.requireNonNull(controlBuilder).build());
            return this;
        }

        @Override
        public Controls.ControlsBuilder controls(Control ... controls) {
            this.actions.addAll(Arrays.asList(Objects.requireNonNull(controls)));
            return this;
        }

        @Override
        public Controls.ControlsBuilder controls(Control.Builder<?, ?> ... controlBuilders) {
            this.actions.addAll(Arrays.stream(controlBuilders).map(new BuildControl()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Controls.ControlsBuilder action(Action action) {
            return this.actionAt(this.actions.size(), action);
        }

        @Override
        public Controls.ControlsBuilder actionAt(int index, Action action) {
            this.actions.add(index, Objects.requireNonNull(action));
            return this;
        }

        @Override
        public Controls.ControlsBuilder actions(Action ... actions) {
            return this.actions(Arrays.asList(Objects.requireNonNull(actions)));
        }

        @Override
        public Controls.ControlsBuilder actions(Collection<Action> actions) {
            this.actions.addAll(Objects.requireNonNull(actions));
            return this;
        }

        @Override
        public Controls.ControlsBuilder separator() {
            return this.separatorAt(this.actions.size());
        }

        @Override
        public Controls.ControlsBuilder separatorAt(int index) {
            if (this.actions.isEmpty() || this.actions.get(index - 1) != Controls.SEPARATOR) {
                this.actions.add(Controls.SEPARATOR);
            }
            return this;
        }

        @Override
        public Controls.ControlsBuilder remove(Action action) {
            this.actions.remove(Objects.requireNonNull(action));
            return this;
        }

        @Override
        public Controls.ControlsBuilder removeAll() {
            this.actions.clear();
            return this;
        }

        @Override
        public Controls build() {
            return new DefaultControls(this);
        }

        private static final class BuildControl
        implements Function<Control.Builder<?, ?>, Control> {
            private BuildControl() {
            }

            @Override
            public Control apply(Control.Builder<?, ?> builder) {
                return builder.build();
            }
        }
    }

    static final class DefaultConfig
    implements Controls.Config {
        private static final ControlItem SEPARATOR = new Separator();
        private final List<ControlId<?>> defaults;
        private final ControlSet controls;
        private final List<ControlItem> items = new ArrayList<ControlItem>();

        DefaultConfig(ControlSet controls, List<ControlId<?>> defaults) {
            this.defaults = Objects.requireNonNull(defaults);
            this.controls = Objects.requireNonNull(controls);
            this.defaults();
        }

        @Override
        public Controls.Config separator() {
            if (this.items.isEmpty() || this.items.get(this.items.size() - 1) != SEPARATOR) {
                this.items.add(SEPARATOR);
            }
            return this;
        }

        @Override
        public Controls.Config standard(ControlId<?> controlId) {
            this.add(Objects.requireNonNull(controlId));
            return this;
        }

        @Override
        public Controls.Config control(Control control) {
            this.items.add(new CustomAction(Objects.requireNonNull(control)));
            return this;
        }

        @Override
        public Controls.Config control(Control.Builder<?, ?> controlBuilder) {
            return this.control((Control)Objects.requireNonNull(controlBuilder).build());
        }

        @Override
        public Controls.Config action(Action action) {
            this.items.add(new CustomAction(Objects.requireNonNull(action)));
            return this;
        }

        @Override
        public Controls.Config clear() {
            this.items.clear();
            return this;
        }

        @Override
        public Controls.Config defaults() {
            return this.defaults(null);
        }

        @Override
        public Controls.Config defaults(ControlId<?> stopAt) {
            for (ControlId<?> control : this.defaults) {
                if (control == null) {
                    this.separator();
                } else {
                    this.add(control);
                }
                if (stopAt == null || control != stopAt) continue;
                break;
            }
            return this;
        }

        @Override
        public Controls create() {
            Controls.ControlsBuilder builder = Controls.builder();
            this.items.forEach(item -> item.addTo(builder));
            return (Controls)builder.build();
        }

        private void add(ControlId<?> controlIdentifier) {
            StandardControl standardControl = new StandardControl(controlIdentifier, this.controls);
            if (!this.items.contains(standardControl)) {
                this.items.add(standardControl);
            }
        }

        private static interface ControlItem {
            public void addTo(Controls.ControlsBuilder var1);
        }

        private static final class CustomAction
        implements ControlItem {
            private final Action action;

            private CustomAction(Action action) {
                this.action = action;
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder) {
                builder.action(this.action);
            }
        }

        private static final class StandardControl
        implements ControlItem {
            private final ControlId<?> tableControl;
            private final ControlSet controls;

            private StandardControl(ControlId<?> tableControl, ControlSet controls) {
                this.tableControl = tableControl;
                this.controls = controls;
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder) {
                this.controls.control(this.tableControl).optional().ifPresent(control -> {
                    if (control instanceof Controls) {
                        Controls controlsToAdd = (Controls)control;
                        if (controlsToAdd.notEmpty()) {
                            if (!controlsToAdd.name().isPresent()) {
                                controlsToAdd.actions().stream().filter(action -> action != SEPARATOR).forEach(action -> new CustomAction((Action)action).addTo(builder));
                            } else {
                                builder.control(controlsToAdd);
                            }
                        }
                    } else {
                        builder.control((Control)control);
                    }
                });
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof StandardControl)) {
                    return false;
                }
                StandardControl that = (StandardControl)object;
                return this.tableControl == that.tableControl;
            }

            public int hashCode() {
                return Objects.hash(this.tableControl);
            }
        }

        private static final class Separator
        implements ControlItem {
            private Separator() {
            }

            @Override
            public void addTo(Controls.ControlsBuilder builder) {
                builder.separator();
            }
        }
    }

    static final class DefaultSeparator
    implements Action {
        private static final String CONTROLS_SEPARATOR = "Separator";

        DefaultSeparator() {
        }

        @Override
        public Object getValue(String key) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void setEnabled(boolean b) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException(CONTROLS_SEPARATOR);
        }
    }
}

